/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jcifs.util.LogStream;

public class Config {
    public static int socketCount;
    private static Properties prp;
    private static LogStream log;
    public static String DEFAULT_OEM_ENCODING;

    Config() {
    }

    public static void load(InputStream in) throws IOException {
        block3: {
            if (in != null) {
                prp.load(in);
            }
            try {
                prp.putAll((Map<?, ?>)System.getProperties());
            }
            catch (SecurityException se) {
                if (LogStream.level <= 1) break block3;
                log.println("SecurityException: jcifs will ignore System properties");
            }
        }
    }

    public static String getProperty(String key, String def) {
        return prp.getProperty(key, def);
    }

    public static String getProperty(String key) {
        return prp.getProperty(key);
    }

    public static int getInt(String key, int def) {
        block3: {
            String s = prp.getProperty(key);
            if (s != null) {
                try {
                    def = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    if (LogStream.level <= 0) break block3;
                    nfe.printStackTrace(log);
                }
            }
        }
        return def;
    }

    public static long getLong(String key, long def) {
        block3: {
            String s = prp.getProperty(key);
            if (s != null) {
                try {
                    def = Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    if (LogStream.level <= 0) break block3;
                    nfe.printStackTrace(log);
                }
            }
        }
        return def;
    }

    public static InetAddress getInetAddress(String key, InetAddress def) {
        block3: {
            String addr = prp.getProperty(key);
            if (addr != null) {
                try {
                    def = InetAddress.getByName(addr);
                }
                catch (UnknownHostException uhe) {
                    if (LogStream.level <= 0) break block3;
                    log.println(addr);
                    uhe.printStackTrace(log);
                }
            }
        }
        return def;
    }

    public static InetAddress getLocalHost() {
        block3: {
            String addr = prp.getProperty("jcifs.smb.client.laddr");
            if (addr != null) {
                try {
                    return InetAddress.getByName(addr);
                }
                catch (UnknownHostException uhe) {
                    if (LogStream.level <= 0) break block3;
                    log.println("Ignoring jcifs.smb.client.laddr address: " + addr);
                    uhe.printStackTrace(log);
                }
            }
        }
        return null;
    }

    public static boolean getBoolean(String key, boolean def) {
        String b = Config.getProperty(key);
        if (b != null) {
            def = b.toLowerCase().equals("true");
        }
        return def;
    }

    public static InetAddress[] getInetAddressArray(String key, String delim, InetAddress[] def) {
        String p = Config.getProperty(key);
        if (p != null) {
            StringTokenizer tok = new StringTokenizer(p, delim);
            int len = tok.countTokens();
            InetAddress[] arr = new InetAddress[len];
            for (int i = 0; i < len; ++i) {
                String addr = tok.nextToken();
                try {
                    arr[i] = InetAddress.getByName(addr);
                    continue;
                }
                catch (UnknownHostException uhe) {
                    if (LogStream.level > 0) {
                        log.println(addr);
                        uhe.printStackTrace(log);
                    }
                    return def;
                }
            }
            return arr;
        }
        return def;
    }

    static {
        block11: {
            socketCount = 0;
            prp = new Properties();
            DEFAULT_OEM_ENCODING = "Cp850";
            FileInputStream in = null;
            log = LogStream.getInstance();
            try {
                String filename = System.getProperty("jcifs.properties");
                if (filename != null && filename.length() > 1) {
                    in = new FileInputStream(filename);
                }
                Config.load(in);
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                if (LogStream.level <= 0) break block11;
                ioe.printStackTrace(log);
            }
        }
        int level = Config.getInt("jcifs.util.loglevel", -1);
        if (level != -1) {
            LogStream.setLevel(level);
        }
        try {
            "".getBytes(DEFAULT_OEM_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            if (LogStream.level >= 2) {
                log.println("WARNING: The default OEM encoding " + DEFAULT_OEM_ENCODING + " does not appear to be supported by this JRE. The default encoding will be US-ASCII.");
            }
            DEFAULT_OEM_ENCODING = "US-ASCII";
        }
        if (LogStream.level >= 4) {
            try {
                prp.store(log, "JCIFS PROPERTIES");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

