/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;

public class srvsvc {
    public static String getSyntax() {
        return "4b324fc8-1670-01d3-1278-5a47bf6ee188:3.0";
    }

    public static class ShareEnumAll
    extends DcerpcMessage {
        public int retval;
        public String servername;
        public int level;
        public NdrObject info;
        public int prefmaxlen;
        public int totalentries;
        public int resume_handle;

        public int getOpnum() {
            return 15;
        }

        public ShareEnumAll(String servername, int level, NdrObject info, int prefmaxlen, int totalentries, int resume_handle) {
            this.servername = servername;
            this.level = level;
            this.info = info;
            this.prefmaxlen = prefmaxlen;
            this.totalentries = totalentries;
            this.resume_handle = resume_handle;
        }

        public void encode_in(NdrBuffer _dst) throws NdrException {
            _dst.enc_ndr_referent(this.servername, 1);
            if (this.servername != null) {
                _dst.enc_ndr_string(this.servername);
            }
            _dst.enc_ndr_long(this.level);
            int _descr = this.level;
            _dst.enc_ndr_long(_descr);
            _dst.enc_ndr_referent(this.info, 1);
            if (this.info != null) {
                _dst = _dst.deferred;
                this.info.encode(_dst);
            }
            _dst.enc_ndr_long(this.prefmaxlen);
            _dst.enc_ndr_long(this.resume_handle);
        }

        public void decode_out(NdrBuffer _src) throws NdrException {
            this.level = _src.dec_ndr_long();
            _src.dec_ndr_long();
            int _infop = _src.dec_ndr_long();
            if (_infop != 0) {
                if (this.info == null) {
                    this.info = new ShareInfoCtr0();
                }
                _src = _src.deferred;
                this.info.decode(_src);
            }
            this.totalentries = _src.dec_ndr_long();
            this.resume_handle = _src.dec_ndr_long();
            this.retval = _src.dec_ndr_long();
        }
    }

    public static class ShareInfoCtr1
    extends NdrObject {
        public int count;
        public ShareInfo1[] array;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_long(this.count);
            _dst.enc_ndr_referent(this.array, 1);
            if (this.array != null) {
                _dst = _dst.deferred;
                int _arrays = this.count;
                _dst.enc_ndr_long(_arrays);
                int _arrayi = _dst.index;
                _dst.advance(12 * _arrays);
                _dst = _dst.derive(_arrayi);
                for (int _i = 0; _i < _arrays; ++_i) {
                    this.array[_i].encode(_dst);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            this.count = _src.dec_ndr_long();
            int _arrayp = _src.dec_ndr_long();
            if (_arrayp != 0) {
                _src = _src.deferred;
                int _arrays = _src.dec_ndr_long();
                int _arrayi = _src.index;
                _src.advance(12 * _arrays);
                if (this.array == null) {
                    if (_arrays < 0 || _arrays > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.array = new ShareInfo1[_arrays];
                }
                _src = _src.derive(_arrayi);
                for (int _i = 0; _i < _arrays; ++_i) {
                    if (this.array[_i] == null) {
                        this.array[_i] = new ShareInfo1();
                    }
                    this.array[_i].decode(_src);
                }
            }
        }
    }

    public static class ShareInfo1
    extends NdrObject {
        public String netname;
        public int type;
        public String remark;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_referent(this.netname, 1);
            _dst.enc_ndr_long(this.type);
            _dst.enc_ndr_referent(this.remark, 1);
            if (this.netname != null) {
                _dst = _dst.deferred;
                _dst.enc_ndr_string(this.netname);
            }
            if (this.remark != null) {
                _dst = _dst.deferred;
                _dst.enc_ndr_string(this.remark);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            int _netnamep = _src.dec_ndr_long();
            this.type = _src.dec_ndr_long();
            int _remarkp = _src.dec_ndr_long();
            if (_netnamep != 0) {
                _src = _src.deferred;
                this.netname = _src.dec_ndr_string();
            }
            if (_remarkp != 0) {
                _src = _src.deferred;
                this.remark = _src.dec_ndr_string();
            }
        }
    }

    public static class ShareInfoCtr0
    extends NdrObject {
        public int count;
        public ShareInfo0[] array;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_long(this.count);
            _dst.enc_ndr_referent(this.array, 1);
            if (this.array != null) {
                _dst = _dst.deferred;
                int _arrays = this.count;
                _dst.enc_ndr_long(_arrays);
                int _arrayi = _dst.index;
                _dst.advance(4 * _arrays);
                _dst = _dst.derive(_arrayi);
                for (int _i = 0; _i < _arrays; ++_i) {
                    this.array[_i].encode(_dst);
                }
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            this.count = _src.dec_ndr_long();
            int _arrayp = _src.dec_ndr_long();
            if (_arrayp != 0) {
                _src = _src.deferred;
                int _arrays = _src.dec_ndr_long();
                int _arrayi = _src.index;
                _src.advance(4 * _arrays);
                if (this.array == null) {
                    if (_arrays < 0 || _arrays > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.array = new ShareInfo0[_arrays];
                }
                _src = _src.derive(_arrayi);
                for (int _i = 0; _i < _arrays; ++_i) {
                    if (this.array[_i] == null) {
                        this.array[_i] = new ShareInfo0();
                    }
                    this.array[_i].decode(_src);
                }
            }
        }
    }

    public static class ShareInfo0
    extends NdrObject {
        public String netname;

        public void encode(NdrBuffer _dst) throws NdrException {
            _dst.align(4);
            _dst.enc_ndr_referent(this.netname, 1);
            if (this.netname != null) {
                _dst = _dst.deferred;
                _dst.enc_ndr_string(this.netname);
            }
        }

        public void decode(NdrBuffer _src) throws NdrException {
            _src.align(4);
            int _netnamep = _src.dec_ndr_long();
            if (_netnamep != 0) {
                _src = _src.deferred;
                this.netname = _src.dec_ndr_string();
            }
        }
    }
}

