/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Arrays;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type2Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.HMACT64;
import jcifs.util.Hexdump;
import jcifs.util.MD4;
import jcifs.util.RC4;

public class Type3Message
extends NtlmMessage {
    private static final int DEFAULT_FLAGS;
    private static final String DEFAULT_DOMAIN;
    private static final String DEFAULT_USER;
    private static final String DEFAULT_PASSWORD;
    private static final String DEFAULT_WORKSTATION;
    private static final int LM_COMPATIBILITY;
    private static final SecureRandom RANDOM;
    private byte[] lmResponse;
    private byte[] ntResponse;
    private String domain;
    private String user;
    private String workstation;
    private byte[] masterKey = null;
    private byte[] sessionKey = null;

    public Type3Message() {
        this.setFlags(Type3Message.getDefaultFlags());
        this.setDomain(Type3Message.getDefaultDomain());
        this.setUser(Type3Message.getDefaultUser());
        this.setWorkstation(Type3Message.getDefaultWorkstation());
    }

    public Type3Message(Type2Message type2, String password, String domain, String user, String workstation, int flags) {
        this.setFlags(flags | Type3Message.getDefaultFlags(type2));
        if (workstation == null) {
            workstation = Type3Message.getDefaultWorkstation();
        }
        this.setWorkstation(workstation);
        this.setDomain(domain);
        this.setUser(user);
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: {
                if ((this.getFlags() & 0x80000) == 0) {
                    this.setLMResponse(Type3Message.getLMResponse(type2, password));
                    this.setNTResponse(Type3Message.getNTResponse(type2, password));
                    break;
                }
                byte[] clientChallenge = new byte[24];
                RANDOM.nextBytes(clientChallenge);
                Arrays.fill(clientChallenge, 8, 24, (byte)0);
                byte[] responseKeyNT = NtlmPasswordAuthentication.nTOWFv1(password);
                byte[] ntlm2Response = NtlmPasswordAuthentication.getNTLM2Response(responseKeyNT, type2.getChallenge(), clientChallenge);
                this.setLMResponse(clientChallenge);
                this.setNTResponse(ntlm2Response);
                if ((this.getFlags() & 0x10) != 16) break;
                byte[] sessionNonce = new byte[16];
                System.arraycopy(type2.getChallenge(), 0, sessionNonce, 0, 8);
                System.arraycopy(clientChallenge, 0, sessionNonce, 8, 8);
                MD4 md4 = new MD4();
                md4.update(responseKeyNT);
                byte[] userSessionKey = md4.digest();
                HMACT64 hmac = new HMACT64(userSessionKey);
                hmac.update(sessionNonce);
                byte[] ntlm2SessionKey = hmac.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.masterKey = new byte[16];
                    RANDOM.nextBytes(this.masterKey);
                    byte[] exchangedKey = new byte[16];
                    RC4 rc4 = new RC4(ntlm2SessionKey);
                    rc4.update(this.masterKey, 0, 16, exchangedKey, 0);
                    this.setSessionKey(exchangedKey);
                    break;
                }
                this.masterKey = ntlm2SessionKey;
                this.setSessionKey(this.masterKey);
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(type2, password);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] responseKeyNT = NtlmPasswordAuthentication.nTOWFv2(domain, user, password);
                byte[] clientChallenge = new byte[8];
                RANDOM.nextBytes(clientChallenge);
                this.setLMResponse(Type3Message.getLMv2Response(type2, domain, user, password, clientChallenge));
                byte[] clientChallenge2 = new byte[8];
                RANDOM.nextBytes(clientChallenge2);
                this.setNTResponse(Type3Message.getNTLMv2Response(type2, responseKeyNT, clientChallenge2));
                if ((this.getFlags() & 0x10) != 16) break;
                HMACT64 hmac = new HMACT64(responseKeyNT);
                hmac.update(this.ntResponse, 0, 16);
                byte[] userSessionKey = hmac.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.masterKey = new byte[16];
                    RANDOM.nextBytes(this.masterKey);
                    byte[] exchangedKey = new byte[16];
                    RC4 rc4 = new RC4(userSessionKey);
                    rc4.update(this.masterKey, 0, 16, exchangedKey, 0);
                    this.setSessionKey(exchangedKey);
                    break;
                }
                this.masterKey = userSessionKey;
                this.setSessionKey(this.masterKey);
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(type2, password));
                this.setNTResponse(Type3Message.getNTResponse(type2, password));
            }
        }
    }

    public byte[] getLMResponse() {
        return this.lmResponse;
    }

    public void setLMResponse(byte[] lmResponse) {
        this.lmResponse = lmResponse;
    }

    public byte[] getNTResponse() {
        return this.ntResponse;
    }

    public void setNTResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public byte[] toByteArray() {
        try {
            int flags = this.getFlags();
            boolean unicode = (flags & 1) != 0;
            String oem = unicode ? null : Type3Message.getOEMEncoding();
            String domainName = this.getDomain();
            byte[] domain = null;
            if (domainName != null && domainName.length() != 0) {
                domain = unicode ? domainName.getBytes("UTF-16LE") : domainName.getBytes(oem);
            }
            int domainLength = domain != null ? domain.length : 0;
            String userName = this.getUser();
            byte[] user = null;
            if (userName != null && userName.length() != 0) {
                user = unicode ? userName.getBytes("UTF-16LE") : userName.toUpperCase().getBytes(oem);
            }
            int userLength = user != null ? user.length : 0;
            String workstationName = this.getWorkstation();
            byte[] workstation = null;
            if (workstationName != null && workstationName.length() != 0) {
                workstation = unicode ? workstationName.getBytes("UTF-16LE") : workstationName.toUpperCase().getBytes(oem);
            }
            int workstationLength = workstation != null ? workstation.length : 0;
            byte[] lmResponse = this.getLMResponse();
            int lmLength = lmResponse != null ? lmResponse.length : 0;
            byte[] ntResponse = this.getNTResponse();
            int ntLength = ntResponse != null ? ntResponse.length : 0;
            byte[] sessionKey = this.getSessionKey();
            int keyLength = sessionKey != null ? sessionKey.length : 0;
            byte[] type3 = new byte[64 + domainLength + userLength + workstationLength + lmLength + ntLength + keyLength];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, type3, 0, 8);
            Type3Message.writeULong(type3, 8, 3);
            int offset = 64;
            Type3Message.writeSecurityBuffer(type3, 12, offset, lmResponse);
            Type3Message.writeSecurityBuffer(type3, 20, offset += lmLength, ntResponse);
            Type3Message.writeSecurityBuffer(type3, 28, offset += ntLength, domain);
            Type3Message.writeSecurityBuffer(type3, 36, offset += domainLength, user);
            Type3Message.writeSecurityBuffer(type3, 44, offset += userLength, workstation);
            Type3Message.writeSecurityBuffer(type3, 52, offset += workstationLength, sessionKey);
            Type3Message.writeULong(type3, 60, flags);
            return type3;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        String user = this.getUser();
        String domain = this.getDomain();
        String workstation = this.getWorkstation();
        byte[] lmResponse = this.getLMResponse();
        byte[] ntResponse = this.getNTResponse();
        byte[] sessionKey = this.getSessionKey();
        return "Type3Message[domain=" + domain + ",user=" + user + ",workstation=" + workstation + ",lmResponse=" + (lmResponse == null ? "null" : "<" + lmResponse.length + " bytes>") + ",ntResponse=" + (ntResponse == null ? "null" : "<" + ntResponse.length + " bytes>") + ",sessionKey=" + (sessionKey == null ? "null" : "<" + sessionKey.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return DEFAULT_FLAGS;
    }

    public static int getDefaultFlags(Type2Message type2) {
        if (type2 == null) {
            return DEFAULT_FLAGS;
        }
        int flags = 512;
        return flags |= (type2.getFlags() & 1) != 0 ? 1 : 2;
    }

    public static byte[] getLMResponse(Type2Message type2, String password) {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getPreNTLMResponse(password, type2.getChallenge());
    }

    public static byte[] getLMv2Response(Type2Message type2, String domain, String user, String password, byte[] clientChallenge) {
        if (type2 == null || domain == null || user == null || password == null || clientChallenge == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getLMv2Response(domain, user, password, type2.getChallenge(), clientChallenge);
    }

    public static byte[] getNTLMv2Response(Type2Message type2, byte[] responseKeyNT, byte[] clientChallenge) {
        if (type2 == null || responseKeyNT == null || clientChallenge == null) {
            return null;
        }
        long nanos1601 = (System.currentTimeMillis() + 11644473600000L) * 10000L;
        return NtlmPasswordAuthentication.getNTLMv2Response(responseKeyNT, type2.getChallenge(), clientChallenge, nanos1601, type2.getTargetInformation());
    }

    public static byte[] getNTResponse(Type2Message type2, String password) {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getNTLMResponse(password, type2.getChallenge());
    }

    public static String getDefaultDomain() {
        return DEFAULT_DOMAIN;
    }

    public static String getDefaultUser() {
        return DEFAULT_USER;
    }

    public static String getDefaultWorkstation() {
        return DEFAULT_WORKSTATION;
    }

    static {
        RANDOM = new SecureRandom();
        DEFAULT_FLAGS = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
        DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
        DEFAULT_USER = Config.getProperty("jcifs.smb.client.username", null);
        DEFAULT_PASSWORD = Config.getProperty("jcifs.smb.client.password", null);
        String defaultWorkstation = null;
        try {
            defaultWorkstation = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DEFAULT_WORKSTATION = defaultWorkstation;
        LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 3);
    }
}

