/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.TransactNamedPipeInputStream;
import jcifs.smb.TransactNamedPipeOutputStream;

public class SmbNamedPipe
extends SmbFile {
    InputStream pipeIn;
    OutputStream pipeOut;
    int pipeType;

    public SmbNamedPipe(String url, int pipeType, NtlmPasswordAuthentication auth) throws MalformedURLException, UnknownHostException {
        super(url, auth);
        this.pipeType = pipeType;
        this.type = 16;
    }

    public InputStream getNamedPipeInputStream() throws IOException {
        if (this.pipeIn == null) {
            this.pipeIn = (this.pipeType & 0x100) == 256 || (this.pipeType & 0x200) == 512 ? new TransactNamedPipeInputStream(this) : new SmbFileInputStream(this, this.pipeType & 0xFFFF00FF | 0x20);
        }
        return this.pipeIn;
    }

    public OutputStream getNamedPipeOutputStream() throws IOException {
        if (this.pipeOut == null) {
            this.pipeOut = (this.pipeType & 0x100) == 256 || (this.pipeType & 0x200) == 512 ? new TransactNamedPipeOutputStream(this) : new SmbFileOutputStream(this, false, this.pipeType & 0xFFFF00FF | 0x20);
        }
        return this.pipeOut;
    }
}

