/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.smb.NtlmContext;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.util.LogStream;

public final class SmbSession {
    private static final String LOGON_SHARE = Config.getProperty("jcifs.smb.client.logonShare", null);
    private static final int LOOKUP_RESP_LIMIT = Config.getInt("jcifs.netbios.lookupRespLimit", 3);
    private static final String DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String USERNAME = Config.getProperty("jcifs.smb.client.username", null);
    private static final int CACHE_POLICY = Config.getInt("jcifs.netbios.cachePolicy", 600) * 60;
    static NbtAddress[] dc_list = null;
    int connectionState;
    int uid;
    Vector trees;
    private UniAddress address;
    private int port;
    private int localPort;
    private InetAddress localAddr;
    SmbTransport transport = null;
    NtlmPasswordAuthentication auth;
    long expiration;
    String netbiosName = null;

    SmbSession(UniAddress address, int port, InetAddress localAddr, int localPort, NtlmPasswordAuthentication auth) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.auth = auth;
        this.trees = new Vector();
        this.connectionState = 0;
    }

    synchronized SmbTree getSmbTree(String share, String service) {
        SmbTree t;
        if (share == null) {
            share = "IPC$";
        }
        Enumeration e = this.trees.elements();
        while (e.hasMoreElements()) {
            t = (SmbTree)e.nextElement();
            if (!t.matches(share, service)) continue;
            return t;
        }
        t = new SmbTree(this, share, service);
        this.trees.addElement(t);
        return t;
    }

    boolean matches(NtlmPasswordAuthentication auth) {
        return this.auth == auth || this.auth.equals(auth);
    }

    synchronized SmbTransport transport() {
        if (this.transport == null) {
            this.transport = SmbTransport.getSmbTransport(this.address, this.port, this.localAddr, this.localPort, null);
        }
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (response != null) {
                response.received = false;
            }
            this.expiration = System.currentTimeMillis() + (long)SmbTransport.SO_TIMEOUT;
            this.sessionSetup(request, response);
            if (response != null && response.received) {
                return;
            }
            if (request instanceof SmbComTreeConnectAndX) {
                SmbComTreeConnectAndX tcax = (SmbComTreeConnectAndX)request;
                if (this.netbiosName != null && tcax.path.endsWith("\\IPC$")) {
                    tcax.path = "\\\\" + this.netbiosName + "\\IPC$";
                }
            }
            request.uid = this.uid;
            request.auth = this.auth;
            try {
                this.transport.send(request, response);
            }
            catch (SmbException se) {
                if (request instanceof SmbComTreeConnectAndX) {
                    this.logoff(true);
                }
                request.digest = null;
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            NtlmContext nctx = null;
            SmbException ex = null;
            byte[] token = new byte[]{};
            int state = 10;
            while (this.connectionState != 0) {
                if (this.connectionState == 2 || this.connectionState == 3) {
                    return;
                }
                try {
                    this.transport.wait();
                }
                catch (InterruptedException ie) {
                    throw new SmbException(ie.getMessage(), (Throwable)ie);
                }
            }
            this.connectionState = 1;
            try {
                this.transport.connect();
                if (LogStream.level >= 4) {
                    SmbTransport.log.println("sessionSetup: accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
                }
                this.uid = 0;
                block27: do {
                    switch (state) {
                        case 10: {
                            if (this.auth != NtlmPasswordAuthentication.ANONYMOUS && this.transport.hasCapability(Integer.MIN_VALUE)) {
                                state = 20;
                                break;
                            }
                            SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, andx, this.auth);
                            SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(andxResponse);
                            if (this.transport.isSignatureSetupRequired(this.auth)) {
                                if (this.auth.hashesExternal && NtlmPasswordAuthentication.DEFAULT_PASSWORD != "") {
                                    this.transport.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(LOGON_SHARE, null).treeConnect(null, null);
                                } else {
                                    byte[] signingKey = this.auth.getSigningKey(this.transport.server.encryptionKey);
                                    request.digest = new SigningDigest(signingKey, false);
                                }
                            }
                            request.auth = this.auth;
                            try {
                                this.transport.send(request, response);
                            }
                            catch (SmbAuthException sae) {
                                throw sae;
                            }
                            catch (SmbException se) {
                                ex = se;
                            }
                            if (response.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username) && this.transport.server.security != 0) {
                                throw new SmbAuthException(-1073741715);
                            }
                            if (ex != null) {
                                throw ex;
                            }
                            this.uid = response.uid;
                            if (request.digest != null) {
                                this.transport.digest = request.digest;
                            }
                            this.connectionState = 2;
                            state = 0;
                            break;
                        }
                        case 20: {
                            byte[] signingKey;
                            if (nctx == null) {
                                boolean doSigning = (this.transport.flags2 & 4) != 0;
                                nctx = new NtlmContext(this.auth, doSigning);
                            }
                            if (LogStream.level >= 4) {
                                SmbTransport.log.println(nctx);
                            }
                            if (nctx.isEstablished()) {
                                this.netbiosName = nctx.getNetbiosName();
                                this.connectionState = 2;
                                state = 0;
                                break;
                            }
                            try {
                                token = nctx.initSecContext(token, 0, token.length);
                            }
                            catch (SmbException se) {
                                try {
                                    this.transport.disconnect(true);
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                this.uid = 0;
                                throw se;
                            }
                            if (token == null) continue block27;
                            SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, null, token);
                            SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(null);
                            if (this.transport.isSignatureSetupRequired(this.auth) && (signingKey = nctx.getSigningKey()) != null) {
                                request.digest = new SigningDigest(signingKey, true);
                            }
                            request.uid = this.uid;
                            this.uid = 0;
                            try {
                                this.transport.send(request, response);
                            }
                            catch (SmbAuthException sae) {
                                throw sae;
                            }
                            catch (SmbException se) {
                                ex = se;
                                try {
                                    this.transport.disconnect(true);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (response.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username)) {
                                throw new SmbAuthException(-1073741715);
                            }
                            if (ex != null) {
                                throw ex;
                            }
                            this.uid = response.uid;
                            if (request.digest != null) {
                                this.transport.digest = request.digest;
                            }
                            token = response.blob;
                            break;
                        }
                        default: {
                            throw new SmbException("Unexpected session setup state: " + state);
                        }
                    }
                } while (state != 0);
            }
            catch (SmbException se) {
                this.logoff(true);
                this.connectionState = 0;
                throw se;
            }
            finally {
                this.transport.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoff(boolean inError) {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (this.connectionState != 2) {
                return;
            }
            this.connectionState = 3;
            this.netbiosName = null;
            Enumeration e = this.trees.elements();
            while (e.hasMoreElements()) {
                SmbTree t = (SmbTree)e.nextElement();
                t.treeDisconnect(inError);
            }
            if (!inError && this.transport.server.security != 0) {
                SmbComLogoffAndX request = new SmbComLogoffAndX(null);
                request.uid = this.uid;
                try {
                    this.transport.send(request, null);
                }
                catch (SmbException se) {
                    // empty catch block
                }
                this.uid = 0;
            }
            this.connectionState = 0;
            this.transport.notifyAll();
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",connectionState=" + this.connectionState + "]";
    }
}

