/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.AllocInfo;
import jcifs.smb.SmbComTransactionResponse;

class Trans2QueryFSInformationResponse
extends SmbComTransactionResponse {
    private int informationLevel;
    AllocInfo info;

    Trans2QueryFSInformationResponse(int informationLevel) {
        this.informationLevel = informationLevel;
        this.command = (byte)50;
        this.subCommand = (byte)3;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        switch (this.informationLevel) {
            case 1: {
                return this.readSmbInfoAllocationWireFormat(buffer, bufferIndex);
            }
            case 259: {
                return this.readSmbQueryFSSizeInfoWireFormat(buffer, bufferIndex);
            }
            case 1007: {
                return this.readFsFullSizeInformationWireFormat(buffer, bufferIndex);
            }
        }
        return 0;
    }

    int readSmbInfoAllocationWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbInfoAllocation info = new SmbInfoAllocation();
        info.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 4);
        info.alloc = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 4);
        info.free = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 4);
        info.bytesPerSect = Trans2QueryFSInformationResponse.readInt2(buffer, bufferIndex += 4);
        this.info = info;
        return (bufferIndex += 4) - start;
    }

    int readSmbQueryFSSizeInfoWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbInfoAllocation info = new SmbInfoAllocation();
        info.alloc = Trans2QueryFSInformationResponse.readInt8(buffer, bufferIndex);
        info.free = Trans2QueryFSInformationResponse.readInt8(buffer, bufferIndex += 8);
        info.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 8);
        info.bytesPerSect = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 4);
        this.info = info;
        return (bufferIndex += 4) - start;
    }

    int readFsFullSizeInformationWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        SmbInfoAllocation info = new SmbInfoAllocation();
        info.alloc = Trans2QueryFSInformationResponse.readInt8(buffer, bufferIndex);
        info.free = Trans2QueryFSInformationResponse.readInt8(buffer, bufferIndex += 8);
        bufferIndex += 8;
        info.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 8);
        info.bytesPerSect = Trans2QueryFSInformationResponse.readInt4(buffer, bufferIndex += 4);
        this.info = info;
        return (bufferIndex += 4) - start;
    }

    public String toString() {
        return new String("Trans2QueryFSInformationResponse[" + super.toString() + "]");
    }

    class SmbInfoAllocation
    implements AllocInfo {
        long alloc;
        long free;
        int sectPerAlloc;
        int bytesPerSect;

        SmbInfoAllocation() {
        }

        public long getCapacity() {
            return this.alloc * (long)this.sectPerAlloc * (long)this.bytesPerSect;
        }

        public long getFree() {
            return this.free * (long)this.sectPerAlloc * (long)this.bytesPerSect;
        }

        public String toString() {
            return new String("SmbInfoAllocation[alloc=" + this.alloc + ",free=" + this.free + ",sectPerAlloc=" + this.sectPerAlloc + ",bytesPerSect=" + this.bytesPerSect + "]");
        }
    }
}

