/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.IOException;

public class Encdec {
    public static int enc_uint16be(short s, byte[] dst, int di) {
        dst[di++] = (byte)(s >> 8 & 0xFF);
        dst[di] = (byte)(s & 0xFF);
        return 2;
    }

    public static int enc_uint32be(int i, byte[] dst, int di) {
        dst[di++] = (byte)(i >> 24 & 0xFF);
        dst[di++] = (byte)(i >> 16 & 0xFF);
        dst[di++] = (byte)(i >> 8 & 0xFF);
        dst[di] = (byte)(i & 0xFF);
        return 4;
    }

    public static int enc_uint16le(short s, byte[] dst, int di) {
        dst[di++] = (byte)(s & 0xFF);
        dst[di] = (byte)(s >> 8 & 0xFF);
        return 2;
    }

    public static int enc_uint32le(int i, byte[] dst, int di) {
        dst[di++] = (byte)(i & 0xFF);
        dst[di++] = (byte)(i >> 8 & 0xFF);
        dst[di++] = (byte)(i >> 16 & 0xFF);
        dst[di] = (byte)(i >> 24 & 0xFF);
        return 4;
    }

    public static short dec_uint16be(byte[] src, int si) {
        return (short)((src[si] & 0xFF) << 8 | src[si + 1] & 0xFF);
    }

    public static int dec_uint32be(byte[] src, int si) {
        return (src[si] & 0xFF) << 24 | (src[si + 1] & 0xFF) << 16 | (src[si + 2] & 0xFF) << 8 | src[si + 3] & 0xFF;
    }

    public static short dec_uint16le(byte[] src, int si) {
        return (short)(src[si] & 0xFF | (src[si + 1] & 0xFF) << 8);
    }

    public static int dec_uint32le(byte[] src, int si) {
        return src[si] & 0xFF | (src[si + 1] & 0xFF) << 8 | (src[si + 2] & 0xFF) << 16 | (src[si + 3] & 0xFF) << 24;
    }

    public static int enc_uint64be(long l, byte[] dst, int di) {
        Encdec.enc_uint32be((int)(l & 0xFFFFFFFFL), dst, di + 4);
        Encdec.enc_uint32be((int)(l >> 32 & 0xFFFFFFFFL), dst, di);
        return 8;
    }

    public static int enc_uint64le(long l, byte[] dst, int di) {
        Encdec.enc_uint32le((int)(l & 0xFFFFFFFFL), dst, di);
        Encdec.enc_uint32le((int)(l >> 32 & 0xFFFFFFFFL), dst, di + 4);
        return 8;
    }

    public static long dec_uint64be(byte[] src, int si) {
        long l = (long)Encdec.dec_uint32be(src, si) & 0xFFFFFFFFL;
        l <<= 32;
        return l |= (long)Encdec.dec_uint32be(src, si + 4) & 0xFFFFFFFFL;
    }

    public static int enc_floatbe(float f, byte[] dst, int di) {
        return Encdec.enc_uint32be(Float.floatToIntBits(f), dst, di);
    }

    public static float dec_floatbe(byte[] src, int si) {
        return Float.intBitsToFloat(Encdec.dec_uint32be(src, si));
    }

    public static int enc_doublebe(double d, byte[] dst, int di) {
        return Encdec.enc_uint64be(Double.doubleToLongBits(d), dst, di);
    }

    public static double dec_doublebe(byte[] src, int si) {
        return Double.longBitsToDouble(Encdec.dec_uint64be(src, si));
    }

    public static int enc_utf8(String str, byte[] dst, int di, int dlim) throws IOException {
        int start = di;
        int strlen = str.length();
        for (int i = 0; di < dlim && i < strlen; ++i) {
            char ch = str.charAt(i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                dst[di++] = (byte)ch;
                continue;
            }
            if (ch > '\u07ff') {
                if (dlim - di < 3) break;
                dst[di++] = (byte)(0xE0 | ch >> 12 & 0xF);
                dst[di++] = (byte)(0x80 | ch >> 6 & 0x3F);
                dst[di++] = (byte)(0x80 | ch >> 0 & 0x3F);
                continue;
            }
            if (dlim - di < 2) break;
            dst[di++] = (byte)(0xC0 | ch >> 6 & 0x1F);
            dst[di++] = (byte)(0x80 | ch >> 0 & 0x3F);
        }
        return di - start;
    }

    public static String dec_utf8(byte[] src, int si, int slim) throws IOException {
        int ch;
        char[] uni = new char[slim - si];
        int ui = 0;
        while (si < slim && (ch = src[si++] & 0xFF) != 0) {
            if (ch < 128) {
                uni[ui] = (char)ch;
            } else if ((ch & 0xE0) == 192) {
                if (slim - si < 2) break;
                uni[ui] = (char)((ch & 0x1F) << 6);
                ch = src[si++] & 0xFF;
                int n = ui;
                uni[n] = (char)(uni[n] | ch & 0x3F);
                if ((ch & 0xC0) != 128 || uni[ui] < '\u0080') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else if ((ch & 0xF0) == 224) {
                if (slim - si < 3) break;
                uni[ui] = (char)((ch & 0xF) << 12);
                if (((ch = src[si++] & 0xFF) & 0xC0) != 128) {
                    throw new IOException("Invalid UTF-8 sequence");
                }
                int n = ui;
                uni[n] = (char)(uni[n] | (ch & 0x3F) << 6);
                ch = src[si++] & 0xFF;
                int n2 = ui;
                uni[n2] = (char)(uni[n2] | ch & 0x3F);
                if ((ch & 0xC0) != 128 || uni[ui] < '\u0800') {
                    throw new IOException("Invalid UTF-8 sequence");
                }
            } else {
                throw new IOException("Unsupported UTF-8 sequence");
            }
            ++ui;
        }
        return new String(uni, 0, ui);
    }
}

