/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Collection;
import org.apache.commons.httpclient.AutoCloseInputStream;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.ResponseConsumedWatcher;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.WireLogInputStream;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieVersionSupport;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpMethodBase
implements HttpMethod {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$HttpMethodBase == null ? (class$org$apache$commons$httpclient$HttpMethodBase = HttpMethodBase.class$("org.apache.commons.httpclient.HttpMethodBase")) : class$org$apache$commons$httpclient$HttpMethodBase);
    private HeaderGroup requestHeaders = new HeaderGroup();
    protected StatusLine statusLine = null;
    private HeaderGroup responseHeaders = new HeaderGroup();
    private HeaderGroup responseTrailerHeaders = new HeaderGroup();
    private String path = null;
    private String queryString = null;
    private InputStream responseStream = null;
    private HttpConnection responseConnection = null;
    private byte[] responseBody = null;
    private boolean followRedirects = false;
    private boolean doAuthentication = true;
    private HttpMethodParams params = new HttpMethodParams();
    private AuthState hostAuthState = new AuthState();
    private AuthState proxyAuthState = new AuthState();
    private boolean used = false;
    private int recoverableExceptionCount = 0;
    private HttpHost httphost = null;
    private MethodRetryHandler methodRetryHandler;
    private boolean connectionCloseForced = false;
    protected HttpVersion effectiveVersion = null;
    private volatile boolean aborted = false;
    private boolean requestSent = false;
    private CookieSpec cookiespec = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpMethodBase;

    public HttpMethodBase() {
    }

    public HttpMethodBase(String uri) throws IllegalArgumentException, IllegalStateException {
        try {
            if (uri == null || uri.equals("")) {
                uri = "/";
            }
            String charset = this.getParams().getUriCharset();
            this.setURI(new URI(uri, true, charset));
        }
        catch (URIException e) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid uri '").append(uri).append("': ").append(e.getMessage()).toString());
        }
    }

    public abstract String getName();

    public URI getURI() throws URIException {
        StringBuffer buffer = new StringBuffer();
        if (this.httphost != null) {
            buffer.append(this.httphost.getProtocol().getScheme());
            buffer.append("://");
            buffer.append(this.httphost.getHostName());
            int port = this.httphost.getPort();
            if (port != -1 && port != this.httphost.getProtocol().getDefaultPort()) {
                buffer.append(":");
                buffer.append(port);
            }
        }
        buffer.append(this.path);
        if (this.queryString != null) {
            buffer.append('?');
            buffer.append(this.queryString);
        }
        String charset = this.getParams().getUriCharset();
        return new URI(buffer.toString(), true, charset);
    }

    public void setURI(URI uri) throws URIException {
        if (uri.isAbsoluteURI()) {
            this.httphost = new HttpHost(uri);
        }
        this.setPath(uri.getPath() == null ? "/" : uri.getEscapedPath());
        this.setQueryString(uri.getEscapedQuery());
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public boolean getDoAuthentication() {
        return this.doAuthentication;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addRequestHeader(Header header) {
        LOG.trace("HttpMethodBase.addRequestHeader(Header)");
        if (header == null) {
            LOG.debug("null header value ignored");
        } else {
            this.getRequestHeaderGroup().addHeader(header);
        }
    }

    public void addResponseFooter(Header footer) {
        this.getResponseTrailerHeaderGroup().addHeader(footer);
    }

    public String getPath() {
        return this.path == null || this.path.equals("") ? "/" : this.path;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        Header header = new Header(headerName, headerValue);
        this.setRequestHeader(header);
    }

    public void setRequestHeader(Header header) {
        Header[] headers = this.getRequestHeaderGroup().getHeaders(header.getName());
        for (int i = 0; i < headers.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headers[i]);
        }
        this.getRequestHeaderGroup().addHeader(header);
    }

    public Header getRequestHeader(String headerName) {
        if (headerName == null) {
            return null;
        }
        return this.getRequestHeaderGroup().getCondensedHeader(headerName);
    }

    public Header[] getRequestHeaders() {
        return this.getRequestHeaderGroup().getAllHeaders();
    }

    public Header[] getRequestHeaders(String headerName) {
        return this.getRequestHeaderGroup().getHeaders(headerName);
    }

    protected HeaderGroup getRequestHeaderGroup() {
        return this.requestHeaders;
    }

    protected HeaderGroup getResponseTrailerHeaderGroup() {
        return this.responseTrailerHeaders;
    }

    protected HeaderGroup getResponseHeaderGroup() {
        return this.responseHeaders;
    }

    public Header[] getResponseHeaders(String headerName) {
        return this.getResponseHeaderGroup().getHeaders(headerName);
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Header[] getResponseHeaders() {
        return this.getResponseHeaderGroup().getAllHeaders();
    }

    public Header getResponseHeader(String headerName) {
        if (headerName == null) {
            return null;
        }
        return this.getResponseHeaderGroup().getCondensedHeader(headerName);
    }

    public long getResponseContentLength() {
        Header[] headers = this.getResponseHeaderGroup().getHeaders("Content-Length");
        if (headers.length == 0) {
            return -1L;
        }
        if (headers.length > 1) {
            LOG.warn("Multiple content-length headers detected");
        }
        for (int i = headers.length - 1; i >= 0; --i) {
            Header header = headers[i];
            try {
                return Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn(new StringBuffer().append("Invalid content-length value: ").append(e.getMessage()).toString());
                continue;
            }
        }
        return -1L;
    }

    public byte[] getResponseBody() throws IOException {
        InputStream instream;
        if (this.responseBody == null && (instream = this.getResponseBodyAsStream()) != null) {
            int len;
            long contentLength = this.getResponseContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IOException(new StringBuffer().append("Content too large to be buffered: ").append(contentLength).append(" bytes").toString());
            }
            int limit = this.getParams().getIntParameter("http.method.response.buffer.warnlimit", 0x100000);
            if (contentLength == -1L || contentLength > (long)limit) {
                LOG.warn("Going to buffer response body of large or unknown size. Using getResponseBodyAsStream instead is recommended.");
            }
            LOG.debug("Buffering response body");
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 4096);
            byte[] buffer = new byte[4096];
            while ((len = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, len);
            }
            outstream.close();
            this.setResponseStream(null);
            this.responseBody = outstream.toByteArray();
        }
        return this.responseBody;
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        if (this.responseStream != null) {
            return this.responseStream;
        }
        if (this.responseBody != null) {
            ByteArrayInputStream byteResponseStream = new ByteArrayInputStream(this.responseBody);
            LOG.debug("re-creating response stream from byte array");
            return byteResponseStream;
        }
        return null;
    }

    protected void setResponseStream(InputStream responseStream) {
        this.responseStream = responseStream;
    }

    public String getStatusText() {
        return this.statusLine.getReasonPhrase();
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.addRequestHeader(new Header(headerName, headerValue));
    }

    protected boolean isConnectionCloseForced() {
        return this.connectionCloseForced;
    }

    protected void setConnectionCloseForced(boolean b) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(new StringBuffer().append("Force-close connection: ").append(b).toString());
        }
        this.connectionCloseForced = b;
    }

    protected boolean shouldCloseConnection(HttpConnection conn) {
        if (this.isConnectionCloseForced()) {
            LOG.debug("Should force-close connection.");
            return true;
        }
        Header connectionHeader = null;
        if (!conn.isTransparent()) {
            connectionHeader = this.responseHeaders.getFirstHeader("proxy-connection");
        }
        if (connectionHeader == null) {
            connectionHeader = this.responseHeaders.getFirstHeader("connection");
        }
        if (connectionHeader == null) {
            connectionHeader = this.requestHeaders.getFirstHeader("connection");
        }
        if (connectionHeader != null) {
            if (connectionHeader.getValue().equalsIgnoreCase("close")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(new StringBuffer().append("Should close connection in response to directive: ").append(connectionHeader.getValue()).toString());
                }
                return true;
            }
            if (connectionHeader.getValue().equalsIgnoreCase("keep-alive")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(new StringBuffer().append("Should NOT close connection in response to directive: ").append(connectionHeader.getValue()).toString());
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(new StringBuffer().append("Unknown directive: ").append(connectionHeader.toExternalForm()).toString());
            }
        }
        LOG.debug("Resorting to protocol version default close connection policy");
        if (this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(new StringBuffer().append("Should NOT close connection, using ").append(this.effectiveVersion.toString()).toString());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(new StringBuffer().append("Should close connection, using ").append(this.effectiveVersion.toString()).toString());
        }
        return this.effectiveVersion.lessEquals(HttpVersion.HTTP_1_0);
    }

    private void checkExecuteConditions(HttpState state, HttpConnection conn) throws HttpException {
        if (state == null) {
            throw new IllegalArgumentException("HttpState parameter may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HttpConnection parameter may not be null");
        }
        if (this.aborted) {
            throw new IllegalStateException("Method has been aborted");
        }
        if (!this.validate()) {
            throw new ProtocolException("HttpMethodBase object not valid");
        }
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        LOG.trace("enter HttpMethodBase.execute(HttpState, HttpConnection)");
        this.responseConnection = conn;
        this.checkExecuteConditions(state, conn);
        this.statusLine = null;
        this.connectionCloseForced = false;
        conn.setLastResponseInputStream(null);
        if (this.effectiveVersion == null) {
            this.effectiveVersion = this.params.getVersion();
        }
        this.writeRequest(state, conn);
        this.requestSent = true;
        this.readResponse(state, conn);
        this.used = true;
        return this.statusLine.getStatusCode();
    }

    public void abort() {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        HttpConnection conn = this.responseConnection;
        if (conn != null) {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection() {
        try {
            if (this.responseStream != null) {
                try {
                    this.responseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.ensureConnectionRelease();
        }
    }

    public void removeRequestHeader(String headerName) {
        Header[] headers = this.getRequestHeaderGroup().getHeaders(headerName);
        for (int i = 0; i < headers.length; ++i) {
            this.getRequestHeaderGroup().removeHeader(headers[i]);
        }
    }

    public void removeRequestHeader(Header header) {
        if (header == null) {
            return;
        }
        this.getRequestHeaderGroup().removeHeader(header);
    }

    public boolean validate() {
        return true;
    }

    private CookieSpec getCookieSpec(HttpState state) {
        if (this.cookiespec == null) {
            int i = state.getCookiePolicy();
            this.cookiespec = i == -1 ? CookiePolicy.getCookieSpec(this.params.getCookiePolicy()) : CookiePolicy.getSpecByPolicy(i);
            this.cookiespec.setValidDateFormats((Collection)this.params.getParameter("http.dateparser.patterns"));
        }
        return this.cookiespec;
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        Cookie[] cookies;
        LOG.trace("enter HttpMethodBase.addCookieRequestHeader(HttpState, HttpConnection)");
        Header[] cookieheaders = this.getRequestHeaderGroup().getHeaders("Cookie");
        for (int i = 0; i < cookieheaders.length; ++i) {
            Header cookieheader = cookieheaders[i];
            if (!cookieheader.isAutogenerated()) continue;
            this.getRequestHeaderGroup().removeHeader(cookieheader);
        }
        CookieSpec matcher = this.getCookieSpec(state);
        String host = this.params.getVirtualHost();
        if (host == null) {
            host = conn.getHost();
        }
        if ((cookies = matcher.match(host, conn.getPort(), this.getPath(), conn.isSecure(), state.getCookies())) != null && cookies.length > 0) {
            if (this.getParams().isParameterTrue("http.protocol.single-cookie-header")) {
                String s = matcher.formatCookies(cookies);
                this.getRequestHeaderGroup().addHeader(new Header("Cookie", s, true));
            } else {
                for (int i = 0; i < cookies.length; ++i) {
                    String s = matcher.formatCookie(cookies[i]);
                    this.getRequestHeaderGroup().addHeader(new Header("Cookie", s, true));
                }
            }
            if (matcher instanceof CookieVersionSupport) {
                CookieVersionSupport versupport = (CookieVersionSupport)((Object)matcher);
                int ver = versupport.getVersion();
                boolean needVersionHeader = false;
                for (int i = 0; i < cookies.length; ++i) {
                    if (ver == cookies[i].getVersion()) continue;
                    needVersionHeader = true;
                }
                if (needVersionHeader) {
                    this.getRequestHeaderGroup().addHeader(versupport.getVersionHeader());
                }
            }
        }
    }

    protected void addHostRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addHostRequestHeader(HttpState, HttpConnection)");
        String host = this.params.getVirtualHost();
        if (host != null) {
            LOG.debug(new StringBuffer().append("Using virtual host name: ").append(host).toString());
        } else {
            host = conn.getHost();
        }
        int port = conn.getPort();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Host request header");
        }
        if (conn.getProtocol().getDefaultPort() != port) {
            host = new StringBuffer().append(host).append(":").append(port).toString();
        }
        this.setRequestHeader("Host", host);
    }

    protected void addProxyConnectionHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addProxyConnectionHeader(HttpState, HttpConnection)");
        if (!conn.isTransparent() && this.getRequestHeader("Proxy-Connection") == null) {
            this.addRequestHeader("Proxy-Connection", "Keep-Alive");
        }
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addCookieRequestHeader(state, conn);
        this.addProxyConnectionHeader(state, conn);
    }

    protected void addUserAgentRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.addUserAgentRequestHeaders(HttpState, HttpConnection)");
        if (this.getRequestHeader("User-Agent") == null) {
            String agent = (String)this.getParams().getParameter("http.useragent");
            if (agent == null) {
                agent = "Jakarta Commons-HttpClient";
            }
            this.setRequestHeader("User-Agent", agent);
        }
    }

    protected static String generateRequestLine(HttpConnection connection, String name, String requestPath, String query, String version) {
        LOG.trace("enter HttpMethodBase.generateRequestLine(HttpConnection, String, String, String, String)");
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append(" ");
        if (!connection.isTransparent()) {
            Protocol protocol = connection.getProtocol();
            buf.append(protocol.getScheme().toLowerCase());
            buf.append("://");
            buf.append(connection.getHost());
            if (connection.getPort() != -1 && connection.getPort() != protocol.getDefaultPort()) {
                buf.append(":");
                buf.append(connection.getPort());
            }
        }
        if (requestPath == null) {
            buf.append("/");
        } else {
            if (!connection.isTransparent() && !requestPath.startsWith("/")) {
                buf.append("/");
            }
            buf.append(requestPath);
        }
        if (query != null) {
            if (query.indexOf("?") != 0) {
                buf.append("?");
            }
            buf.append(query);
        }
        buf.append(" ");
        buf.append(version);
        buf.append("\r\n");
        return buf.toString();
    }

    protected void processResponseBody(HttpState state, HttpConnection conn) {
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        CookieVersionSupport versupport;
        LOG.trace("enter HttpMethodBase.processResponseHeaders(HttpState, HttpConnection)");
        CookieSpec parser = this.getCookieSpec(state);
        Header[] headers = this.getResponseHeaderGroup().getHeaders("set-cookie");
        this.processCookieHeaders(parser, headers, state, conn);
        if (parser instanceof CookieVersionSupport && (versupport = (CookieVersionSupport)((Object)parser)).getVersion() > 0) {
            headers = this.getResponseHeaderGroup().getHeaders("set-cookie2");
            this.processCookieHeaders(parser, headers, state, conn);
        }
    }

    protected void processCookieHeaders(CookieSpec cookieSpec, Header[] headerArray, HttpState httpState, HttpConnection httpConnection) {
        LOG.trace("enter HttpMethodBase.processCookieHeaders(Header[], HttpState, HttpConnection)");
        String string = this.params.getVirtualHost();
        if (string == null) {
            string = httpConnection.getHost();
        }
        for (int i = 0; i < headerArray.length; ++i) {
            Cookie[] cookieArray;
            block7: {
                Header header = headerArray[i];
                cookieArray = null;
                try {
                    cookieArray = cookieSpec.parse(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), header);
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) break block7;
                    LOG.warn(new StringBuffer().append("Invalid cookie header: \"").append(header.getValue()).append("\". ").append(malformedCookieException.getMessage()).toString());
                }
            }
            if (cookieArray == null) continue;
            for (int j = 0; j < cookieArray.length; ++j) {
                Cookie cookie = cookieArray[j];
                try {
                    cookieSpec.validate(string, httpConnection.getPort(), this.getPath(), httpConnection.isSecure(), cookie);
                    httpState.addCookie(cookie);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(new StringBuffer().append("Cookie accepted: \"").append(cookieSpec.formatCookie(cookie)).append("\"").toString());
                    continue;
                }
                catch (MalformedCookieException malformedCookieException) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn(new StringBuffer().append("Cookie rejected: \"").append(cookieSpec.formatCookie(cookie)).append("\". ").append(malformedCookieException.getMessage()).toString());
                }
            }
        }
    }

    protected void processStatusLine(HttpState state, HttpConnection conn) {
    }

    protected void readResponse(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponse(HttpState, HttpConnection)");
        while (this.statusLine == null) {
            this.readStatusLine(httpState, httpConnection);
            this.processStatusLine(httpState, httpConnection);
            this.readResponseHeaders(httpState, httpConnection);
            this.processResponseHeaders(httpState, httpConnection);
            int n = this.statusLine.getStatusCode();
            if (n < 100 || n >= 200) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info(new StringBuffer().append("Discarding unexpected response: ").append(this.statusLine.toString()).toString());
            }
            this.statusLine = null;
        }
        this.readResponseBody(httpState, httpConnection);
        this.processResponseBody(httpState, httpConnection);
    }

    protected void readResponseBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponseBody(HttpState, HttpConnection)");
        InputStream inputStream = this.readResponseBody(httpConnection);
        if (inputStream == null) {
            this.responseBodyConsumed();
        } else {
            httpConnection.setLastResponseInputStream(inputStream);
            this.setResponseStream(inputStream);
        }
    }

    private InputStream readResponseBody(HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace("enter HttpMethodBase.readResponseBody(HttpConnection)");
        this.responseBody = null;
        InputStream inputStream = httpConnection.getResponseInputStream();
        if (Wire.CONTENT_WIRE.enabled()) {
            inputStream = new WireLogInputStream(inputStream, Wire.CONTENT_WIRE);
        }
        boolean bl = HttpMethodBase.canResponseHaveBody(this.statusLine.getStatusCode());
        InputStream inputStream2 = null;
        Header header = this.responseHeaders.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            HeaderElement[] headerElementArray;
            int n;
            String string = header.getValue();
            if (!"chunked".equalsIgnoreCase(string) && !"identity".equalsIgnoreCase(string) && LOG.isWarnEnabled()) {
                LOG.warn(new StringBuffer().append("Unsupported transfer encoding: ").append(string).toString());
            }
            if ((n = (headerElementArray = header.getElements()).length) > 0 && "chunked".equalsIgnoreCase(headerElementArray[n - 1].getName())) {
                if (httpConnection.isResponseAvailable(httpConnection.getParams().getSoTimeout())) {
                    inputStream2 = new ChunkedInputStream(inputStream, this);
                } else {
                    if (this.getParams().isParameterTrue("http.protocol.strict-transfer-encoding")) {
                        throw new ProtocolException("Chunk-encoded body declared but not sent");
                    }
                    LOG.warn("Chunk-encoded body missing");
                }
            } else {
                LOG.info("Response content is not chunk-encoded");
                this.setConnectionCloseForced(true);
                inputStream2 = inputStream;
            }
        } else {
            long l = this.getResponseContentLength();
            if (l == -1L) {
                if (bl && this.effectiveVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                    Header header2 = this.responseHeaders.getFirstHeader("Connection");
                    String string = null;
                    if (header2 != null) {
                        string = header2.getValue();
                    }
                    if (!"close".equalsIgnoreCase(string)) {
                        LOG.info("Response content length is not known");
                        this.setConnectionCloseForced(true);
                    }
                }
                inputStream2 = inputStream;
            } else {
                inputStream2 = new ContentLengthInputStream(inputStream, l);
            }
        }
        if (!bl) {
            inputStream2 = null;
        }
        if (inputStream2 != null) {
            inputStream2 = new AutoCloseInputStream(inputStream2, new ResponseConsumedWatcher(){

                public void responseConsumed() {
                    HttpMethodBase.this.responseBodyConsumed();
                }
            });
        }
        return inputStream2;
    }

    protected void readResponseHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.readResponseHeaders(HttpState,HttpConnection)");
        this.getResponseHeaderGroup().clear();
        Header[] headerArray = HttpParser.parseHeaders(httpConnection.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headerArray);
    }

    protected void readStatusLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        String string;
        LOG.trace("enter HttpMethodBase.readStatusLine(HttpState, HttpConnection)");
        int n = this.getParams().getIntParameter("http.protocol.status-line-garbage-limit", Integer.MAX_VALUE);
        int n2 = 0;
        while (true) {
            if ((string = httpConnection.readLine(this.getParams().getHttpElementCharset())) == null && n2 == 0) {
                throw new NoHttpResponseException(new StringBuffer().append("The server ").append(httpConnection.getHost()).append(" failed to respond").toString());
            }
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.input(new StringBuffer().append(string).append("\r\n").toString());
            }
            if (string != null && StatusLine.startsWithHTTP(string)) break;
            if (string == null || n2 >= n) {
                throw new ProtocolException(new StringBuffer().append("The server ").append(httpConnection.getHost()).append(" failed to respond with a valid HTTP response").toString());
            }
            ++n2;
        }
        this.statusLine = new StatusLine(string);
        String string2 = this.statusLine.getHttpVersion();
        if (this.getParams().isParameterFalse("http.protocol.unambiguous-statusline") && string2.equals("HTTP")) {
            this.getParams().setVersion(HttpVersion.HTTP_1_0);
            if (LOG.isWarnEnabled()) {
                LOG.warn(new StringBuffer().append("Ambiguous status line (HTTP protocol version missing):").append(this.statusLine.toString()).toString());
            }
        } else {
            this.effectiveVersion = HttpVersion.parse(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequest(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequest(HttpState, HttpConnection)");
        this.writeRequestLine(httpState, httpConnection);
        this.writeRequestHeaders(httpState, httpConnection);
        httpConnection.writeLine();
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output("\r\n");
        }
        HttpVersion httpVersion = this.getParams().getVersion();
        Header header = this.getRequestHeader("Expect");
        String string = null;
        if (header != null) {
            string = header.getValue();
        }
        if (string != null && string.compareToIgnoreCase("100-continue") == 0) {
            if (httpVersion.greaterEquals(HttpVersion.HTTP_1_1)) {
                httpConnection.flushRequestOutputStream();
                int n = httpConnection.getParams().getSoTimeout();
                try {
                    httpConnection.setSocketTimeout(3000);
                    this.readStatusLine(httpState, httpConnection);
                    this.processStatusLine(httpState, httpConnection);
                    this.readResponseHeaders(httpState, httpConnection);
                    this.processResponseHeaders(httpState, httpConnection);
                    if (this.statusLine.getStatusCode() == 100) {
                        this.statusLine = null;
                        LOG.debug("OK to continue received");
                    }
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (!ExceptionUtil.isSocketTimeoutException(interruptedIOException)) {
                        throw interruptedIOException;
                    }
                    this.removeRequestHeader("Expect");
                    LOG.info("100 (continue) read timeout. Resume sending the request");
                }
                finally {
                    httpConnection.setSocketTimeout(n);
                }
            } else {
                this.removeRequestHeader("Expect");
                LOG.info("'Expect: 100-continue' handshake is only supported by HTTP/1.1 or higher");
            }
        }
        this.writeRequestBody(httpState, httpConnection);
        httpConnection.flushRequestOutputStream();
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        return true;
    }

    protected void writeRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequestHeaders(HttpState,HttpConnection)");
        this.addRequestHeaders(httpState, httpConnection);
        String string = this.getParams().getHttpElementCharset();
        Header[] headerArray = this.getRequestHeaders();
        for (int i = 0; i < headerArray.length; ++i) {
            String string2 = headerArray[i].toExternalForm();
            if (Wire.HEADER_WIRE.enabled()) {
                Wire.HEADER_WIRE.output(string2);
            }
            httpConnection.print(string2, string);
        }
    }

    protected void writeRequestLine(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace("enter HttpMethodBase.writeRequestLine(HttpState, HttpConnection)");
        String string = this.getRequestLine(httpConnection);
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(string);
        }
        httpConnection.print(string, this.getParams().getHttpElementCharset());
    }

    private String getRequestLine(HttpConnection conn) {
        return HttpMethodBase.generateRequestLine(conn, this.getName(), this.getPath(), this.getQueryString(), this.effectiveVersion.toString());
    }

    public HttpMethodParams getParams() {
        return this.params;
    }

    public HttpVersion getEffectiveVersion() {
        return this.effectiveVersion;
    }

    private static boolean canResponseHaveBody(int n) {
        LOG.trace("enter HttpMethodBase.canResponseHaveBody(int)");
        boolean bl = true;
        if (n >= 100 && n <= 199 || n == 204 || n == 304) {
            bl = false;
        }
        return bl;
    }

    protected String getContentCharSet(Header header) {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        LOG.trace("enter getContentCharSet( Header contentheader )");
        String string = null;
        if (header != null && (headerElementArray = header.getElements()).length == 1 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        if (string == null) {
            string = this.getParams().getContentCharset();
            if (LOG.isDebugEnabled()) {
                LOG.debug(new StringBuffer().append("Default charset used: ").append(string).toString());
            }
        }
        return string;
    }

    public String getRequestCharSet() {
        return this.getContentCharSet(this.getRequestHeader("Content-Type"));
    }

    protected void responseBodyConsumed() {
        this.responseStream = null;
        if (this.responseConnection != null) {
            this.responseConnection.setLastResponseInputStream(null);
            if (this.shouldCloseConnection(this.responseConnection)) {
                this.responseConnection.close();
            } else {
                try {
                    if (this.responseConnection.isResponseAvailable()) {
                        boolean bl = this.getParams().isParameterTrue("http.protocol.warn-extra-input");
                        if (bl) {
                            LOG.warn("Extra response data detected - closing connection");
                        }
                        this.responseConnection.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.warn(iOException.getMessage());
                    this.responseConnection.close();
                }
            }
        }
        this.connectionCloseForced = false;
        this.ensureConnectionRelease();
    }

    private void ensureConnectionRelease() {
        if (this.responseConnection != null) {
            this.responseConnection.releaseConnection();
            this.responseConnection = null;
        }
    }

    public MethodRetryHandler getMethodRetryHandler() {
        return this.methodRetryHandler;
    }

    void fakeResponse(StatusLine statusline, HeaderGroup responseheaders, InputStream responseStream) {
        this.used = true;
        this.statusLine = statusline;
        this.responseHeaders = responseheaders;
        this.responseBody = null;
        this.responseStream = responseStream;
    }

    public AuthState getHostAuthState() {
        return this.hostAuthState;
    }

    public AuthState getProxyAuthState() {
        return this.proxyAuthState;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isRequestSent() {
        return this.requestSent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

