/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLM;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$auth$NTLMScheme == null ? (class$org$apache$commons$httpclient$auth$NTLMScheme = NTLMScheme.class$("org.apache.commons.httpclient.auth.NTLMScheme")) : class$org$apache$commons$httpclient$auth$NTLMScheme);
    private String ntlmchallenge = null;
    private int state = 0;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$NTLMScheme;

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme(challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException(new StringBuffer().append("Invalid NTLM challenge: ").append(challenge).toString());
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.ntlmchallenge = s.trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        LOG.trace("enter NTLMScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException(new StringBuffer().append("Credentials cannot be used for NTLM authentication: ").append(credentials.getClass().getName()).toString());
        }
        NTLM ntlm = new NTLM();
        ntlm.setCredentialCharset(method.getParams().getCredentialCharset());
        String response = null;
        if (this.state == 1 || this.state == Integer.MAX_VALUE) {
            response = ntlm.getType1Message(ntcredentials.getHost(), ntcredentials.getDomain());
            this.state = 2;
        } else {
            response = ntlm.getType3Message(ntcredentials.getUserName(), ntcredentials.getPassword(), ntcredentials.getHost(), ntcredentials.getDomain(), ntlm.parseType2Message(this.ntlmchallenge));
            this.state = 4;
        }
        return new StringBuffer().append("NTLM ").append(response).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

