/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.httpclient.cookie.RFC2965Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookiePolicy {
    private static Map SPECS = Collections.synchronizedMap(new HashMap());
    private static int defaultPolicy;
    protected static final Log LOG;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$RFC2109Spec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$RFC2965Spec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookieSpecBase;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec;
    static /* synthetic */ Class class$org$apache$commons$httpclient$cookie$CookiePolicy;

    public static void registerCookieSpec(String id, Class clazz) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cookie spec class may not be null");
        }
        SPECS.put(id.toLowerCase(), clazz);
    }

    public static CookieSpec getCookieSpec(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class clazz = (Class)SPECS.get(id.toLowerCase());
        if (clazz != null) {
            try {
                return (CookieSpec)clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error(new StringBuffer().append("Error initializing cookie spec: ").append(id).toString(), e);
                throw new IllegalStateException(new StringBuffer().append(id).append(" cookie spec implemented by ").append(clazz.getName()).append(" could not be initialized").toString());
            }
        }
        throw new IllegalStateException(new StringBuffer().append("Unsupported cookie spec ").append(id).toString());
    }

    public static CookieSpec getSpecByPolicy(int policy) {
        switch (policy) {
            case 0: {
                return new CookieSpecBase();
            }
            case 1: {
                return new NetscapeDraftSpec();
            }
            case 2: {
                return new RFC2109Spec();
            }
            case 3: {
                return new RFC2965Spec();
            }
        }
        return CookiePolicy.getDefaultSpec();
    }

    public static CookieSpec getDefaultSpec() {
        try {
            return CookiePolicy.getCookieSpec("default");
        }
        catch (IllegalStateException e) {
            LOG.warn("Default cookie policy is not registered");
            return new RFC2109Spec();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CookiePolicy.registerCookieSpec("default", class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec("rfc2109", class$org$apache$commons$httpclient$cookie$RFC2109Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2109Spec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.RFC2109Spec")) : class$org$apache$commons$httpclient$cookie$RFC2109Spec);
        CookiePolicy.registerCookieSpec("rfc2965", class$org$apache$commons$httpclient$cookie$RFC2965Spec == null ? (class$org$apache$commons$httpclient$cookie$RFC2965Spec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.RFC2965Spec")) : class$org$apache$commons$httpclient$cookie$RFC2965Spec);
        CookiePolicy.registerCookieSpec("compatibility", class$org$apache$commons$httpclient$cookie$CookieSpecBase == null ? (class$org$apache$commons$httpclient$cookie$CookieSpecBase = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookieSpecBase")) : class$org$apache$commons$httpclient$cookie$CookieSpecBase);
        CookiePolicy.registerCookieSpec("netscape", class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec == null ? (class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.NetscapeDraftSpec")) : class$org$apache$commons$httpclient$cookie$NetscapeDraftSpec);
        CookiePolicy.registerCookieSpec("ignoreCookies", class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec == null ? (class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec = CookiePolicy.class$("org.apache.commons.httpclient.cookie.IgnoreCookiesSpec")) : class$org$apache$commons$httpclient$cookie$IgnoreCookiesSpec);
        defaultPolicy = 2;
        LOG = LogFactory.getLog(class$org$apache$commons$httpclient$cookie$CookiePolicy == null ? (class$org$apache$commons$httpclient$cookie$CookiePolicy = CookiePolicy.class$("org.apache.commons.httpclient.cookie.CookiePolicy")) : class$org$apache$commons$httpclient$cookie$CookiePolicy);
    }
}

