/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpMethodParams
extends DefaultHttpParams {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$params$HttpMethodParams == null ? (class$org$apache$commons$httpclient$params$HttpMethodParams = HttpMethodParams.class$("org.apache.commons.httpclient.params.HttpMethodParams")) : class$org$apache$commons$httpclient$params$HttpMethodParams);
    private static final String[] PROTOCOL_STRICTNESS_PARAMETERS = new String[]{"http.protocol.unambiguous-statusline", "http.protocol.single-cookie-header", "http.protocol.strict-transfer-encoding", "http.protocol.reject-head-body", "http.protocol.warn-extra-input"};
    static /* synthetic */ Class class$org$apache$commons$httpclient$params$HttpMethodParams;

    public HttpMethodParams() {
        super(HttpMethodParams.getDefaultParams());
    }

    public HttpMethodParams(HttpParams defaults) {
        super(defaults);
    }

    public String getHttpElementCharset() {
        String charset = (String)this.getParameter("http.protocol.element-charset");
        if (charset == null) {
            LOG.warn("HTTP element charset not configured, using US-ASCII");
            charset = "US-ASCII";
        }
        return charset;
    }

    public void setHttpElementCharset(String charset) {
        this.setParameter("http.protocol.element-charset", charset);
    }

    public String getContentCharset() {
        String charset = (String)this.getParameter("http.protocol.content-charset");
        if (charset == null) {
            LOG.warn("Default content charset not configured, using ISO-8859-1");
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public String getUriCharset() {
        String charset = (String)this.getParameter("http.protocol.uri-charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        return charset;
    }

    public void setContentCharset(String charset) {
        this.setParameter("http.protocol.content-charset", charset);
    }

    public String getCredentialCharset() {
        String charset = (String)this.getParameter("http.protocol.credential-charset");
        if (charset == null) {
            LOG.debug("Credential charset not configured, using HTTP element charset");
            charset = this.getHttpElementCharset();
        }
        return charset;
    }

    public HttpVersion getVersion() {
        Object param = this.getParameter("http.protocol.version");
        if (param == null) {
            return HttpVersion.HTTP_1_1;
        }
        return (HttpVersion)param;
    }

    public void setVersion(HttpVersion version) {
        this.setParameter("http.protocol.version", version);
    }

    public String getCookiePolicy() {
        Object param = this.getParameter("http.protocol.cookie-policy");
        if (param == null) {
            return "default";
        }
        return (String)param;
    }

    public void setCookiePolicy(String policy) {
        this.setParameter("http.protocol.cookie-policy", policy);
    }

    public String getVirtualHost() {
        return (String)this.getParameter("http.virtual-host");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

