/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncodingUtil {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$util$EncodingUtil == null ? (class$org$apache$commons$httpclient$util$EncodingUtil = EncodingUtil.class$("org.apache.commons.httpclient.util.EncodingUtil")) : class$org$apache$commons$httpclient$util$EncodingUtil);
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$EncodingUtil;

    public static String getString(byte[] data, int offset, int length, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(new StringBuffer().append("Unsupported encoding: ").append(charset).append(". System encoding used").toString());
            }
            return new String(data, offset, length);
        }
    }

    public static String getString(byte[] data, String charset) {
        return EncodingUtil.getString(data, 0, data.length, charset);
    }

    public static byte[] getBytes(String data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(new StringBuffer().append("Unsupported encoding: ").append(charset).append(". System encoding used.").toString());
            }
            return data.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data, offset, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data) {
        return EncodingUtil.getAsciiString(data, 0, data.length);
    }

    private EncodingUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

