/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.SocketInputStream;
import org.apache.commons.net.io.SocketOutputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;

public class FTPClient
extends FTP
implements Configurable {
    private int __dataConnectionMode;
    private int __dataTimeout;
    private int __passivePort;
    private String __passiveHost;
    private int __fileType;
    private int __fileFormat;
    private int __fileStructure;
    private int __fileTransferMode;
    private boolean __remoteVerificationEnabled;
    private long __restartOffset;
    private FTPFileEntryParserFactory __parserFactory;
    private int __bufferSize;
    private boolean __listHiddenFiles;
    private String __systemName;
    private FTPFileEntryParser __entryParser;
    private FTPClientConfig __configuration;
    private static String __parms = "\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}";
    private static Pattern __parms_pat = Pattern.compile(__parms);

    public FTPClient() {
        this.__initDefaults();
        this.__dataTimeout = -1;
        this.__remoteVerificationEnabled = true;
        this.__parserFactory = new DefaultFTPFileEntryParserFactory();
        this.__configuration = null;
        this.__listHiddenFiles = false;
    }

    private void __initDefaults() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
        this.__fileType = 0;
        this.__fileStructure = 7;
        this.__fileFormat = 4;
        this.__fileTransferMode = 10;
        this.__restartOffset = 0L;
        this.__systemName = null;
        this.__entryParser = null;
        this.__bufferSize = 1024;
    }

    private void __parsePassiveModeReply(String reply) throws MalformedServerReplyException {
        Matcher m = __parms_pat.matcher(reply);
        if (!m.find()) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + reply);
        }
        reply = m.group();
        String[] parts = m.group().split(",");
        this.__passiveHost = parts[0] + '.' + parts[1] + '.' + parts[2] + '.' + parts[3];
        try {
            int oct1 = Integer.parseInt(parts[4]);
            int oct2 = Integer.parseInt(parts[5]);
            this.__passivePort = oct1 << 8 | oct2;
        }
        catch (NumberFormatException e) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + reply);
        }
    }

    private OutputStream __storeFileStream(int command, String remote) throws IOException {
        Socket socket = this._openDataConnection_(command, remote);
        if (socket == null) {
            return null;
        }
        OutputStream output = socket.getOutputStream();
        if (this.__fileType == 0) {
            output = new BufferedOutputStream(output, this.getBufferSize());
            output = new ToNetASCIIOutputStream(output);
        }
        return new SocketOutputStream(socket, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket _openDataConnection_(int command, String arg) throws IOException {
        Socket socket;
        if (this.__dataConnectionMode != 0 && this.__dataConnectionMode != 2) {
            return null;
        }
        if (this.__dataConnectionMode == 0) {
            ServerSocket server = this._serverSocketFactory_.createServerSocket(0, 1, this.getLocalAddress());
            if (!FTPReply.isPositiveCompletion(this.port(this.getLocalAddress(), server.getLocalPort()))) {
                server.close();
                return null;
            }
            if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                server.close();
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(command, arg))) {
                server.close();
                return null;
            }
            if (this.__dataTimeout >= 0) {
                server.setSoTimeout(this.__dataTimeout);
            }
            try {
                socket = server.accept();
            }
            finally {
                server.close();
            }
        } else {
            if (this.pasv() != 227) {
                return null;
            }
            this.__parsePassiveModeReply((String)this._replyLines.get(this._replyLines.size() - 1));
            socket = this._socketFactory_.createSocket(this.__passiveHost, this.__passivePort);
            if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                socket.close();
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(command, arg))) {
                socket.close();
                return null;
            }
        }
        if (this.__remoteVerificationEnabled && !this.verifyRemote(socket)) {
            InetAddress host1 = socket.getInetAddress();
            InetAddress host2 = this.getRemoteAddress();
            socket.close();
            throw new IOException("Host attempting data connection " + host1.getHostAddress() + " is not same as server " + host2.getHostAddress());
        }
        if (this.__dataTimeout >= 0) {
            socket.setSoTimeout(this.__dataTimeout);
        }
        return socket;
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this.__initDefaults();
    }

    public void disconnect() throws IOException {
        super.disconnect();
        this.__initDefaults();
    }

    public boolean login(String username, String password) throws IOException {
        this.user(username);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.pass(password));
    }

    public boolean logout() throws IOException {
        return FTPReply.isPositiveCompletion(this.quit());
    }

    public boolean changeWorkingDirectory(String pathname) throws IOException {
        return FTPReply.isPositiveCompletion(this.cwd(pathname));
    }

    public void enterLocalActiveMode() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public void enterLocalPassiveMode() {
        this.__dataConnectionMode = 2;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public boolean setFileType(int fileType) throws IOException {
        if (FTPReply.isPositiveCompletion(this.type(fileType))) {
            this.__fileType = fileType;
            this.__fileFormat = 4;
            return true;
        }
        return false;
    }

    public boolean completePendingCommand() throws IOException {
        return FTPReply.isPositiveCompletion(this.getReply());
    }

    public InputStream retrieveFileStream(String remote) throws IOException {
        Socket socket = this._openDataConnection_(13, remote);
        if (socket == null) {
            return null;
        }
        InputStream input = socket.getInputStream();
        if (this.__fileType == 0) {
            input = new BufferedInputStream(input, this.getBufferSize());
            input = new FromNetASCIIInputStream(input);
        }
        return new SocketInputStream(socket, input);
    }

    public OutputStream storeFileStream(String remote) throws IOException {
        return this.__storeFileStream(14, remote);
    }

    public OutputStream appendFileStream(String remote) throws IOException {
        return this.__storeFileStream(16, remote);
    }

    private boolean restart(long offset) throws IOException {
        this.__restartOffset = 0L;
        return FTPReply.isPositiveIntermediate(this.rest(Long.toString(offset)));
    }

    public void setRestartOffset(long offset) {
        if (offset >= 0L) {
            this.__restartOffset = offset;
        }
    }

    public boolean rename(String from, String to) throws IOException {
        if (!FTPReply.isPositiveIntermediate(this.rnfr(from))) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.rnto(to));
    }

    public boolean deleteFile(String pathname) throws IOException {
        return FTPReply.isPositiveCompletion(this.dele(pathname));
    }

    public boolean removeDirectory(String pathname) throws IOException {
        return FTPReply.isPositiveCompletion(this.rmd(pathname));
    }

    public boolean makeDirectory(String pathname) throws IOException {
        return FTPReply.isPositiveCompletion(this.mkd(pathname));
    }

    public boolean sendSiteCommand(String arguments) throws IOException {
        return FTPReply.isPositiveCompletion(this.site(arguments));
    }

    public String getSystemName() throws IOException {
        if (this.__systemName == null && FTPReply.isPositiveCompletion(this.syst())) {
            this.__systemName = ((String)this._replyLines.get(this._replyLines.size() - 1)).substring(4);
        }
        return this.__systemName;
    }

    public boolean sendNoOp() throws IOException {
        return FTPReply.isPositiveCompletion(this.noop());
    }

    public FTPFile[] listFiles(String pathname) throws IOException {
        String key = null;
        FTPListParseEngine engine = this.initiateListParsing(key, pathname);
        return engine.getFiles();
    }

    public FTPFile[] listFiles() throws IOException {
        return this.listFiles(null);
    }

    public FTPListParseEngine initiateListParsing(String parserKey, String pathname) throws IOException {
        if (this.__entryParser == null) {
            String systemName;
            this.__entryParser = null != parserKey ? this.__parserFactory.createFileEntryParser(parserKey) : (null != this.__configuration ? this.__parserFactory.createFileEntryParser(this.__configuration) : this.__parserFactory.createFileEntryParser((systemName = this.getSystemName()) == null ? "UNIX" : systemName));
        }
        return this.initiateListParsing(this.__entryParser, pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateListParsing(FTPFileEntryParser parser, String pathname) throws IOException {
        FTPListParseEngine engine = new FTPListParseEngine(parser);
        Socket socket = this._openDataConnection_(26, this.getListArguments(pathname));
        if (socket == null) {
            return engine;
        }
        try {
            engine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            socket.close();
        }
        this.completePendingCommand();
        return engine;
    }

    protected String getListArguments(String pathname) {
        if (this.getListHiddenFiles()) {
            StringBuffer sb = new StringBuffer(pathname.length() + 3);
            sb.append("-a ");
            sb.append(pathname);
            return sb.toString();
        }
        return pathname;
    }

    public int getBufferSize() {
        return this.__bufferSize;
    }

    public void configure(FTPClientConfig config) {
        this.__configuration = config;
    }

    public void setListHiddenFiles(boolean listHiddenFiles) {
        this.__listHiddenFiles = listHiddenFiles;
    }

    public boolean getListHiddenFiles() {
        return this.__listHiddenFiles;
    }
}

