/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.util.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Iterable<Map.Entry<String, String>>,
Writable {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private boolean quietmode = true;
    private ArrayList<Object> resources = new ArrayList();
    private Set<String> finalParameters = new HashSet<String>();
    private boolean loadDefaults = true;
    private static final WeakHashMap<Configuration, Object> REGISTRY = new WeakHashMap();
    private static final ArrayList<String> defaultResources = new ArrayList();
    private Properties properties;
    private Properties overlay;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private static Pattern varPat;
    private static int MAX_SUBST;

    public Configuration() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(boolean bl) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        this.loadDefaults = bl;
        if (LOG.isDebugEnabled()) {
            LOG.debug(StringUtils.stringifyException(new IOException("config()")));
        }
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(Configuration configuration) {
        if (this.classLoader == null) {
            this.classLoader = Configuration.class.getClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(StringUtils.stringifyException(new IOException("config(config)")));
        }
        this.resources = (ArrayList)configuration.resources.clone();
        Object object = configuration;
        synchronized (object) {
            if (configuration.properties != null) {
                this.properties = (Properties)configuration.properties.clone();
            }
            if (configuration.overlay != null) {
                this.overlay = (Properties)configuration.overlay.clone();
            }
        }
        this.finalParameters = new HashSet<String>(configuration.finalParameters);
        object = Configuration.class;
        synchronized (Configuration.class) {
            REGISTRY.put(this, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void addDefaultResource(String name) {
        if (!defaultResources.contains(name)) {
            defaultResources.add(name);
            for (Configuration conf : REGISTRY.keySet()) {
                if (!conf.loadDefaults) continue;
                conf.reloadConfiguration();
            }
        }
    }

    public void addResource(String name) {
        this.addResourceObject(name);
    }

    public synchronized void reloadConfiguration() {
        this.properties = null;
        this.finalParameters.clear();
    }

    private synchronized void addResourceObject(Object resource) {
        this.resources.add(resource);
        this.reloadConfiguration();
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String get(String name) {
        return this.substituteVars(this.getProps().getProperty(name));
    }

    public String getRaw(String name) {
        return this.getProps().getProperty(name);
    }

    public void set(String name, String value) {
        this.getOverlay().setProperty(name, value);
        this.getProps().setProperty(name, value);
    }

    private synchronized Properties getOverlay() {
        if (this.overlay == null) {
            this.overlay = new Properties();
        }
        return this.overlay;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getProps().getProperty(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public String[] getStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getStrings(valueString);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        return StringUtils.getStrings(valueString);
    }

    public void setStrings(String name, String ... values) {
        this.set(name, StringUtils.arrayToString(values));
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.classLoader);
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return this.getClassByName(valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    private synchronized Properties getProps() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadResources(this.properties, this.resources, this.quietmode);
            if (this.overlay != null) {
                this.properties.putAll((Map<?, ?>)this.overlay);
            }
        }
        return this.properties;
    }

    public void clear() {
        this.getProps().clear();
        this.getOverlay().clear();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : this.getProps().entrySet()) {
            if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
            result.put((String)item.getKey(), (String)item.getValue());
        }
        return result.entrySet().iterator();
    }

    private void loadResources(Properties properties, ArrayList resources, boolean quiet) {
        if (this.loadDefaults) {
            for (String resource : defaultResources) {
                this.loadResource(properties, resource, quiet);
            }
            if (this.getResource("hadoop-site.xml") != null) {
                this.loadResource(properties, "hadoop-site.xml", quiet);
            }
        }
        for (String resource : resources) {
            this.loadResource(properties, resource, quiet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(Properties properties, Object name, boolean quiet) {
        try {
            URL url;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setNamespaceAware(true);
            try {
                docBuilderFactory.setXIncludeAware(true);
            }
            catch (UnsupportedOperationException e) {
                LOG.error("Failed to set setXIncludeAware(true) for parser " + docBuilderFactory + ":" + e, e);
            }
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = null;
            Element root = null;
            if (name instanceof URL) {
                url = (URL)name;
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof String) {
                url = this.getResource((String)name);
                if (url != null) {
                    if (!quiet) {
                        LOG.info("parsing " + url);
                    }
                    doc = builder.parse(url.toString());
                }
            } else if (name instanceof Path) {
                File file = new File(((Path)name).toUri().getPath()).getAbsoluteFile();
                if (file.exists()) {
                    if (!quiet) {
                        LOG.info("parsing " + file);
                    }
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    try {
                        doc = builder.parse(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            } else if (name instanceof InputStream) {
                try {
                    doc = builder.parse((InputStream)name);
                }
                finally {
                    ((InputStream)name).close();
                }
            } else if (name instanceof Element) {
                root = (Element)name;
            }
            if (doc == null && root == null) {
                if (quiet) {
                    return;
                }
                throw new RuntimeException(name + " not found");
            }
            if (root == null) {
                root = doc.getDocumentElement();
            }
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal("bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("configuration".equals(prop.getTagName())) {
                    this.loadResource(properties, prop, quiet);
                    continue;
                }
                if (!"property".equals(prop.getTagName())) {
                    LOG.warn("bad conf file: element not <property>");
                }
                NodeList fields = prop.getChildNodes();
                String attr = null;
                String value = null;
                boolean finalParameter = false;
                for (int j = 0; j < fields.getLength(); ++j) {
                    Node fieldNode = fields.item(j);
                    if (!(fieldNode instanceof Element)) continue;
                    Element field = (Element)fieldNode;
                    if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                        attr = ((Text)field.getFirstChild()).getData().trim();
                    }
                    if ("value".equals(field.getTagName()) && field.hasChildNodes()) {
                        value = ((Text)field.getFirstChild()).getData();
                    }
                    if (!"final".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                    finalParameter = "true".equals(((Text)field.getFirstChild()).getData());
                }
                if (attr == null || value == null) continue;
                if (!this.finalParameters.contains(attr)) {
                    properties.setProperty(attr, value);
                    if (!finalParameter) continue;
                    this.finalParameters.add(attr);
                    continue;
                }
                LOG.warn(name + ":a attempt to override final parameter: " + attr + ";  Ignoring.");
            }
        }
        catch (IOException e) {
            LOG.fatal("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            LOG.fatal("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            LOG.fatal("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            LOG.fatal("error parsing conf file: " + e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration: ");
        if (this.loadDefaults) {
            this.toString(defaultResources, sb);
            if (this.resources.size() > 0) {
                sb.append(", ");
            }
        }
        this.toString(this.resources, sb);
        return sb.toString();
    }

    private void toString(ArrayList resources, StringBuffer sb) {
        ListIterator i = resources.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() != 0) {
                sb.append(", ");
            }
            sb.append(i.next());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            this.set(org.apache.hadoop.io.Text.readString(in), org.apache.hadoop.io.Text.readString(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Properties props = this.getProps();
        WritableUtils.writeVInt(out, props.size());
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            org.apache.hadoop.io.Text.writeString(out, (String)item.getKey());
            org.apache.hadoop.io.Text.writeString(out, (String)item.getValue());
        }
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Configuration.class.getClassLoader();
        }
        if (classLoader.getResource("hadoop-site.xml") != null) {
            LOG.warn("DEPRECATED: hadoop-site.xml found in the classpath. Usage of hadoop-site.xml is deprecated. Instead use core-site.xml, mapred-site.xml and hdfs-site.xml to override properties of core-default.xml, mapred-default.xml and hdfs-default.xml respectively");
        }
        Configuration.addDefaultResource("core-default.xml");
        Configuration.addDefaultResource("core-site.xml");
        varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
        MAX_SUBST = 20;
    }
}

