/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileSystem;

public class FSDataOutputStream
extends DataOutputStream {
    private OutputStream wrappedStream;

    @Deprecated
    public FSDataOutputStream(OutputStream out) throws IOException {
        this(out, null);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super(new PositionCache(out, stats, startPosition));
        this.wrappedStream = out;
    }

    public void close() throws IOException {
        this.out.close();
    }

    private static class PositionCache
    extends FilterOutputStream {
        private FileSystem.Statistics statistics;
        long position;

        public PositionCache(OutputStream out, FileSystem.Statistics stats, long pos) throws IOException {
            super(out);
            this.statistics = stats;
            this.position = pos;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(1L);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(len);
            }
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

