/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystem
extends Configured
implements Closeable {
    public static final Log LOG = LogFactory.getLog(FileSystem.class);
    private static final Cache CACHE = new Cache();
    private Cache.Key key;
    private static final Map<Class<? extends FileSystem>, Statistics> statisticsTable = new IdentityHashMap<Class<? extends FileSystem>, Statistics>();
    protected Statistics statistics;
    private Set<Path> deleteOnExit = new TreeSet<Path>();
    private static final ClientFinalizer clientFinalizer = new ClientFinalizer();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    public static URI getDefaultUri(Configuration conf) {
        return URI.create(FileSystem.fixName(conf.get("fs.default.name", "file:///")));
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.statistics = FileSystem.getStatistics(name.getScheme(), this.getClass());
    }

    public abstract URI getUri();

    private static String fixName(String name) {
        if (name.equals("local")) {
            LOG.warn("\"local\" is a deprecated filesystem name. Use \"file:///\" instead.");
            name = "file:///";
        } else if (name.indexOf(47) == -1) {
            LOG.warn("\"" + name + "\" is a deprecated filesystem name." + " Use \"hdfs://" + name + "/\" instead.");
            name = "hdfs://" + name;
        }
        return name;
    }

    public static FileSystem get(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.get(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.get(defaultUri, conf);
        }
        return CACHE.get(uri, conf);
    }

    public static void closeAll() throws IOException {
        CACHE.closeAll();
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.getScheme() == null) {
            return;
        }
        String thisScheme = this.getUri().getScheme();
        String thatScheme = uri.getScheme();
        String thisAuthority = this.getUri().getAuthority();
        String thatAuthority = uri.getAuthority();
        if (thisScheme.equalsIgnoreCase(thatScheme)) {
            if (thisAuthority == thatAuthority || thisAuthority != null && thisAuthority.equalsIgnoreCase(thatAuthority)) {
                return;
            }
            if (thatAuthority == null && thisAuthority != null) {
                URI defaultUri = FileSystem.getDefaultUri(this.getConf());
                if (thisScheme.equalsIgnoreCase(defaultUri.getScheme()) && thisAuthority.equalsIgnoreCase(defaultUri.getAuthority())) {
                    return;
                }
                try {
                    defaultUri = FileSystem.get(this.getConf()).getUri();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (thisScheme.equalsIgnoreCase(defaultUri.getScheme()) && thisAuthority.equalsIgnoreCase(defaultUri.getAuthority())) {
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, FsPermission.getDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    public abstract FSDataOutputStream create(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

    public FSDataOutputStream append(Path f) throws IOException {
        return this.append(f, this.getConf().getInt("io.file.buffer.size", 4096), null);
    }

    public abstract FSDataOutputStream append(Path var1, int var2, Progressable var3) throws IOException;

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteOnExit() {
        Set<Path> set = this.deleteOnExit;
        synchronized (set) {
            Iterator<Path> iter = this.deleteOnExit.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                try {
                    this.delete(path, true);
                }
                catch (IOException e) {
                    LOG.info("Ignoring failure to deleteOnExit for path " + path);
                }
                iter.remove();
            }
        }
    }

    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                if (!filter.accept(listing[i].getPath())) continue;
                results.add(listing[i]);
            }
        }
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + System.getProperty("user.name")).makeQualified(this);
    }

    public abstract Path getWorkingDirectory();

    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirs(f, FsPermission.getDefault());
    }

    public abstract boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    @Override
    public void close() throws IOException {
        this.processDeleteOnExit();
        CACHE.remove(this.key, this);
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public short getDefaultReplication() {
        return 1;
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public void setPermission(Path p, FsPermission permission) throws IOException {
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<?> clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance(clazz, conf);
        fs.initialize(uri, conf);
        return fs;
    }

    public static synchronized Statistics getStatistics(String scheme, Class<? extends FileSystem> cls) {
        Statistics result = statisticsTable.get(cls);
        if (result == null) {
            result = new Statistics(scheme);
            statisticsTable.put(cls, result);
        }
        return result;
    }

    public static final class Statistics {
        private final String scheme;
        private AtomicLong bytesRead = new AtomicLong();
        private AtomicLong bytesWritten = new AtomicLong();

        public Statistics(String scheme) {
            this.scheme = scheme;
        }

        public void incrementBytesRead(long newBytes) {
            this.bytesRead.getAndAdd(newBytes);
        }

        public void incrementBytesWritten(long newBytes) {
            this.bytesWritten.getAndAdd(newBytes);
        }

        public String toString() {
            return this.bytesRead + " bytes read and " + this.bytesWritten + " bytes written";
        }
    }

    static class Cache {
        private final Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();

        Cache() {
        }

        synchronized FileSystem get(URI uri, Configuration conf) throws IOException {
            Key key = new Key(uri, conf);
            FileSystem fs = this.map.get(key);
            if (fs == null) {
                fs = FileSystem.createFileSystem(uri, conf);
                if (this.map.isEmpty() && !clientFinalizer.isAlive()) {
                    Runtime.getRuntime().addShutdownHook(clientFinalizer);
                }
                fs.key = key;
                this.map.put(key, fs);
            }
            return fs;
        }

        synchronized void remove(Key key, FileSystem fs) {
            if (this.map.containsKey(key) && fs == this.map.get(key)) {
                this.map.remove(key);
                if (this.map.isEmpty() && !clientFinalizer.isAlive() && !Runtime.getRuntime().removeShutdownHook(clientFinalizer)) {
                    LOG.info("Could not cancel cleanup thread, though no FileSystems are open");
                }
            }
        }

        synchronized void closeAll() throws IOException {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            while (!this.map.isEmpty()) {
                Map.Entry<Key, FileSystem> e = this.map.entrySet().iterator().next();
                Key key = e.getKey();
                FileSystem fs = e.getValue();
                this.remove(key, fs);
                if (fs == null) continue;
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        static class Key {
            final String scheme;
            final String authority;
            final String username;

            Key(URI uri, Configuration conf) throws IOException {
                this.scheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
                this.authority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
                UserGroupInformation ugi = UserGroupInformation.readFrom(conf);
                if (ugi == null) {
                    try {
                        ugi = UserGroupInformation.login(conf);
                    }
                    catch (LoginException e) {
                        LOG.warn("uri=" + uri, e);
                    }
                }
                this.username = ugi == null ? null : ugi.getUserName();
            }

            public int hashCode() {
                return (this.scheme + this.authority + this.username).hashCode();
            }

            static boolean isEqual(Object a, Object b) {
                return a == b || a != null && a.equals(b);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return Key.isEqual(this.scheme, that.scheme) && Key.isEqual(this.authority, that.authority) && Key.isEqual(this.username, that.username);
                }
                return false;
            }

            public String toString() {
                return this.username + "@" + this.scheme + "://" + this.authority;
            }
        }
    }

    private static class ClientFinalizer
    extends Thread {
        private ClientFinalizer() {
        }

        public synchronized void run() {
            try {
                FileSystem.closeAll();
            }
            catch (IOException e) {
                LOG.info("FileSystem.closeAll() threw an exception:\n" + e);
            }
        }
    }
}

