/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.util.StringUtils;

public class FileUtil {
    public static boolean fullyDelete(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (contents[i].delete()) continue;
                    return false;
                }
                boolean b = false;
                b = contents[i].delete();
                if (b || FileUtil.fullyDelete(contents[i])) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void replaceFile(File src, File target) throws IOException {
        if (!src.renameTo(target)) {
            int retries = 5;
            while (target.exists() && !target.delete() && retries-- >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("replaceFile interrupted.");
                }
            }
            if (!src.renameTo(target)) {
                throw new IOException("Unable to rename " + src + " to " + target);
            }
        }
    }

    public static class HardLink {
        private static String[] hardLinkCommand;
        private static String[] getLinkCountCommand;
        private static OSType osType;

        private static OSType getOSType() {
            String osName = System.getProperty("os.name");
            if (osName.indexOf("Windows") >= 0 && (osName.indexOf("XP") >= 0 || osName.indexOf("2003") >= 0 || osName.indexOf("Vista") >= 0)) {
                return OSType.OS_TYPE_WINXP;
            }
            if (osName.indexOf("SunOS") >= 0) {
                return OSType.OS_TYPE_SOLARIS;
            }
            if (osName.indexOf("Mac") >= 0) {
                return OSType.OS_TYPE_MAC;
            }
            return OSType.OS_TYPE_UNIX;
        }

        public static int getLinkCount(File fileName) throws IOException {
            int len = getLinkCountCommand.length;
            String[] cmd = new String[len + 1];
            for (int i = 0; i < len; ++i) {
                cmd[i] = getLinkCountCommand[i];
            }
            cmd[len] = fileName.toString();
            String inpMsg = "";
            String errMsg = "";
            int exitValue = -1;
            BufferedReader in = null;
            BufferedReader err = null;
            Process process = Runtime.getRuntime().exec(cmd);
            try {
                exitValue = process.waitFor();
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                inpMsg = in.readLine();
                if (inpMsg == null) {
                    inpMsg = "";
                }
                if ((errMsg = (err = new BufferedReader(new InputStreamReader(process.getErrorStream()))).readLine()) == null) {
                    errMsg = "";
                }
                if (exitValue != 0) {
                    throw new IOException(inpMsg + errMsg);
                }
                if (HardLink.getOSType() == OSType.OS_TYPE_SOLARIS) {
                    String[] result = inpMsg.split("\\s+");
                    int n = Integer.parseInt(result[1]);
                    return n;
                }
                int result = Integer.parseInt(inpMsg);
                return result;
            }
            catch (NumberFormatException e) {
                throw new IOException(StringUtils.stringifyException(e) + inpMsg + errMsg + " on file:" + fileName);
            }
            catch (InterruptedException e) {
                throw new IOException(StringUtils.stringifyException(e) + inpMsg + errMsg + " on file:" + fileName);
            }
            finally {
                process.destroy();
                if (in != null) {
                    in.close();
                }
                if (err != null) {
                    err.close();
                }
            }
        }

        static {
            osType = HardLink.getOSType();
            switch (osType) {
                case OS_TYPE_WINXP: {
                    hardLinkCommand = new String[]{"fsutil", "hardlink", "create", null, null};
                    getLinkCountCommand = new String[]{"stat", "-c%h"};
                    break;
                }
                case OS_TYPE_SOLARIS: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"ls", "-l"};
                    break;
                }
                case OS_TYPE_MAC: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"stat", "-f%l"};
                    break;
                }
                default: {
                    hardLinkCommand = new String[]{"ln", null, null};
                    getLinkCountCommand = new String[]{"stat", "-c%h"};
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum OSType {
            OS_TYPE_UNIX,
            OS_TYPE_WINXP,
            OS_TYPE_SOLARIS,
            OS_TYPE_MAC;

        }
    }
}

