/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.UTF8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Storage
extends StorageInfo {
    public static final Log LOG = LogFactory.getLog(Storage.class.getName());
    private HdfsConstants.NodeType storageType;
    protected List<StorageDirectory> storageDirs = new ArrayList<StorageDirectory>();

    public Iterator<StorageDirectory> dirIterator() {
        return this.dirIterator(null);
    }

    public Iterator<StorageDirectory> dirIterator(StorageDirType dirType) {
        return new DirIterator(dirType);
    }

    protected Storage(HdfsConstants.NodeType type) {
        this.storageType = type;
    }

    public StorageDirectory getStorageDir(int idx) {
        return this.storageDirs.get(idx);
    }

    protected void setFields(Properties props, StorageDirectory sd) throws IOException {
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        props.setProperty("cTime", String.valueOf(this.cTime));
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from.getCanonicalPath() + " to " + to.getCanonicalPath());
        }
    }

    protected static void deleteDir(File dir) throws IOException {
        if (!FileUtil.fullyDelete(dir)) {
            throw new IOException("Failed to delete " + dir.getCanonicalPath());
        }
    }

    public void writeAll() throws IOException {
        this.layoutVersion = -18;
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().write();
        }
    }

    public void unlockAll() throws IOException {
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().unlock();
        }
    }

    public static String getRegistrationID(StorageInfo storage) {
        return "NS-" + Integer.toString(storage.getNamespaceID()) + "-" + Integer.toString(storage.getLayoutVersion()) + "-" + Long.toString(storage.getCTime());
    }

    protected abstract void corruptPreUpgradeStorage(File var1) throws IOException;

    protected void writeCorruptedData(RandomAccessFile file) throws IOException {
        String messageForPreUpgradeVersion = "\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n";
        file.seek(0L);
        file.writeInt(-18);
        UTF8.writeString(file, "");
        file.writeBytes("\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n");
        file.getFD().sync();
    }

    public class StorageDirectory {
        File root;
        FileLock lock;
        StorageDirType dirType;
        final /* synthetic */ Storage this$0;

        public File getRoot() {
            return this.root;
        }

        public StorageDirType getStorageDirType() {
            return this.dirType;
        }

        public void write() throws IOException {
            this.this$0.corruptPreUpgradeStorage(this.root);
            this.write(this.getVersionFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File to) throws IOException {
            Properties props = new Properties();
            this.this$0.setFields(props, this);
            RandomAccessFile file = new RandomAccessFile(to, "rws");
            FileOutputStream out = null;
            try {
                file.seek(0L);
                out = new FileOutputStream(file.getFD());
                props.store(out, null);
                file.setLength(out.getChannel().position());
            }
            finally {
                if (out != null) {
                    out.close();
                }
                file.close();
            }
        }

        public File getCurrentDir() {
            return new File(this.root, "current");
        }

        public File getVersionFile() {
            return new File(new File(this.root, "current"), "VERSION");
        }

        public File getPreviousDir() {
            return new File(this.root, "previous");
        }

        public File getFinalizedTmp() {
            return new File(this.root, "finalized.tmp");
        }

        public void unlock() throws IOException {
            if (this.lock == null) {
                return;
            }
            this.lock.release();
            this.lock.channel().close();
            this.lock = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirIterator
    implements Iterator<StorageDirectory> {
        StorageDirType dirType;
        int prevIndex;
        int nextIndex;

        DirIterator(StorageDirType dirType) {
            this.dirType = dirType;
            this.nextIndex = 0;
            this.prevIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (Storage.this.storageDirs.isEmpty() || this.nextIndex >= Storage.this.storageDirs.size()) {
                return false;
            }
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
                if (this.nextIndex >= Storage.this.storageDirs.size()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public StorageDirectory next() {
            StorageDirectory sd = Storage.this.getStorageDir(this.nextIndex);
            this.prevIndex = this.nextIndex++;
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
            }
            return sd;
        }

        @Override
        public void remove() {
            this.nextIndex = this.prevIndex;
            Storage.this.storageDirs.remove(this.prevIndex);
            this.hasNext();
        }
    }

    public static interface StorageDirType {
        public boolean isOfType(StorageDirType var1);
    }
}

