/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

class DataXceiverServer
implements Runnable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    ServerSocket ss;
    DataNode datanode;
    Map<Socket, Socket> childSockets;
    int maxXceiverCount;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    public void run() {
        while (this.datanode.shouldRun) {
            try {
                Socket s = this.ss.accept();
                s.setTcpNoDelay(true);
                new Daemon(this.datanode.threadGroup, new DataXceiver(s, this.datanode, this)).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (IOException ie) {
                LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie));
            }
            catch (Throwable te) {
                LOG.error(this.datanode.dnRegistration + ":DataXceiveServer: Exiting due to:" + StringUtils.stringifyException(te));
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer.kill(): " + StringUtils.stringifyException(ie));
        }
        Map<Socket, Socket> map = this.childSockets;
        synchronized (map) {
            for (Socket thissock : this.childSockets.values()) {
                try {
                    thissock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static class BlockBalanceThrottler
    extends BlockTransferThrottler {
        private int numThreads;

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

