/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.metrics.MetricsRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSDirectory
implements Closeable,
FSConstants {
    final FSNamesystem namesystem;
    final INodeDirectoryWithQuota rootDir;
    FSImage fsImage;
    private boolean ready;
    private MetricsRecord directoryMetrics;

    private void incrDeletedFileCount(int count) {
        this.directoryMetrics.incrMetric("files_deleted", count);
        this.directoryMetrics.update();
    }

    @Override
    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFileUnderConstruction addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            newNode = this.addNode(path, newNode, -1L, false);
        }
        if (newNode == null) {
            NameNode.stateChangeLog.info("DIR* FSDirectory.addFile: failed to add " + path + " to the file system");
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        NameNode.stateChangeLog.debug("DIR* FSDirectory.addFile: " + path + " is added to the file system");
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block addBlock(String path, INode[] inodes, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeFile fileNode = (INodeFile)inodes[inodes.length - 1];
            this.updateCount(inodes, inodes.length - 1, 0L, fileNode.getPreferredBlockSize() * (long)fileNode.getReplication());
            this.namesystem.blocksMap.addINode(block, fileNode);
            BlocksMap.BlockInfo blockInfo = this.namesystem.blocksMap.getStoredBlock(block);
            fileNode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the in-memory " + "file system");
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INodeFile file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logCloseFile(path, file);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            fileNode.removeBlock(block);
            this.namesystem.blocksMap.removeINode(block);
            this.namesystem.corruptReplicas.removeFromCorruptReplicasMap(block);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the file system");
        }
        return true;
    }

    boolean renameTo(String src, String dst) throws QuotaExceededException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] srcInodes = this.rootDir.getExistingPathINodes(src);
            if (srcInodes[srcInodes.length - 1] == null) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist");
                return false;
            }
            if (srcInodes.length == 1) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root");
                return false;
            }
            if (this.isDir(dst)) {
                dst = dst + "/" + new Path(src).getName();
            }
            INode srcChild = null;
            try {
                srcChild = this.removeChild(srcInodes, srcInodes.length - 1);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (srcChild == null) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed");
                return false;
            }
            String srcChildName = srcChild.getLocalName();
            INode dstChild = null;
            QuotaExceededException failureByQuota = null;
            byte[][] dstComponents = INode.getPathComponents(dst);
            INode[] dstInodes = new INode[dstComponents.length];
            this.rootDir.getExistingPathINodes(dstComponents, dstInodes);
            if (dstInodes[dstInodes.length - 1] != null) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists");
            } else if (dstInodes[dstInodes.length - 2] == null) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exists");
            } else {
                srcChild.setLocalName(dstComponents[dstInodes.length - 1]);
                try {
                    dstChild = this.addChild(dstInodes, dstInodes.length - 1, srcChild, false);
                }
                catch (QuotaExceededException qe) {
                    failureByQuota = qe;
                }
            }
            if (dstChild != null) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                srcInodes[srcInodes.length - 2].setModificationTime(timestamp);
                dstInodes[dstInodes.length - 2].setModificationTime(timestamp);
                return true;
            }
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
            try {
                srcChild.setLocalName(srcChildName);
                this.addChild(srcInodes, srcInodes.length - 1, srcChild, false);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (failureByQuota != null) {
                throw failureByQuota;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return false;
            }
            return inode.isDirectory() ? true : ((INodeFile)inode).getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions);
        }
    }

    INode delete(String src) {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + src);
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        INode deletedNode = this.unprotectedDelete(src, now);
        if (deletedNode != null) {
            this.fsImage.getEditLog().logDelete(src, now);
        }
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirEmpty(String src) {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            assert (targetNode != null) : "should be taken care in isDir() above";
            if (((INodeDirectory)targetNode).getChildren().size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedDelete(String src, long modificationTime) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(src);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist");
                return null;
            }
            if (inodes.length == 1) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted");
                return null;
            }
            try {
                this.removeChild(inodes, inodes.length - 1);
                inodes[inodes.length - 2].setModificationTime(modificationTime);
                ArrayList<Block> v = new ArrayList<Block>();
                int filesRemoved = targetNode.collectSubtreeBlocksAndClear(v);
                this.incrDeletedFileCount(filesRemoved);
                this.namesystem.removePathAndBlocks(src, v);
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + src + " is removed");
                }
                return targetNode;
            }
            catch (IOException e) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because " + e.getMessage());
                return null;
            }
        }
    }

    void replaceNode(String path, INodeFile oldnode, INodeFile newnode) throws IOException {
        this.replaceNode(path, oldnode, newnode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNode(String path, INodeFile oldnode, INodeFile newnode, boolean updateDiskspace) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            long dsOld = oldnode.diskspaceConsumed();
            if (!oldnode.removeNode()) {
                NameNode.stateChangeLog.warn("DIR* FSDirectory.replaceNode: failed to remove " + path);
                throw new IOException("FSDirectory.replaceNode: failed to remove " + path);
            }
            this.rootDir.addNode(path, newnode);
            long dsNew = 0L;
            if (updateDiskspace && (dsNew = newnode.diskspaceConsumed()) != dsOld) {
                try {
                    this.updateSpaceConsumed(path, 0L, dsNew - dsOld);
                }
                catch (QuotaExceededException e) {
                    this.replaceNode(path, newnode, oldnode, false);
                    throw e;
                }
            }
            int index = 0;
            for (BlocksMap.BlockInfo b : newnode.getBlocks()) {
                BlocksMap.BlockInfo info = this.namesystem.blocksMap.addINode(b, newnode);
                newnode.setBlock(index, info);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileStatus[] getListing(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new FileStatus[]{FSDirectory.createFileStatus(srcs, targetNode)};
            }
            List<INode> contents = ((INodeDirectory)targetNode).getChildren();
            FileStatus[] listing = new FileStatus[contents.size()];
            if (!srcs.endsWith("/")) {
                srcs = srcs + "/";
            }
            int i = 0;
            for (INode cur : contents) {
                listing[i] = FSDirectory.createFileStatus(srcs + cur.getLocalName(), cur);
                ++i;
            }
            return listing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileStatus getFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            return FSDirectory.createFileStatus(srcs, targetNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            if (targetNode == null) {
                return null;
            }
            if (targetNode.isDirectory()) {
                return null;
            }
            return ((INodeFile)targetNode).getBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile getFileINode(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null || inode.isDirectory()) {
                return null;
            }
            return (INodeFile)inode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode[] getExistingPathINodes(String path) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getExistingPathINodes(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode[] inodes = this.rootDir.getExistingPathINodes(path);
            int len = inodes.length;
            if (inodes[len - 1] == null) {
                throw new FileNotFoundException(path + " does not exist under rootDir.");
            }
            this.updateCount(inodes, len - 1, nsDelta, dsDelta);
        }
    }

    private void updateCount(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta) throws QuotaExceededException {
        int i;
        if (!this.ready) {
            return;
        }
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        try {
            for (i = 0; i < numOfINodes; ++i) {
                if (!inodes[i].isQuotaSet()) continue;
                INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
                node.updateNumItemsInTree(nsDelta, dsDelta);
            }
        }
        catch (QuotaExceededException e) {
            e.setPathName(FSDirectory.getFullPathName(inodes, i));
            while (i-- > 0) {
                try {
                    if (!inodes[i].isQuotaSet()) continue;
                    INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
                    node.updateNumItemsInTree(-nsDelta, -dsDelta);
                }
                catch (IOException ingored) {}
            }
            throw e;
        }
    }

    private static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws FileNotFoundException, QuotaExceededException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            int i;
            this.rootDir.getExistingPathINodes(components, inodes);
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileNotFoundException("Parent path is not a directory: " + pathbuilder);
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                this.unprotectedMkdir(inodes, i, components[i], permissions, inheritPermission || i != components.length - 1, now);
                if (inodes[i] == null) {
                    return false;
                }
                if (this.namesystem != null) {
                    NameNode.getNameNodeMetrics().numFilesCreated.inc();
                }
                this.fsImage.getEditLog().logMkDir(cur, inodes[i]);
                NameNode.stateChangeLog.debug("DIR* FSDirectory.mkdirs: created directory " + cur);
                ++i;
            }
        }
        return true;
    }

    private void unprotectedMkdir(INode[] inodes, int pos, byte[] name, PermissionStatus permission, boolean inheritPermission, long timestamp) throws QuotaExceededException {
        inodes[pos] = this.addChild(inodes, pos, new INodeDirectory(name, permission, timestamp), inheritPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends INode> T addNode(String src, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            return this.addChild(inodes, inodes.length - 1, child, childDiskspace, inheritPermission);
        }
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, boolean inheritPermission) throws QuotaExceededException {
        return this.addChild(pathComponents, pos, child, -1L, inheritPermission);
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, long childDiskspace, boolean inheritPermission) throws QuotaExceededException {
        INode.DirCounts counts = new INode.DirCounts();
        child.spaceConsumedInTree(counts);
        if (childDiskspace < 0L) {
            childDiskspace = counts.getDsCount();
        }
        this.updateCount(pathComponents, pos, counts.getNsCount(), childDiskspace);
        T addedNode = ((INodeDirectory)pathComponents[pos - 1]).addChild(child, inheritPermission);
        if (addedNode == null) {
            this.updateCount(pathComponents, pos, -counts.getNsCount(), -childDiskspace);
        }
        return addedNode;
    }

    private INode removeChild(INode[] pathComponents, int pos) throws QuotaExceededException {
        INode removedNode = ((INodeDirectory)pathComponents[pos - 1]).removeChild(pathComponents[pos]);
        if (removedNode != null) {
            INode.DirCounts counts = new INode.DirCounts();
            removedNode.spaceConsumedInTree(counts);
            this.updateCount(pathComponents, pos, -counts.getNsCount(), -counts.getDsCount());
        }
        return removedNode;
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.numItemsInTree();
        }
    }

    void setTimes(String src, INodeFile inode, long mtime, long atime, boolean force) throws IOException {
        if (this.unprotectedSetTimes(src, inode, mtime, atime, force)) {
            this.fsImage.getEditLog().logTimes(src, mtime, atime);
        }
    }

    private boolean unprotectedSetTimes(String src, INodeFile inode, long mtime, long atime, boolean force) throws IOException {
        boolean status = false;
        if (mtime != -1L) {
            inode.setModificationTimeForce(mtime);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + this.namesystem.getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime);
                status = true;
            }
        }
        return status;
    }

    private static FileStatus createFileStatus(String path, INode node) {
        return new FileStatus(node.isDirectory() ? 0L : node.computeContentSummary().getLength(), node.isDirectory(), node.isDirectory() ? (short)0 : ((INodeFile)node).getReplication(), node.isDirectory() ? 0L : ((INodeFile)node).getPreferredBlockSize(), node.getModificationTime(), node.getAccessTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), new Path(path));
    }
}

