/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSEditLog {
    private static int sizeFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private boolean isSyncRunning;
    private long numTransactions;
    private long numTransactionsBatchedInSync;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };
    private static final LongWritable longWritable = new LongWritable();

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = FSNamesystem.now();
    }

    private int getNumStorageDirs() {
        int numStorageDirs = 0;
        Iterator<Storage.StorageDirectory> it = this.fsimage.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            ++numStorageDirs;
            it.next();
        }
        return numStorageDirs;
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    public synchronized void close() throws IOException {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.editStreams == null) {
            return;
        }
        this.printStatistics(true);
        this.numTransactionsBatchedInSync = 0L;
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.setReadyToFlush();
                eStream.flush();
                eStream.close();
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
        this.editStreams.clear();
    }

    synchronized void processIOError(int index) {
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal("Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        assert (index < this.getNumStorageDirs());
        assert (this.getNumStorageDirs() == this.editStreams.size());
        File parentStorageDir = ((EditLogFileOutputStream)this.editStreams.get(index)).getFile().getParentFile().getParentFile();
        this.editStreams.remove(index);
        this.fsimage.processIOError(parentStorageDir);
    }

    synchronized void processIOError(Storage.StorageDirectory sd) {
        if (!sd.getStorageDirType().isOfType(FSImage.NameNodeDirType.EDITS)) {
            return;
        }
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal("Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            File parentStorageDir = ((EditLogFileOutputStream)this.editStreams.get(idx)).getFile().getParentFile().getParentFile();
            if (!parentStorageDir.getName().equals(sd.getRoot().getName())) continue;
            this.editStreams.remove(idx);
        }
    }

    private void processIOError(ArrayList<EditLogOutputStream> errorStreams) {
        if (errorStreams == null) {
            return;
        }
        for (int idx = 0; idx < errorStreams.size(); ++idx) {
            EditLogOutputStream eStream = errorStreams.get(idx);
            int j = 0;
            int numEditStreams = this.editStreams.size();
            for (j = 0; j < numEditStreams && this.editStreams.get(j) != eStream; ++j) {
            }
            if (j == numEditStreams) {
                FSNamesystem.LOG.error("Unable to find sync log on which  IO error occured. Fatal Error.");
                Runtime.getRuntime().exit(-1);
            }
            this.processIOError(j);
        }
        this.fsimage.incrementCheckpointTime();
    }

    synchronized void logEdit(byte op, Writable ... writables) {
        assert (this.getNumEditStreams() > 0) : "no editlog streams";
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.write(op, writables);
                continue;
            }
            catch (IOException ie) {
                this.processIOError(idx);
                --idx;
            }
        }
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = FSNamesystem.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        if (this.metrics != null) {
            this.metrics.transactions.inc(end - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSync() throws IOException {
        int numEditStreams;
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        long mytxid = FSEditLog.myTransactionId.get().txid;
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            numEditStreams = this.editStreams.size();
            assert (numEditStreams > 0) : "no editlog streams";
            this.printStatistics(false);
            while (mytxid > this.synctxid && this.isSyncRunning) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (mytxid <= this.synctxid) {
                ++this.numTransactionsBatchedInSync;
                if (this.metrics != null) {
                    this.metrics.transactionsBatchedInSync.inc();
                }
                return;
            }
            syncStart = this.txid;
            this.isSyncRunning = true;
            for (int idx = 0; idx < numEditStreams; ++idx) {
                this.editStreams.get(idx).setReadyToFlush();
            }
        }
        long start = FSNamesystem.now();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flush();
                continue;
            }
            catch (IOException ie) {
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
                FSNamesystem.LOG.error("Unable to sync edit log. Fatal Error.");
            }
        }
        long elapsed = FSNamesystem.now() - start;
        FSEditLog fSEditLog2 = this;
        synchronized (fSEditLog2) {
            this.processIOError(errorStreams);
            this.synctxid = syncStart;
            this.isSyncRunning = false;
            this.notifyAll();
        }
        if (this.metrics != null) {
            this.metrics.syncs.inc(elapsed);
        }
    }

    private void printStatistics(boolean force) {
        long now = FSNamesystem.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null || this.editStreams.size() == 0) {
            return;
        }
        this.lastPrintTime = now;
        StringBuilder buf = new StringBuilder();
        buf.append("Number of transactions: ");
        buf.append(this.numTransactions);
        buf.append(" Total time for transactions(ms): ");
        buf.append(this.totalTimeTransactions);
        buf.append("Number of transactions batched in Syncs: ");
        buf.append(this.numTransactionsBatchedInSync);
        buf.append(" Number of syncs: ");
        buf.append(this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        int numEditStreams = this.editStreams.size();
        for (int idx = 0; idx < numEditStreams; ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        FSNamesystem.LOG.info(buf);
    }

    public void logOpenFile(String string, INodeFileUnderConstruction iNodeFileUnderConstruction) throws IOException {
        Writable[] writableArray = new UTF8[]{new UTF8(string), FSEditLog.toLogReplication(iNodeFileUnderConstruction.getReplication()), FSEditLog.toLogLong(iNodeFileUnderConstruction.getModificationTime()), FSEditLog.toLogLong(iNodeFileUnderConstruction.getAccessTime()), FSEditLog.toLogLong(iNodeFileUnderConstruction.getPreferredBlockSize())};
        this.logEdit((byte)0, new ArrayWritable(UTF8.class, writableArray), new ArrayWritable(Block.class, iNodeFileUnderConstruction.getBlocks()), iNodeFileUnderConstruction.getPermissionStatus(), new UTF8(iNodeFileUnderConstruction.getClientName()), new UTF8(iNodeFileUnderConstruction.getClientMachine()));
    }

    public void logCloseFile(String string, INodeFile iNodeFile) {
        Writable[] writableArray = new UTF8[]{new UTF8(string), FSEditLog.toLogReplication(iNodeFile.getReplication()), FSEditLog.toLogLong(iNodeFile.getModificationTime()), FSEditLog.toLogLong(iNodeFile.getAccessTime()), FSEditLog.toLogLong(iNodeFile.getPreferredBlockSize())};
        this.logEdit((byte)9, new ArrayWritable(UTF8.class, writableArray), new ArrayWritable(Block.class, iNodeFile.getBlocks()), iNodeFile.getPermissionStatus());
    }

    public void logMkDir(String string, INode iNode) {
        Writable[] writableArray = new UTF8[]{new UTF8(string), FSEditLog.toLogLong(iNode.getModificationTime()), FSEditLog.toLogLong(iNode.getAccessTime())};
        this.logEdit((byte)3, new ArrayWritable(UTF8.class, writableArray), iNode.getPermissionStatus());
    }

    void logRename(String string, String string2, long l) {
        Writable[] writableArray = new UTF8[]{new UTF8(string), new UTF8(string2), FSEditLog.toLogLong(l)};
        this.logEdit((byte)1, new ArrayWritable(UTF8.class, writableArray));
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new UTF8(src), permissions);
    }

    void logDelete(String string, long l) {
        Writable[] writableArray = new UTF8[]{new UTF8(string), FSEditLog.toLogLong(l)};
        this.logEdit((byte)2, new ArrayWritable(UTF8.class, writableArray));
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new LongWritable(genstamp));
    }

    void logTimes(String string, long l, long l2) {
        Writable[] writableArray = new UTF8[]{new UTF8(string), FSEditLog.toLogLong(l), FSEditLog.toLogLong(l2)};
        this.logEdit((byte)13, new ArrayWritable(UTF8.class, writableArray));
    }

    private static UTF8 toLogReplication(short replication) {
        return new UTF8(Short.toString(replication));
    }

    private static UTF8 toLogLong(long timestamp) {
        return new UTF8(Long.toString(timestamp));
    }

    private static class EditLogFileOutputStream
    extends EditLogOutputStream {
        private File file;
        private FileOutputStream fp;
        private FileChannel fc;
        private DataOutputBuffer bufCurrent;
        private DataOutputBuffer bufReady;
        static ByteBuffer fill = ByteBuffer.allocateDirect(512);

        public void write(int b) throws IOException {
            this.bufCurrent.write(b);
        }

        void write(byte op, Writable ... writables) throws IOException {
            this.write(op);
            for (Writable w : writables) {
                w.write(this.bufCurrent);
            }
        }

        public void close() throws IOException {
            int bufSize = this.bufCurrent.size();
            if (bufSize != 0) {
                throw new IOException("FSEditStream has " + bufSize + " bytes still to be flushed and cannot " + "be closed.");
            }
            this.bufCurrent.close();
            this.bufReady.close();
            this.fc.truncate(this.fc.position());
            this.fp.close();
            this.bufReady = null;
            this.bufCurrent = null;
        }

        void setReadyToFlush() throws IOException {
            assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
            this.write(-1);
            DataOutputBuffer tmp = this.bufReady;
            this.bufReady = this.bufCurrent;
            this.bufCurrent = tmp;
        }

        protected void flushAndSync() throws IOException {
            this.preallocate();
            this.bufReady.writeTo(this.fp);
            this.bufReady.reset();
            this.fc.force(false);
            this.fc.position(this.fc.position() - 1L);
        }

        private void preallocate() throws IOException {
            long position = this.fc.position();
            if (position + 4096L >= this.fc.size()) {
                FSNamesystem.LOG.debug("Preallocating Edit log, current size " + this.fc.size());
                long newsize = position + 0x100000L;
                fill.position(0);
                int written = this.fc.write(fill, newsize);
                FSNamesystem.LOG.debug("Edit log size is now " + this.fc.size() + " written " + written + " bytes " + " at offset " + newsize);
            }
        }

        File getFile() {
            return this.file;
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }
}

