/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.io.UTF8;

public class FSImage
extends Storage {
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected long checkpointTime = -1L;
    private FSEditLog editLog = null;
    private boolean isUpgradeFinalized = false;
    protected List<Storage.StorageDirectory> removedStorageDirs = new ArrayList<Storage.StorageDirectory>();
    private volatile CheckpointStates ckptState = CheckpointStates.START;
    private static final FsPermission FILE_PERM = new FsPermission(0);
    private static final byte[] PATH_SEPARATOR = INode.string2Bytes("/");
    private static final UTF8 U_STR = new UTF8();

    FSImage() {
        super(HdfsConstants.NodeType.NAME_NODE);
        this.editLog = new FSEditLog(this);
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        boolean uState = this.getDistributedUpgradeState();
        int uVersion = this.getDistributedUpgradeVersion();
        if (uState && uVersion != this.getLayoutVersion()) {
            props.setProperty("distributedUpgradeState", Boolean.toString(uState));
            props.setProperty("distributedUpgradeVersion", Integer.toString(uVersion));
        }
        this.writeCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        if (this.checkpointTime < 0L) {
            return;
        }
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        if (timeFile.exists()) {
            timeFile.delete();
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(timeFile));
        try {
            out.writeLong(this.checkpointTime);
        }
        finally {
            out.close();
        }
    }

    void incrementCheckpointTime() {
        ++this.checkpointTime;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                this.writeCheckpointTime(sd);
            }
            catch (IOException e) {
                if (sd.getStorageDirType().isOfType(NameNodeDirType.EDITS)) {
                    this.editLog.processIOError(sd);
                }
                this.removedStorageDirs.add(sd);
                it.remove();
            }
        }
    }

    void processIOError(File dirName) {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getRoot().getPath().equals(dirName.getPath())) continue;
            LOG.info(" removing " + dirName.getPath());
            this.removedStorageDirs.add(sd);
            it.remove();
        }
    }

    public FSEditLog getEditLog() {
        return this.editLog;
    }

    void close() throws IOException {
        this.getEditLog().close();
        this.unlockAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void corruptPreUpgradeStorage(File file) throws IOException {
        File file2 = new File(file, "image");
        if (!file2.exists() && !file2.mkdir()) {
            throw new IOException("Cannot create directory " + file2);
        }
        File file3 = new File(file2, "fsimage");
        if (!file3.exists() && !file3.createNewFile()) {
            throw new IOException("Cannot create file " + file3);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "rws");
        try {
            this.writeCorruptedData(randomAccessFile);
        }
        finally {
            randomAccessFile.close();
        }
    }

    private boolean getDistributedUpgradeState() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeState();
    }

    private int getDistributedUpgradeVersion() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeVersion();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameNodeDirType implements Storage.StorageDirType
    {
        UNDEFINED,
        IMAGE,
        EDITS,
        IMAGE_AND_EDITS;


        @Override
        public boolean isOfType(Storage.StorageDirType type) {
            if (this == IMAGE_AND_EDITS && (type == IMAGE || type == EDITS)) {
                return true;
            }
            return this == type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CheckpointStates {
        START,
        ROLLED_EDITS,
        UPLOAD_START,
        UPLOAD_DONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

