/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;

class INodeDirectoryWithQuota
extends INodeDirectory {
    private long nsQuota;
    private long nsCount;
    private long dsQuota;
    private long diskspace;

    long getNsQuota() {
        return this.nsQuota;
    }

    long getDsQuota() {
        return this.dsQuota;
    }

    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        counts.nsCount += this.nsCount;
        counts.dsCount += this.diskspace;
        return counts;
    }

    long numItemsInTree() {
        return this.nsCount;
    }

    void updateNumItemsInTree(long nsDelta, long dsDelta) throws QuotaExceededException {
        long newCount = this.nsCount + nsDelta;
        long newDiskspace = this.diskspace + dsDelta;
        if (nsDelta > 0L || dsDelta > 0L) {
            INodeDirectoryWithQuota.verifyQuota(this.nsQuota, newCount, this.dsQuota, newDiskspace);
        }
        this.nsCount = newCount;
        this.diskspace = newDiskspace;
    }

    private static void verifyQuota(long nsQuota, long nsCount, long dsQuota, long diskspace) throws QuotaExceededException {
        if (nsQuota >= 0L && nsQuota < nsCount) {
            throw new NSQuotaExceededException(nsQuota, nsCount);
        }
        if (dsQuota >= 0L && dsQuota < diskspace) {
            throw new DSQuotaExceededException(dsQuota, diskspace);
        }
    }
}

