/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;

public class NameNode
implements ClientProtocol,
FSConstants,
DatanodeProtocol,
NamenodeProtocol,
RefreshAuthorizationPolicyProtocol {
    public static final Log LOG;
    public static final Log stateChangeLog;
    public FSNamesystem namesystem;
    static NameNodeMetrics myMetrics;

    public long getProtocolVersion(String string, long l) throws IOException {
        if (string.equals(ClientProtocol.class.getName())) {
            return 41L;
        }
        if (string.equals(DatanodeProtocol.class.getName())) {
            return 19L;
        }
        if (string.equals(NamenodeProtocol.class.getName())) {
            return 2L;
        }
        if (string.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + string);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return myMetrics;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr(address, 8020);
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        NameNode.myMetrics.numGetBlockLocations.inc();
        return this.namesystem.getBlockLocations(NameNode.getClientMachine(), src, offset, length);
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    public void create(String src, FsPermission masked, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.startFile(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked), clientName, clientMachine, overwrite, replication, blockSize);
        NameNode.myMetrics.numFilesCreated.inc();
        NameNode.myMetrics.numCreateFileOps.inc();
    }

    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine);
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        NameNode.myMetrics.numFilesAppended.inc();
        return info;
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    public LocatedBlock addBlock(String src, String clientName) throws IOException {
        stateChangeLog.debug("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName);
        LocatedBlock locatedBlock = this.namesystem.getAdditionalBlock(src, clientName);
        if (locatedBlock != null) {
            NameNode.myMetrics.numAddBlockOps.inc();
        }
        return locatedBlock;
    }

    public void abandonBlock(Block b, String src, String holder) throws IOException {
        stateChangeLog.debug("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src);
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    public boolean complete(String src, String clientName) throws IOException {
        stateChangeLog.debug("*DIR* NameNode.complete: " + src + " for " + clientName);
        FSNamesystem.CompleteFileStatus returnCode = this.namesystem.completeFile(src, clientName);
        if (returnCode == FSNamesystem.CompleteFileStatus.STILL_WAITING) {
            return false;
        }
        if (returnCode == FSNamesystem.CompleteFileStatus.COMPLETE_SUCCESS) {
            return true;
        }
        throw new IOException("Could not complete write to file " + src + " by " + clientName);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        stateChangeLog.info("*DIR* NameNode.reportBadBlocks");
        for (int i = 0; i < blocks.length; ++i) {
            Block blk = blocks[i].getBlock();
            DatanodeInfo[] nodes = blocks[i].getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfo dn = nodes[j];
                this.namesystem.markBlockAsCorrupt(blk, dn);
            }
        }
    }

    public long nextGenerationStamp(Block block) throws IOException {
        return this.namesystem.nextGenerationStampForBlock(block);
    }

    public void commitBlockSynchronization(Block block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets);
    }

    public boolean rename(String src, String dst) throws IOException {
        stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            NameNode.myMetrics.numFilesRenamed.inc();
        }
        return ret;
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive);
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            NameNode.myMetrics.numDeleteFileOps.inc();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    public boolean mkdirs(String src, FsPermission masked) throws IOException {
        stateChangeLog.debug("*DIR* NameNode.mkdirs: " + src);
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked));
    }

    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    public FileStatus[] getListing(String src) throws IOException {
        FileStatus[] files = this.namesystem.getListing(src);
        if (files != null) {
            NameNode.myMetrics.numGetListingOps.inc();
        }
        return files;
    }

    public FileStatus getFileInfo(String src) throws IOException {
        NameNode.myMetrics.numFileInfoOps.inc();
        return this.namesystem.getFileInfo(src);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    public DatanodeRegistration register(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    public DatanodeCommand[] sendHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xmitsInProgress, int xceiverCount) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, capacity, dfsUsed, remaining, xceiverCount, xmitsInProgress);
    }

    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, long[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(blocks);
        stateChangeLog.debug("*BLOCK* NameNode.blockReport: from " + nodeReg.getName() + " " + blist.getNumberOfBlocks() + " blocks");
        this.namesystem.processReport(nodeReg, blist);
        if (this.getFSImage().isUpgradeFinalized()) {
            return DatanodeCommand.FINALIZE;
        }
        return null;
    }

    public void blockReceived(DatanodeRegistration nodeReg, Block[] blocks, String[] delHints) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug("*BLOCK* NameNode.blockReceived: from " + nodeReg.getName() + " " + blocks.length + " blocks.");
        for (int i = 0; i < blocks.length; ++i) {
            this.namesystem.blockReceived(nodeReg, blocks[i], delHints[i]);
        }
    }

    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName = nodeReg == null ? "unknown DataNode" : nodeReg.getName();
        LOG.info("Error report from " + dnName + ": " + msg);
        if (errorCode == 0) {
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            this.namesystem.removeDatanode(nodeReg);
        }
    }

    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.namesystem.processDistributedUpgradeCommand(comm);
    }

    public void verifyRequest(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            throw new UnregisteredDatanodeException(nodeReg);
        }
    }

    public void verifyVersion(int n) throws IOException {
        if (n != -18) {
            throw new IncorrectVersionException(n, "data node");
        }
    }

    public FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        LOG = LogFactory.getLog(NameNode.class.getName());
        stateChangeLog = LogFactory.getLog("org.apache.hadoop.hdfs.StateChange");
    }
}

