/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class DatanodeRegistration
extends DatanodeID
implements Writable {
    public StorageInfo storageInfo = new StorageInfo();

    public DatanodeRegistration() {
        this("");
    }

    public DatanodeRegistration(String nodeName) {
        super(nodeName);
    }

    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ", storageID=" + this.storageID + ", infoPort=" + this.infoPort + ", ipcPort=" + this.ipcPort + ")";
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        out.writeInt(this.storageInfo.getLayoutVersion());
        out.writeInt(this.storageInfo.getNamespaceID());
        out.writeLong(this.storageInfo.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.ipcPort = in.readShort() & 0xFFFF;
        this.storageInfo.layoutVersion = in.readInt();
        this.storageInfo.namespaceID = in.readInt();
        this.storageInfo.cTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(DatanodeRegistration.class, new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeRegistration();
            }
        });
    }
}

