/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class UpgradeCommand
extends DatanodeCommand {
    private int version;
    private short upgradeStatus;

    public UpgradeCommand() {
        super(0);
        this.version = 0;
        this.upgradeStatus = 0;
    }

    public UpgradeCommand(int action, int version, short status) {
        super(action);
        this.version = version;
        this.upgradeStatus = status;
    }

    public int getVersion() {
        return this.version;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.version);
        out.writeShort(this.upgradeStatus);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.version = in.readInt();
        this.upgradeStatus = in.readShort();
    }

    static {
        WritableFactories.setFactory(UpgradeCommand.class, new WritableFactory(){

            public Writable newInstance() {
                return new UpgradeCommand();
            }
        });
    }
}

