/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayWritable
implements Writable {
    private Class<? extends Writable> valueClass;
    private Writable[] values;

    public ArrayWritable(Class<? extends Writable> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException("null valueClass");
        }
        this.valueClass = valueClass;
    }

    public ArrayWritable(Class<? extends Writable> valueClass, Writable[] values) {
        this(valueClass);
        this.values = values;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.values = new Writable[in.readInt()];
        for (int i = 0; i < this.values.length; ++i) {
            Writable value = WritableFactories.newInstance(this.valueClass);
            value.readFields(in);
            this.values[i] = value;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].write(out);
        }
    }
}

