/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MD5Hash
implements WritableComparable<MD5Hash> {
    private static ThreadLocal<MessageDigest> DIGESTER_FACTORY = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private byte[] digest;
    private static final char[] HEX_DIGITS;

    public MD5Hash() {
        this.digest = new byte[16];
    }

    public MD5Hash(byte[] digest) {
        if (digest.length != 16) {
            throw new IllegalArgumentException("Wrong length: " + digest.length);
        }
        this.digest = digest;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        in.readFully(this.digest);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.digest);
    }

    public static MD5Hash digest(InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        MessageDigest digester = DIGESTER_FACTORY.get();
        while ((n = in.read(buffer)) != -1) {
            digester.update(buffer, 0, n);
        }
        return new MD5Hash(digester.digest());
    }

    public int quarterDigest() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (this.digest[i] & 0xFF) << 8 * (3 - i);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MD5Hash)) {
            return false;
        }
        MD5Hash other = (MD5Hash)o;
        return Arrays.equals(this.digest, other.digest);
    }

    public int hashCode() {
        return this.quarterDigest();
    }

    @Override
    public int compareTo(MD5Hash that) {
        return WritableComparator.compareBytes(this.digest, 0, 16, that.digest, 0, 16);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            byte b = this.digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    static {
        WritableComparator.define(MD5Hash.class, new Comparator());
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(MD5Hash.class);
        }
    }
}

