/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class SerializationFactory
extends Configured {
    private static final Log LOG = LogFactory.getLog(SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getStrings("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization")) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializionClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization)ReflectionUtils.newInstance(serializionClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Serilization class not found: " + StringUtils.stringifyException(e));
        }
    }
}

