/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.ConnectionHeader;
import org.apache.hadoop.ipc.Status;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Server {
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    public static final Log LOG = LogFactory.getLog(Server.class);
    private static final ThreadLocal<Server> SERVER = new ThreadLocal();
    private static final Map<String, Class<?>> PROTOCOL_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<Call> CurCall = new ThreadLocal();
    private int port;
    private int handlerCount;
    private Class<? extends Writable> paramClass;
    private int maxIdleTime;
    private int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected RpcMetrics rpcMetrics;
    private Configuration conf;
    private int socketSendBufferSize;
    private final boolean tcpNoDelay;
    private volatile boolean running;
    private BlockingQueue<Call> callQueue;
    private List<Connection> connectionList;
    private Listener listener;
    private Responder responder;
    private int numConnections;
    private Handler[] handlers;
    private static int NIO_BUFFER_LIMIT = 8192;

    static Class<?> getProtocolClass(String protocolName, Configuration conf) throws ClassNotFoundException {
        Class<?> protocol = PROTOCOL_CACHE.get(protocolName);
        if (protocol == null) {
            protocol = conf.getClassByName(protocolName);
            PROTOCOL_CACHE.put(protocolName, protocol);
        }
        return protocol;
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = Server.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        try {
            connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Status status, Writable rv, String errorClass, String error) throws IOException {
        response.reset();
        DataOutputStream out = new DataOutputStream(response);
        out.writeInt(call.id);
        out.writeInt(status.state);
        if (status == Status.SUCCESS) {
            rv.write(out);
        } else {
            WritableUtils.writeString(out, errorClass);
            WritableUtils.writeString(out, error);
        }
        call.setResponse(ByteBuffer.wrap(response.toByteArray()));
    }

    public synchronized void stop() {
        LOG.info("Stopping server on " + this.port);
        this.running = false;
        if (this.handlers != null) {
            for (int i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.rpcMetrics != null) {
            this.rpcMetrics.shutdown();
        }
    }

    public abstract Writable call(Class<?> var1, Writable var2, long var3) throws IOException;

    public void authorize(Subject user, ConnectionHeader connection) throws AuthorizationException {
    }

    private static int channelWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.write(buffer) : Server.channelIO(null, channel, buffer);
    }

    private static int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : Server.channelIO(channel, null, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    private class Handler
    extends Thread {
        final /* synthetic */ Server this$0;

        public void run() {
            LOG.info(this.getName() + ": starting");
            SERVER.set(this.this$0);
            ByteArrayOutputStream buf = new ByteArrayOutputStream(10240);
            while (this.this$0.running) {
                try {
                    final Call call = (Call)this.this$0.callQueue.take();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getName() + ": has #" + call.id + " from " + call.connection);
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    try {
                        value = Subject.doAs(((Call)call).connection.user, new PrivilegedExceptionAction<Writable>(){

                            @Override
                            public Writable run() throws Exception {
                                return Handler.this.this$0.call(((Call)call).connection.protocol, call.param, call.timestamp);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        LOG.info(this.getName() + ", call " + call + ": error: " + e, e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException(e);
                    }
                    catch (Throwable e) {
                        LOG.info(this.getName() + ", call " + call + ": error: " + e, e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException(e);
                    }
                    CurCall.set(null);
                    this.this$0.setupResponse(buf, call, error == null ? Status.SUCCESS : Status.ERROR, value, errorClass, error);
                    this.this$0.responder.doRespond(call);
                }
                catch (InterruptedException e) {
                    if (!this.this$0.running) continue;
                    LOG.info(this.getName() + " caught: " + StringUtils.stringifyException(e));
                }
                catch (Exception e) {
                    LOG.info(this.getName() + " caught: " + StringUtils.stringifyException(e));
                }
            }
            LOG.info(this.getName() + ": exiting");
        }
    }

    private class Connection {
        private boolean versionRead = false;
        private boolean headerRead = false;
        private SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        private LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private int dataLength;
        private Socket socket;
        private String hostAddress;
        private int remotePort;
        ConnectionHeader header = new ConnectionHeader();
        Class<?> protocol;
        Subject user = null;
        private final int AUTHROIZATION_FAILED_CALLID = -1;
        private final Call authFailedCall = new Call(-1, null, null);
        private ByteArrayOutputStream authFailedResponse = new ByteArrayOutputStream();

        public Connection(SelectionKey key, SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (Server.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(Server.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn("Connection: unable to set socket send buffer size to " + Server.this.socketSendBufferSize);
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        private void decRpcCount() {
            --this.rpcCount;
        }

        private void incRpcCount() {
            ++this.rpcCount;
        }

        private boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)Server.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = Server.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.versionRead) {
                    ByteBuffer versionBuffer = ByteBuffer.allocate(1);
                    count = Server.channelRead(this.channel, versionBuffer);
                    if (count <= 0) {
                        return count;
                    }
                    byte version = versionBuffer.get(0);
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 3) {
                        LOG.warn("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 3);
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    this.versionRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.incRpcCount();
                }
                count = Server.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.headerRead) {
                    this.processData();
                    this.data = null;
                    return count;
                }
                this.processHeader();
                this.headerRead = true;
                this.data = null;
                try {
                    Server.this.authorize(this.user, this.header);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Successfully authorized " + this.header);
                }
                catch (AuthorizationException ae) {
                    this.authFailedCall.connection = this;
                    Server.this.setupResponse(this.authFailedResponse, this.authFailedCall, Status.FATAL, null, ae.getClass().getName(), ae.getMessage());
                    Server.this.responder.doRespond(this.authFailedCall);
                    return -1;
                }
            }
            return count;
        }

        private void processHeader() throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            this.header.readFields(in);
            try {
                String protocolClassName = this.header.getProtocol();
                if (protocolClassName != null) {
                    this.protocol = Server.getProtocolClass(this.header.getProtocol(), Server.this.conf);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unknown protocol: " + this.header.getProtocol());
            }
            this.user = SecurityUtil.getSubject(this.header.getUgi());
        }

        private void processData() throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug(" got #" + id);
            }
            Writable param = (Writable)ReflectionUtils.newInstance(Server.this.paramClass, Server.this.conf);
            param.readFields(dis);
            Call call = new Call(id, param, this);
            Server.this.callQueue.put(call);
        }

        private synchronized void close() throws IOException {
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Responder
    extends Thread {
        private Selector writeSelector;
        private int pending;
        final /* synthetic */ Server this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info(this.getName() + ": starting");
            SERVER.set(this.this$0);
            long lastPurgeTime = 0L;
            while (this.this$0.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(900000L);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info(this.getName() + ": doAsyncWrite threw exception " + e);
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + 900000L) continue;
                    lastPurgeTime = now;
                    LOG.debug("Checking for old call responses.");
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        try {
                            this.doPurge(call, now);
                        }
                        catch (IOException e) {
                            LOG.warn("Error in purging old calls " + e);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn("Out of Memory in server select", e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ie) {}
                }
                catch (Exception e) {
                    LOG.warn("Exception in Responder " + StringUtils.stringifyException(e));
                }
            }
            LOG.info("Stopping " + this.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn("Exception while changing ops : " + e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) throws IOException {
            LinkedList responseQueue;
            LinkedList linkedList = responseQueue = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator iter = responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    call = (Call)iter.next();
                    if (now <= call.timestamp + 900000L) continue;
                    this.this$0.closeConnection(call.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numBytes;
            Call call;
            int numElements;
            boolean done;
            boolean error;
            block21: {
                error = true;
                done = false;
                numElements = 0;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block21;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn(this.getName() + ", call " + call + ": output error");
                done = true;
                this.this$0.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getName() + ": responding to #" + call.id + " from " + call.connection);
            }
            if ((numBytes = Server.channelWrite(channel, call.response)) < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn(this.getName() + ", call " + call + ": output error");
                done = true;
                this.this$0.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    call.connection.decRpcCount();
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote " + numBytes + " bytes.");
                    }
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        this.incPending();
                        try {
                            this.writeSelector.wakeup();
                            channel.register(this.writeSelector, 4, call);
                        }
                        catch (ClosedChannelException e) {
                            done = true;
                        }
                        finally {
                            this.decPending();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote partial " + numBytes + " bytes.");
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn(this.getName() + ", call " + call + ": output error");
                    done = true;
                    this.this$0.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    this.processResponse(call.connection.responseQueue, true);
                }
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel;
        private Selector selector;
        private Random rand;
        private long lastCleanupRunTime;
        private long cleanupInterval;
        final /* synthetic */ Server this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || this.this$0.numConnections > this.this$0.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = this.this$0.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % this.this$0.numConnections;
                    end = this.rand.nextInt() % this.this$0.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List list = this.this$0.connectionList;
                    synchronized (list) {
                        try {
                            c = (Connection)this.this$0.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getName() + ": disconnecting client " + c.getHostAddress());
                        }
                        this.this$0.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != this.this$0.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info(this.getName() + ": starting");
            SERVER.set(this.this$0);
            while (this.this$0.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid()) {
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                } else if (key.isReadable()) {
                                    this.doRead(key);
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn("Out of Memory in server select", e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
                catch (InterruptedException e) {
                    if (this.this$0.running) {
                        LOG.info(this.getName() + " caught: " + StringUtils.stringifyException(e));
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info("Stopping " + this.getName());
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!this.this$0.connectionList.isEmpty()) {
                    this.this$0.closeConnection((Connection)this.this$0.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + ": disconnecting client " + c.getHostAddress());
                }
                this.this$0.closeConnection(c);
                Object var3_3 = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            for (int i = 0; i < 10; ++i) {
                SocketChannel channel = server.accept();
                if (channel == null) {
                    return;
                }
                channel.configureBlocking(false);
                channel.socket().setTcpNoDelay(this.this$0.tcpNoDelay);
                SelectionKey readKey = channel.register(this.selector, 1);
                c = this.this$0.new Connection(readKey, channel, System.currentTimeMillis());
                readKey.attach(c);
                List list = this.this$0.connectionList;
                synchronized (list) {
                    this.this$0.connectionList.add(this.this$0.numConnections, c);
                    this.this$0.numConnections++;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Server connection from " + c.toString() + "; # active connections: " + this.this$0.numConnections + "; # queued calls: " + this.this$0.callQueue.size());
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                LOG.info(this.getName() + ": readAndProcess caught InterruptedException", ieo);
                throw ieo;
            }
            catch (Exception e) {
                LOG.info(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count, e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + ": disconnecting client " + c.getHostAddress() + ". Number of active connections: " + this.this$0.numConnections);
                }
                this.this$0.closeConnection(c);
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info(this.getName() + ":Exception in closing listener socket. " + e);
                }
            }
        }
    }

    private static class Call {
        private int id;
        private Writable param;
        private Connection connection;
        private long timestamp;
        private ByteBuffer response;

        public Call(int id, Writable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        public void setResponse(ByteBuffer response) {
            this.response = response;
        }
    }
}

