/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.util.MetricsBase;

public class MetricsTimeVaryingRate
extends MetricsBase {
    private static final Log LOG = LogFactory.getLog("org.apache.hadoop.metrics.util");
    private Metrics currentData;
    private Metrics previousIntervalData;
    private MinMax minMax;

    public synchronized void inc(long time) {
        ++this.currentData.numOperations;
        this.currentData.time += time;
        this.minMax.update(time);
    }

    public synchronized int getPreviousIntervalNumOps() {
        return this.previousIntervalData.numOperations;
    }

    public synchronized long getPreviousIntervalAverageTime() {
        return this.previousIntervalData.time;
    }

    public synchronized long getMinTime() {
        return this.minMax.minTime;
    }

    public synchronized long getMaxTime() {
        return this.minMax.maxTime;
    }

    public synchronized void resetMinMax() {
        this.minMax.reset();
    }

    static class MinMax {
        long minTime = -1L;
        long maxTime = 0L;

        MinMax() {
        }

        void reset() {
            this.minTime = -1L;
            this.maxTime = 0L;
        }

        void update(long time) {
            this.minTime = this.minTime == -1L ? time : Math.min(this.minTime, time);
            this.minTime = Math.min(this.minTime, time);
            this.maxTime = Math.max(this.maxTime, time);
        }
    }

    static class Metrics {
        int numOperations = 0;
        long time = 0L;

        Metrics() {
        }
    }
}

