/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class DNS {
    public static String[] getIPs(String strInterface) throws UnknownHostException {
        try {
            NetworkInterface netIF = NetworkInterface.getByName(strInterface);
            if (netIF == null) {
                return new String[]{InetAddress.getLocalHost().getHostAddress()};
            }
            Vector<String> ips = new Vector<String>();
            Enumeration<InetAddress> e = netIF.getInetAddresses();
            while (e.hasMoreElements()) {
                ips.add(e.nextElement().getHostAddress());
            }
            return ips.toArray(new String[0]);
        }
        catch (SocketException e) {
            return new String[]{InetAddress.getLocalHost().getHostAddress()};
        }
    }

    public static String getDefaultIP(String strInterface) throws UnknownHostException {
        String[] ips = DNS.getIPs(strInterface);
        return ips[0];
    }
}

