/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jets3tProperties
implements Serializable {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$Jets3tProperties == null ? (class$org$jets3t$service$Jets3tProperties = Jets3tProperties.class$("org.jets3t.service.Jets3tProperties")) : class$org$jets3t$service$Jets3tProperties);
    private static final Hashtable propertiesHashtable = new Hashtable();
    private Properties properties = new Properties();
    private boolean loaded = false;
    static /* synthetic */ Class class$org$jets3t$service$Jets3tProperties;

    public static Jets3tProperties getInstance(String propertiesFileName) {
        Jets3tProperties jets3tProperties;
        block5: {
            jets3tProperties = null;
            if (propertiesHashtable.containsKey(propertiesFileName)) {
                jets3tProperties = (Jets3tProperties)propertiesHashtable.get(propertiesFileName);
                return jets3tProperties;
            }
            jets3tProperties = new Jets3tProperties();
            propertiesHashtable.put(propertiesFileName, jets3tProperties);
            InputStream cpIS = jets3tProperties.getClass().getResourceAsStream(new StringBuffer().append("/").append(propertiesFileName).toString());
            if (cpIS != null) {
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Loading properties from resource in the classpath: ").append(propertiesFileName).toString());
                }
                try {
                    jets3tProperties.loadAndReplaceProperties(cpIS, new StringBuffer().append("Resource '").append(propertiesFileName).append("' in classpath").toString());
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error(new StringBuffer().append("Failed to load properties from resource in classpath: ").append(propertiesFileName).toString(), e);
                }
            }
        }
        return jets3tProperties;
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            this.clearProperty(propertyName);
        } else {
            this.properties.put(propertyName, Jets3tProperties.trim(propertyValue));
        }
    }

    public void clearProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void loadAndReplaceProperties(InputStream inputStream, String propertiesSource) throws IOException {
        Properties newProperties = new Properties();
        newProperties.load(inputStream);
        this.loadAndReplaceProperties(newProperties, propertiesSource);
    }

    public void loadAndReplaceProperties(Properties newProperties, String propertiesSource) {
        for (Map.Entry<Object, Object> entry : newProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (this.properties.containsKey(propertyName) && !this.properties.getProperty(propertyName).equals(propertyValue) && log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Over-riding jets3t property [").append(propertyName).append("=").append(propertyValue).append("] with value from properties source ").append(propertiesSource).append(". New value: [").append(propertyName).append("=").append(Jets3tProperties.trim(propertyValue)).append("]").toString());
            }
            this.properties.put(propertyName, Jets3tProperties.trim(propertyValue));
        }
        this.loaded = true;
    }

    public String getStringProperty(String propertyName, String defaultValue) {
        String stringValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, defaultValue));
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append(propertyName).append("=").append(stringValue).toString());
        }
        return stringValue;
    }

    public long getLongProperty(String propertyName, long defaultValue) throws NumberFormatException {
        String longValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append(propertyName).append("=").append(longValue).toString());
        }
        return Long.parseLong(longValue);
    }

    public int getIntProperty(String propertyName, int defaultValue) throws NumberFormatException {
        String intValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append(propertyName).append("=").append(intValue).toString());
        }
        return Integer.parseInt(intValue);
    }

    public boolean getBoolProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String boolValue = Jets3tProperties.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append(propertyName).append("=").append(boolValue).toString());
        }
        if ("true".equalsIgnoreCase(boolValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(boolValue)) {
            return false;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Boolean value '").append(boolValue).append("' for jets3t property '").append(propertyName).append("' must be 'true' or 'false' (case-insensitive)").toString());
    }

    public boolean containsKey(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    private static String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

