/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;

public abstract class S3Service
implements Serializable {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$S3Service == null ? (class$org$jets3t$service$S3Service = S3Service.class$("org.jets3t.service.S3Service")) : class$org$jets3t$service$S3Service);
    protected Jets3tProperties jets3tProperties = null;
    private AWSCredentials awsCredentials = null;
    private String awsDevPayUserToken = null;
    private String awsDevPayProductToken = null;
    private boolean isRequesterPaysEnabled = false;
    private String invokingApplicationDescription = null;
    private boolean isHttpsOnly = true;
    private int internalErrorRetryMax = 5;
    private boolean isShutdown = false;
    protected long timeOffset = 0L;
    static /* synthetic */ Class class$org$jets3t$service$S3Service;

    protected S3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this.awsCredentials = awsCredentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.jets3tProperties = jets3tProperties;
        this.isHttpsOnly = jets3tProperties.getBoolProperty("s3service.https-only", true);
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("s3service.internal-error-retry-max", 5);
        if (awsCredentials instanceof AWSDevPayCredentials) {
            AWSDevPayCredentials awsDevPayCredentials = (AWSDevPayCredentials)awsCredentials;
            this.awsDevPayUserToken = awsDevPayCredentials.getUserToken();
            this.awsDevPayProductToken = awsDevPayCredentials.getProductToken();
        } else {
            this.awsDevPayUserToken = jets3tProperties.getStringProperty("devpay.user-token", null);
            this.awsDevPayProductToken = jets3tProperties.getStringProperty("devpay.product-token", null);
        }
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        String customS3Hostname = this.jets3tProperties.getStringProperty("s3service.s3-endpoint", Constants.S3_HOSTNAME);
        if (!Constants.S3_HOSTNAME.equals(customS3Hostname)) {
            Constants.S3_HOSTNAME = customS3Hostname;
        }
        MxDelegate.getInstance().init();
        MxDelegate.getInstance().registerS3ServiceMBean();
        MxDelegate.getInstance().registerS3ServiceExceptionMBean();
    }

    protected S3Service(AWSCredentials awsCredentials, String invokingApplicationDescription) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected S3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, null);
    }

    public String getDevPayUserToken() {
        return this.awsDevPayUserToken;
    }

    public String getDevPayProductToken() {
        return this.awsDevPayProductToken;
    }

    public void setRequesterPaysEnabled(boolean isRequesterPays) {
        this.isRequesterPaysEnabled = isRequesterPays;
    }

    public boolean isRequesterPaysEnabled() {
        return this.isRequesterPaysEnabled;
    }

    public boolean isAuthenticatedConnection() {
        return this.awsCredentials != null;
    }

    public boolean isHttpsOnly() {
        return this.isHttpsOnly;
    }

    public static boolean isBucketNameValidDNSName(String bucketName) {
        if (bucketName == null || bucketName.length() > 63 || bucketName.length() < 3) {
            return false;
        }
        if (!Pattern.matches("^[a-z0-9][a-z0-9.-]+$", bucketName)) {
            return false;
        }
        if (Pattern.matches("([0-9]{1,3}\\.){3}[0-9]{1,3}", bucketName)) {
            return false;
        }
        String[] fragments = bucketName.split("\\.");
        for (int i = 0; i < fragments.length; ++i) {
            if (!Pattern.matches("^-.*", fragments[i]) && !Pattern.matches(".*-$", fragments[i]) && !Pattern.matches("^$", fragments[i])) continue;
            return false;
        }
        return true;
    }

    public static String generateS3HostnameForBucket(String bucketName, boolean isDnsBucketNamingDisabled) {
        if (S3Service.isBucketNameValidDNSName(bucketName) && !isDnsBucketNamingDisabled) {
            return new StringBuffer().append(bucketName).append(".").append(Constants.S3_HOSTNAME).toString();
        }
        return Constants.S3_HOSTNAME;
    }

    protected void sleepOnInternalError(int internalErrorCount) throws S3ServiceException, InterruptedException {
        long delayMs;
        if (internalErrorCount <= this.internalErrorRetryMax) {
            delayMs = 50L * (long)((int)Math.pow(internalErrorCount, 2.0));
            if (log.isWarnEnabled()) {
                log.warn(new StringBuffer().append("Encountered ").append(internalErrorCount).append(" S3 Internal Server error(s), will retry in ").append(delayMs).append("ms").toString());
            }
        } else {
            throw new S3ServiceException(new StringBuffer().append("Encountered too many S3 Internal Server errors (").append(internalErrorCount).append("), aborting request.").toString());
        }
        Thread.sleep(delayMs);
    }

    public AWSCredentials getAWSCredentials() {
        return this.awsCredentials;
    }

    public String getInvokingApplicationDescription() {
        return this.invokingApplicationDescription;
    }

    protected void assertAuthenticatedConnection(String action) throws S3ServiceException {
        if (!this.isAuthenticatedConnection()) {
            throw new S3ServiceException(new StringBuffer().append("The requested action cannot be performed with a non-authenticated S3 Service: ").append(action).toString());
        }
    }

    protected void assertValidBucket(S3Bucket bucket, String action) throws S3ServiceException {
        if (bucket == null || bucket.getName() == null || bucket.getName().length() == 0) {
            throw new S3ServiceException(new StringBuffer().append("The action ").append(action).append(" cannot be performed with an invalid bucket: ").append(bucket).toString());
        }
    }

    protected void assertValidObject(S3Object object, String action) throws S3ServiceException {
        if (object == null || object.getKey() == null || object.getKey().length() == 0) {
            throw new S3ServiceException(new StringBuffer().append("The action ").append(action).append(" cannot be performed with an invalid object: ").append(object).toString());
        }
    }

    protected void assertValidObject(String key, String action) throws S3ServiceException {
        if (key == null || key.length() == 0) {
            throw new S3ServiceException(new StringBuffer().append("The action ").append(action).append(" cannot be performed with an invalid object key name: ").append(key).toString());
        }
    }

    public S3Bucket createBucket(String bucketName, String location) throws S3ServiceException {
        this.assertAuthenticatedConnection("createBucket");
        S3Bucket bucket = new S3Bucket(bucketName, location);
        return this.createBucket(bucket);
    }

    public S3Bucket createBucket(String bucketName) throws S3ServiceException {
        String defaultBucketLocation = this.jets3tProperties.getStringProperty("s3service.default-bucket-location", S3Bucket.LOCATION_US);
        return this.createBucket(bucketName, defaultBucketLocation);
    }

    public S3Bucket[] listAllBuckets() throws S3ServiceException {
        this.assertAuthenticatedConnection("List all buckets");
        S3Bucket[] buckets = this.listAllBucketsImpl();
        MxDelegate.getInstance().registerS3BucketMBeans(buckets);
        return buckets;
    }

    public S3ObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws S3ServiceException {
        MxDelegate.getInstance().registerS3BucketListEvent(bucketName);
        S3ObjectsChunk chunk = this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, completeListing);
        MxDelegate.getInstance().registerS3ObjectMBean(bucketName, chunk.getObjects());
        return chunk;
    }

    public S3Bucket createBucket(S3Bucket bucket) throws S3ServiceException {
        this.assertAuthenticatedConnection("Create Bucket");
        this.assertValidBucket(bucket, "Create Bucket");
        return this.createBucketImpl(bucket.getName(), bucket.getLocation(), bucket.getAcl());
    }

    public S3Bucket getBucket(String bucketName) throws S3ServiceException {
        this.assertAuthenticatedConnection("Create Bucket");
        S3Bucket[] existingBuckets = this.listAllBuckets();
        for (int i = 0; i < existingBuckets.length; ++i) {
            if (!existingBuckets[i].getName().equals(bucketName)) continue;
            return existingBuckets[i];
        }
        return null;
    }

    public void deleteBucket(String bucketName) throws S3ServiceException {
        this.deleteBucketImpl(bucketName);
    }

    public S3Object putObject(String bucketName, S3Object object) throws S3ServiceException {
        this.assertValidObject(object, new StringBuffer().append("Create Object in bucket ").append(bucketName).toString());
        MxDelegate.getInstance().registerS3ObjectPutEvent(bucketName, object.getKey());
        return this.putObjectImpl(bucketName, object);
    }

    public Map copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        this.assertAuthenticatedConnection("copyObject");
        Map destinationMetadata = replaceMetadata ? destinationObject.getModifiableMetadata() : null;
        MxDelegate.getInstance().registerS3ObjectCopyEvent(sourceBucketName, sourceObjectKey);
        return this.copyObjectImpl(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject.getKey(), destinationObject.getAcl(), destinationMetadata, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public Map copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, S3Object destinationObject, boolean replaceMetadata) throws S3ServiceException {
        return this.copyObject(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata, null, null, null, null);
    }

    public void deleteObject(String bucketName, String objectKey) throws S3ServiceException {
        this.assertValidObject(objectKey, "deleteObject");
        MxDelegate.getInstance().registerS3ObjectDeleteEvent(bucketName, objectKey);
        this.deleteObjectImpl(bucketName, objectKey);
    }

    public S3Object getObjectDetails(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        MxDelegate.getInstance().registerS3ObjectHeadEvent(bucketName, objectKey);
        return this.getObjectDetailsImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public S3Object getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        MxDelegate.getInstance().registerS3ObjectGetEvent(bucketName, objectKey);
        return this.getObjectImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    public Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    protected abstract S3Bucket[] listAllBucketsImpl() throws S3ServiceException;

    protected abstract S3ObjectsChunk listObjectsChunkedImpl(String var1, String var2, String var3, long var4, String var6, boolean var7) throws S3ServiceException;

    protected abstract S3Bucket createBucketImpl(String var1, String var2, AccessControlList var3) throws S3ServiceException;

    protected abstract void deleteBucketImpl(String var1) throws S3ServiceException;

    protected abstract S3Object putObjectImpl(String var1, S3Object var2) throws S3ServiceException;

    protected abstract Map copyObjectImpl(String var1, String var2, String var3, String var4, AccessControlList var5, Map var6, Calendar var7, Calendar var8, String[] var9, String[] var10) throws S3ServiceException;

    protected abstract void deleteObjectImpl(String var1, String var2) throws S3ServiceException;

    protected abstract S3Object getObjectDetailsImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6) throws S3ServiceException;

    protected abstract S3Object getObjectImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6, Long var7, Long var8) throws S3ServiceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

