/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class InterruptableInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$io$InterruptableInputStream == null ? (class$org$jets3t$service$io$InterruptableInputStream = InterruptableInputStream.class$("org.jets3t.service.io.InterruptableInputStream")) : class$org$jets3t$service$io$InterruptableInputStream);
    private InputStream inputStream = null;
    private boolean interrupted = false;
    static /* synthetic */ Class class$org$jets3t$service$io$InterruptableInputStream;

    public InterruptableInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void maybeInterruptInputStream() throws IOException {
        if (this.interrupted) {
            block4: {
                if (log.isDebugEnabled()) {
                    log.debug(new StringBuffer().append("Input stream interrupted, closing underlying input stream ").append(this.inputStream.getClass()).toString());
                }
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Unable to close underlying InputStream on interrupt");
                }
            }
            throw new UnrecoverableIOException("Reading from input stream deliberately interrupted");
        }
    }

    public int read() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read(b, off, len);
    }

    public int available() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

