/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.UnrecoverableIOException;

public class RepeatableFileInputStream
extends InputStream
implements InputStreamWrapper {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$io$RepeatableFileInputStream == null ? (class$org$jets3t$service$io$RepeatableFileInputStream = RepeatableFileInputStream.class$("org.jets3t.service.io.RepeatableFileInputStream")) : class$org$jets3t$service$io$RepeatableFileInputStream);
    private File file = null;
    private FileInputStream fis = null;
    private long bytesReadPastMarkPoint = 0L;
    private long markPoint = 0L;
    static /* synthetic */ Class class$org$jets3t$service$io$RepeatableFileInputStream;

    public RepeatableFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.fis = new FileInputStream(file);
        this.file = file;
    }

    public void reset() throws IOException {
        try {
            this.fis.close();
            this.fis = new FileInputStream(this.file);
            long skipped = 0L;
            for (long toSkip = this.markPoint; toSkip > 0L; toSkip -= skipped) {
                skipped = this.fis.skip(toSkip);
            }
            if (log.isDebugEnabled()) {
                log.debug(new StringBuffer().append("Reset to mark point ").append(this.markPoint).append(" after returning ").append(this.bytesReadPastMarkPoint).append(" bytes").toString());
            }
            this.bytesReadPastMarkPoint = 0L;
        }
        catch (IOException e) {
            throw new UnrecoverableIOException(new StringBuffer().append("Input stream is not repeatable: ").append(e.getMessage()).toString());
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug(new StringBuffer().append("Input stream marked at ").append(this.markPoint).append(" bytes").toString());
        }
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int read() throws IOException {
        int byteRead = this.fis.read();
        if (byteRead != -1) {
            ++this.bytesReadPastMarkPoint;
            return byteRead;
        }
        return -1;
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int count = this.fis.read(arg0, arg1, arg2);
        this.bytesReadPastMarkPoint += (long)count;
        return count;
    }

    public InputStream getWrappedInputStream() {
        return this.fis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

