/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.utils.RestUtils;

public class ServiceUtils {
    private static final Log log = LogFactory.getLog(class$org$jets3t$service$utils$ServiceUtils == null ? (class$org$jets3t$service$utils$ServiceUtils = ServiceUtils.class$("org.jets3t.service.utils.ServiceUtils")) : class$org$jets3t$service$utils$ServiceUtils);
    protected static final SimpleDateFormat iso8601DateParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected static final SimpleDateFormat iso8601DateParser_Walrus = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static final SimpleDateFormat rfc822DateParser = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    static /* synthetic */ Class class$org$jets3t$service$utils$ServiceUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseIso8601Date(String dateString) throws ParseException {
        ParseException exception = null;
        SimpleDateFormat simpleDateFormat = iso8601DateParser;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser.parse(dateString);
            }
            catch (ParseException e) {
                exception = e;
            }
        }
        simpleDateFormat = iso8601DateParser_Walrus;
        synchronized (simpleDateFormat) {
            try {
                return iso8601DateParser_Walrus.parse(dateString);
            }
            catch (ParseException parseException) {
            }
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseRfc822Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = rfc822DateParser;
        synchronized (simpleDateFormat) {
            return rfc822DateParser.format(date);
        }
    }

    public static String signWithHmacSha1(String awsSecretKey, String canonicalString) throws S3ServiceException {
        if (awsSecretKey == null) {
            if (log.isDebugEnabled()) {
                log.debug("Canonical string will not be signed, as no AWS Secret Key was provided");
            }
            return null;
        }
        SecretKeySpec signingKey = null;
        try {
            signingKey = new SecretKeySpec(awsSecretKey.getBytes(Constants.DEFAULT_ENCODING), "HmacSHA1");
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to get bytes from secret string", e);
        }
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        try {
            byte[] b64 = Base64.encodeBase64(mac.doFinal(canonicalString.getBytes(Constants.DEFAULT_ENCODING)));
            return new String(b64);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to get bytes from canonical string", e);
        }
    }

    public static Map cleanRestMetadataMap(Map metadata) {
        if (log.isDebugEnabled()) {
            log.debug("Cleaning up REST metadata items");
        }
        HashMap cleanMap = new HashMap();
        if (metadata != null) {
            for (Map.Entry entry : metadata.entrySet()) {
                Object value;
                Object key;
                block26: {
                    String keyStr;
                    key = entry.getKey();
                    value = entry.getValue();
                    String string = keyStr = key != null ? key.toString() : "";
                    if (keyStr.startsWith("x-amz-meta-")) {
                        key = keyStr.substring("x-amz-meta-".length(), keyStr.length());
                        if (log.isDebugEnabled()) {
                            log.debug(new StringBuffer().append("Removed Amazon meatadata header prefix from key: ").append(keyStr).append("=>").append(key).toString());
                        }
                    } else if (keyStr.startsWith("x-amz-")) {
                        key = keyStr.substring("x-amz-".length(), keyStr.length());
                        if (log.isDebugEnabled()) {
                            log.debug(new StringBuffer().append("Removed Amazon header prefix from key: ").append(keyStr).append("=>").append(key).toString());
                        }
                    } else if (RestUtils.HTTP_HEADER_METADATA_NAMES.contains(keyStr.toLowerCase(Locale.getDefault()))) {
                        key = keyStr;
                        if (log.isDebugEnabled()) {
                            log.debug(new StringBuffer().append("Leaving HTTP header item unchanged: ").append(key).append("=").append(value).toString());
                        }
                    } else if ("ETag".equalsIgnoreCase(keyStr) || "Date".equalsIgnoreCase(keyStr) || "Last-Modified".equalsIgnoreCase(keyStr) || "Content-Range".equalsIgnoreCase(keyStr)) {
                        key = keyStr;
                        if (log.isDebugEnabled()) {
                            log.debug(new StringBuffer().append("Leaving header item unchanged: ").append(key).append("=").append(value).toString());
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug(new StringBuffer().append("Ignoring metadata item: ").append(keyStr).append("=").append(value).toString());
                        continue;
                    }
                    if (value instanceof Collection) {
                        if (((Collection)value).size() == 1) {
                            if (log.isDebugEnabled()) {
                                log.debug(new StringBuffer().append("Converted metadata single-item Collection ").append(value.getClass()).append(" ").append(value).append(" for key: ").append(key).toString());
                            }
                            value = ((Collection)value).iterator().next();
                        } else if (log.isWarnEnabled()) {
                            log.warn(new StringBuffer().append("Collection ").append(value).append(" has too many items to convert to a single string").toString());
                        }
                    }
                    if (("Date".equals(key) || "Last-Modified".equals(key)) && !(value instanceof Date)) {
                        if (log.isDebugEnabled()) {
                            log.debug(new StringBuffer().append("Parsing date string '").append(value).append("' into Date object for key: ").append(key).toString());
                        }
                        try {
                            value = ServiceUtils.parseRfc822Date(value.toString());
                        }
                        catch (ParseException pe) {
                            try {
                                value = ServiceUtils.parseIso8601Date(value.toString());
                            }
                            catch (ParseException pe2) {
                                if (!log.isWarnEnabled()) break block26;
                                log.warn(new StringBuffer().append("Date string is not RFC 822 compliant for metadata field ").append(key).toString(), pe);
                            }
                        }
                    }
                }
                cleanMap.put(key, value);
            }
        }
        return cleanMap;
    }

    public static String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase(Locale.getDefault());
    }

    public static String toBase64(byte[] data) {
        byte[] b64 = Base64.encodeBase64(data);
        return new String(b64);
    }

    public static String join(Object[] items, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String join(int[] ints, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ints.length; ++i) {
            sb.append(ints[i]);
            if (i >= ints.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String getUserAgentDescription(String applicationDescription) {
        return new StringBuffer().append("JetS3t/0.7.1 (").append(System.getProperty("os.name")).append("/").append(System.getProperty("os.version")).append(";").append(" ").append(System.getProperty("os.arch")).append(System.getProperty("user.region") != null ? new StringBuffer().append("; ").append(System.getProperty("user.region")).toString() : "").append(System.getProperty("user.language") != null ? new StringBuffer().append("; ").append(System.getProperty("user.language")).toString() : "").append(System.getProperty("java.version") != null ? new StringBuffer().append("; JVM ").append(System.getProperty("java.version")).toString() : "").append(")").append(applicationDescription != null ? new StringBuffer().append(" ").append(applicationDescription).toString() : "").toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        iso8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
        rfc822DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

