/*****************************************************************************
 * pce                                                                       *
 *****************************************************************************/

/*****************************************************************************
 * File name:   src/cpu/e8080/dis_z80.c                                      *
 * Created:     2012-12-07 by Hampa Hug <hampa@hampa.ch>                     *
 * Copyright:   (C) 2012-2020 Hampa Hug <hampa@hampa.ch>                     *
 *****************************************************************************/

/*****************************************************************************
 * This program is free software. You can redistribute it and / or modify it *
 * under the terms of the GNU General Public License version 2 as  published *
 * by the Free Software Foundation.                                          *
 *                                                                           *
 * This program is distributed in the hope  that  it  will  be  useful,  but *
 * WITHOUT  ANY   WARRANTY,   without   even   the   implied   warranty   of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  General *
 * Public License for more details.                                          *
 *****************************************************************************/


#include "e8080.h"
#include "internal.h"

#include <string.h>


static e8080_dop_t e8080_opcodes[256] = {
	{ 0x00, "NOP",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x01, "LD",   "BC",   NULL,   ARG_STR,  ARG_IM16, 3, 10, 0 },
	{ 0x02, "LD",   "(BC)", "A",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x03, "INC",  "BC",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x04, "INC",  "B",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x05, "DEC",  "B",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x06, "LD",   "B",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x07, "RLCA",  NULL,  NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x08, "EX",   "AF",   "AF'",  ARG_STR,  ARG_STR,  1,  4, E8080_OPF_Z80 },
	{ 0x09, "ADD",  "HL",   "BC",   ARG_STR,  ARG_STR,  1, 11, 0 },
	{ 0x0a, "LD",   "A",    "(BC)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x0b, "DEC",  "BC",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x0c, "INC",  "C",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x0d, "DEC",  "C",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x0e, "LD",   "C",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x0f, "RRCA", NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x10, "DJNZ", NULL,   NULL,   ARG_JMP8, ARG_NONE, 2, 13, E8080_OPF_Z80 | E8080_OPF_JMP | E8080_OPF_COND },
	{ 0x11, "LD",   "DE",   NULL,   ARG_STR,  ARG_IM16, 3, 10, 0 },
	{ 0x12, "LD",   "(DE)", "A",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x13, "INC",  "DE",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x14, "INC",  "D",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x15, "DEC",  "D",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x16, "LD",   "D",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x17, "RLA",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x18, "JR",   NULL,   NULL,   ARG_JMP8, ARG_NONE, 2, 12, E8080_OPF_Z80 | E8080_OPF_JMP },
	{ 0x19, "ADD",  "HL",   "DE",   ARG_STR,  ARG_STR,  1, 11, 0 },
	{ 0x1a, "LD",   "A",    "(DE)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x1b, "DEC",  "DE",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x1c, "INC",  "E",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x1d, "DEC",  "E",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x1e, "LD",   "E",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x1f, "RRA",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x20, "JR",   "NZ",   NULL,   ARG_STR,  ARG_JMP8, 2, 12, E8080_OPF_Z80 | E8080_OPF_JMP | E8080_OPF_COND },
	{ 0x21, "LD",   "HL",   NULL,   ARG_STR,  ARG_IM16, 3, 10, 0 },
	{ 0x22, "LD",   NULL,   "HL",   ARG_AD16, ARG_STR,  3, 16, 0 },
	{ 0x23, "INC",  "HL",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x24, "INC",  "H",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x25, "DEC",  "H",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x26, "LD",   "H",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x27, "DAA",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x28, "JR",   "Z",    NULL,   ARG_STR,  ARG_JMP8, 2, 12, E8080_OPF_Z80 | E8080_OPF_JMP | E8080_OPF_COND },
	{ 0x29, "ADD",  "HL",   "HL",   ARG_STR,  ARG_STR,  1, 11, 0 },
	{ 0x2a, "LD",   "HL",   NULL,   ARG_STR,  ARG_AD16, 3, 16, 0 },
	{ 0x2b, "DEC",  "HL",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x2c, "INC",  "L",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x2d, "DEC",  "L",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x2e, "LD",   "L",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x2f, "CPL",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x30, "JR",   "NC",   NULL,   ARG_STR,  ARG_JMP8, 2, 12, E8080_OPF_Z80 | E8080_OPF_JMP | E8080_OPF_COND },
	{ 0x31, "LD",   "SP",   NULL,   ARG_STR,  ARG_IM16, 3, 10, 0 },
	{ 0x32, "LD",   NULL,   "A",    ARG_AD16, ARG_STR,  3, 13, 0 },
	{ 0x33, "INC",  "SP",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x34, "INC",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0x35, "DEC",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0x36, "LD",   "(HL)", NULL,   ARG_STR,  ARG_IMM8, 2, 10, 0 },
	{ 0x37, "SCF",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x38, "JR",   "C",    NULL,   ARG_STR,  ARG_JMP8, 2, 12, E8080_OPF_Z80 | E8080_OPF_JMP | E8080_OPF_COND },
	{ 0x39, "ADD",  "HL",   "SP",   ARG_STR,  ARG_STR,  1, 11, 0 },
	{ 0x3a, "LD",   "A",    NULL,   ARG_STR,  ARG_AD16, 3, 13, 0 },
	{ 0x3b, "DEC",  "SP",   NULL,   ARG_STR,  ARG_NONE, 1,  6, 0 },
	{ 0x3c, "INC",  "A",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x3d, "DEC",  "A",    NULL,   ARG_STR,  ARG_NONE, 1,  4, 0 },
	{ 0x3e, "LD",   "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0x3f, "CCF",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0x40, "LD",   "B",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x41, "LD",   "B",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x42, "LD",   "B",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x43, "LD",   "B",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x44, "LD",   "B",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x45, "LD",   "B",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x46, "LD",   "B",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x47, "LD",   "B",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x48, "LD",   "C",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x49, "LD",   "C",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x4a, "LD",   "C",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x4b, "LD",   "C",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x4c, "LD",   "C",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x4d, "LD",   "C",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x4e, "LD",   "C",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x4f, "LD",   "C",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x50, "LD",   "D",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x51, "LD",   "D",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x52, "LD",   "D",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x53, "LD",   "D",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x54, "LD",   "D",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x55, "LD",   "D",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x56, "LD",   "D",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x57, "LD",   "D",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x58, "LD",   "E",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x59, "LD",   "E",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x5a, "LD",   "E",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x5b, "LD",   "E",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x5c, "LD",   "E",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x5d, "LD",   "E",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x5e, "LD",   "E",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x5f, "LD",   "E",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x60, "LD",   "H",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x61, "LD",   "H",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x62, "LD",   "H",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x63, "LD",   "H",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x64, "LD",   "H",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x65, "LD",   "H",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x66, "LD",   "H",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x67, "LD",   "H",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x68, "LD",   "L",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x69, "LD",   "L",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x6a, "LD",   "L",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x6b, "LD",   "L",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x6c, "LD",   "L",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x6d, "LD",   "L",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x6e, "LD",   "L",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x6f, "LD",   "L",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x70, "LD",   "(HL)", "B",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x71, "LD",   "(HL)", "C",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x72, "LD",   "(HL)", "D",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x73, "LD",   "(HL)", "E",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x74, "LD",   "(HL)", "H",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x75, "LD",   "(HL)", "L",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x76, "HLT",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  7, 0 },
	{ 0x77, "LD",   "(HL)", "A",    ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x78, "LD",   "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x79, "LD",   "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x7a, "LD",   "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x7b, "LD",   "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x7c, "LD",   "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x7d, "LD",   "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x7e, "LD",   "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x7f, "LD",   "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x80, "ADD",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x81, "ADD",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x82, "ADD",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x83, "ADD",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x84, "ADD",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x85, "ADD",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x86, "ADD",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x87, "ADD",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x88, "ADC",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x89, "ADC",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x8a, "ADC",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x8b, "ADC",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x8c, "ADC",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x8d, "ADC",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x8e, "ADC",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x8f, "ADC",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x90, "SUB",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x91, "SUB",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x92, "SUB",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x93, "SUB",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x94, "SUB",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x95, "SUB",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x96, "SUB",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x97, "SUB",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x98, "SBC",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x99, "SBC",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x9a, "SBC",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x9b, "SBC",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x9c, "SBC",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x9d, "SBC",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0x9e, "SBC",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0x9f, "SBC",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa0, "AND",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa1, "AND",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa2, "AND",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa3, "AND",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa4, "AND",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa5, "AND",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa6, "AND",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0xa7, "AND",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa8, "XOR",  "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xa9, "XOR",  "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xaa, "XOR",  "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xab, "XOR",  "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xac, "XOR",  "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xad, "XOR",  "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xae, "XOR",  "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0xaf, "XOR",  "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb0, "OR",   "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb1, "OR",   "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb2, "OR",   "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb3, "OR",   "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb4, "OR",   "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb5, "OR",   "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb6, "OR",   "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0xb7, "OR",   "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb8, "CP",   "A",    "B",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xb9, "CP",   "A",    "C",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xba, "CP",   "A",    "D",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xbb, "CP",   "A",    "E",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xbc, "CP",   "A",    "H",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xbd, "CP",   "A",    "L",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xbe, "CP",   "A",    "(HL)", ARG_STR,  ARG_STR,  1,  7, 0 },
	{ 0xbf, "CP",   "A",    "A",    ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xc0, "RET",  "NZ",   NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xc1, "POP",  "BC",   NULL,   ARG_STR,  ARG_NONE, 1, 10, 0 },
	{ 0xc2, "JMP",  "NZ",   NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xc3, "JMP",  NULL,   NULL,   ARG_JP16, ARG_NONE, 3, 10, E8080_OPF_JMP },
	{ 0xc4, "CALL", "NZ",   NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xc5, "PUSH", "BC",   NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0xc6, "ADD",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xc7, "RST",  "0",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xc8, "RET",  "Z",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xc9, "RET",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1, 10, E8080_OPF_RET },
	{ 0xca, "JMP",  "Z",    NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "CALL", "Z",    NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xcd, "CALL", NULL,   NULL,   ARG_JP16, ARG_NONE, 3, 17, E8080_OPF_CALL },
	{ 0xce, "ADC",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xcf, "RST",  "1",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xd0, "RET",  "NC",   NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xd1, "POP",  "DE",   NULL,   ARG_STR,  ARG_NONE, 1, 10, 0 },
	{ 0xd2, "JMP",  "NC",   NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xd3, "OUT",  NULL,   NULL,   ARG_IMM8, ARG_NONE, 2, 10, 0 },
	{ 0xd4, "CALL", "NC",   NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xd5, "PUSH", "DE",   NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0xd6, "SUB",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xd7, "RST",  "2",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xd8, "RET",  "C",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xd9, "EXX",  NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, E8080_OPF_Z80 },
	{ 0xda, "JMP",  "C",    NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xdb, "IN",   NULL,   NULL,   ARG_IMM8, ARG_NONE, 2, 10, 0 },
	{ 0xdc, "CALL", "C",    NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "SBC",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xdf, "RST",  "3",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xe0, "RET",  "PO",   NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xe1, "POP",  "HL",   NULL,   ARG_STR,  ARG_NONE, 1, 10, 0 },
	{ 0xe2, "JMP",  "PO",   NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xe3, "EX",   "(SP)", "HL",   ARG_STR,  ARG_STR,  1, 19, 0 },
	{ 0xe4, "CALL", "PO",   NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xe5, "PUSH", "HL",   NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0xe6, "AND",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xe7, "RST",  "4",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xe8, "RET",  "PE",   NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xe9, "JMP",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 1,  4, E8080_OPF_JMP },
	{ 0xea, "JMP",  "PE",   NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xeb, "EX",   "DE",   "HL",   ARG_STR,  ARG_STR,  1,  4, 0 },
	{ 0xec, "CALL", "PE",   NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "XOR",  "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xef, "RST",  "5",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xf0, "RET",  "P",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xf1, "POP",  "AF",   NULL,   ARG_STR,  ARG_NONE, 1, 10, 0 },
	{ 0xf2, "JMP",  "P",    NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xf3, "DI",   NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0xf4, "CALL", "P",    NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xf5, "PUSH", "AF",   NULL,   ARG_STR,  ARG_NONE, 1, 11, 0 },
	{ 0xf6, "OR",   "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xf7, "RST",  "6",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL },
	{ 0xf8, "RET",  "M",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_RET | E8080_OPF_COND },
	{ 0xf9, "LD",   "SP",   "HL",   ARG_STR,  ARG_STR,  1,  6, 0 },
	{ 0xfa, "JMP",  "M",    NULL,   ARG_STR,  ARG_JP16, 3, 10, E8080_OPF_JMP | E8080_OPF_COND },
	{ 0xfb, "EI",   NULL,   NULL,   ARG_NONE, ARG_NONE, 1,  4, 0 },
	{ 0xfc, "CALL", "M",    NULL,   ARG_STR,  ARG_JP16, 3, 17, E8080_OPF_CALL | E8080_OPF_COND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "CP",   "A",    NULL,   ARG_STR,  ARG_IMM8, 2,  7, 0 },
	{ 0xff, "RST",  "7",    NULL,   ARG_STR,  ARG_NONE, 1, 11, E8080_OPF_CALL }
};

static e8080_dop_t e8080_op_cb[256] = {
	{ 0x00, "RLC",  "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x01, "RLC",  "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x02, "RLC",  "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x03, "RLC",  "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x04, "RLC",  "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x05, "RLC",  "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x06, "RLC",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x07, "RLC",  "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x08, "RRC",  "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x09, "RRC",  "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x0a, "RRC",  "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x0b, "RRC",  "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x0c, "RRC",  "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x0d, "RRC",  "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x0e, "RRC",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x0f, "RRC",  "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x10, "RL",   "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x11, "RL",   "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x12, "RL",   "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x13, "RL",   "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x14, "RL",   "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x15, "RL",   "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x16, "RL",   "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x17, "RL",   "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x18, "RR",   "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x19, "RR",   "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x1a, "RR",   "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x1b, "RR",   "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x1c, "RR",   "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x1d, "RR",   "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x1e, "RR",   "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x1f, "RR",   "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x20, "SLA",  "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x21, "SLA",  "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x22, "SLA",  "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x23, "SLA",  "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x24, "SLA",  "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x25, "SLA",  "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x26, "SLA",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x27, "SLA",  "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x28, "SRA",  "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x29, "SRA",  "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x2a, "SRA",  "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x2b, "SRA",  "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x2c, "SRA",  "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x2d, "SRA",  "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x2e, "SRA",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x2f, "SRA",  "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x35, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x36, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "SRL",  "B",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x39, "SRL",  "C",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x3a, "SRL",  "D",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x3b, "SRL",  "E",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x3c, "SRL",  "H",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x3d, "SRL",  "L",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x3e, "SRL",  "(HL)", NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0x3f, "SRL",  "A",    NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x40, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x41, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x42, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x43, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x44, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x45, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x46, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x47, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x48, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x49, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x4a, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x4b, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x4c, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x4d, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x4e, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x4f, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x50, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x51, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x52, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x53, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x54, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x55, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x56, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x57, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x58, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x59, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x5a, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x5b, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x5c, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x5d, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x5e, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x5f, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x60, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x61, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x62, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x63, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x64, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x65, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x66, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x67, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x68, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x69, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x6a, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x6b, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x6c, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x6d, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x6e, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x6f, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x70, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x71, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x72, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x73, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x74, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x75, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x76, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x77, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x78, "BIT",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x79, "BIT",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x7a, "BIT",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x7b, "BIT",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x7c, "BIT",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x7d, "BIT",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x7e, "BIT",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x7f, "BIT",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x80, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x81, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x82, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x83, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x84, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x85, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x86, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x87, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x88, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x89, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x8a, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x8b, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x8c, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x8d, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x8e, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x8f, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x90, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x91, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x92, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x93, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x94, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x95, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x96, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x97, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x98, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x99, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x9a, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x9b, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x9c, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x9d, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0x9e, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x9f, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa0, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa1, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa2, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa3, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa4, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa5, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa6, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xa7, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa8, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xa9, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xaa, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xab, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xac, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xad, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xae, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xaf, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb0, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb1, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb2, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb3, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb4, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb5, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb6, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xb7, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb8, "RES",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xb9, "RES",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xba, "RES",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xbb, "RES",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xbc, "RES",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xbd, "RES",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xbe, "RES",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xbf, "RES",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc0, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc1, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc2, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc3, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc4, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc5, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc6, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xc7, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc8, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xc9, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xca, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xcb, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xcc, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xcd, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xce, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xcf, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd0, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd1, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd2, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd3, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd4, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd5, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd6, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xd7, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd8, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xd9, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xda, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xdb, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xdc, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xdd, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xde, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xdf, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe0, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe1, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe2, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe3, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe4, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe5, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe6, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xe7, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe8, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xe9, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xea, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xeb, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xec, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xed, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xee, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xef, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf0, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf1, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf2, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf3, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf4, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf5, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf6, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xf7, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf8, "SET",  NULL,   "B",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xf9, "SET",  NULL,   "C",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xfa, "SET",  NULL,   "D",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xfb, "SET",  NULL,   "E",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xfc, "SET",  NULL,   "H",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xfd, "SET",  NULL,   "L",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 },
	{ 0xfe, "SET",  NULL,   "(HL)", ARG_BIT,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0xff, "SET",  NULL,   "A",    ARG_BIT,  ARG_STR,  2,  8, E8080_OPF_Z80 }
};

static e8080_dop_t e8080_op_dd[256] = {
	{ 0x00, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x01, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x02, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x03, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x04, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x05, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x06, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x07, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x08, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x09, "ADD",  "IX",   "BC",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x0a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x10, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x11, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x12, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x13, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x14, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x15, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x16, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x17, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x18, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x19, "ADD",  "IX",   "DE",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x1a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x20, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x21, "LD",   "IX",   NULL,   ARG_STR,  ARG_IM16, 4, 14, E8080_OPF_Z80 },
	{ 0x22, "LD",   NULL,   "IX",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x23, "INC",  "IX",   NULL,   ARG_STR,  ARG_NONE, 2, 10, E8080_OPF_Z80 },
	{ 0x24, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x25, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x26, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x27, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x28, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x29, "ADD",  "IX",   "IX",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x2a, "LD",   "IX",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x2b, "DEC",  "IX",   NULL,   ARG_STR,  ARG_NONE, 2, 10, E8080_OPF_Z80 },
	{ 0x2c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "INC",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 3, 23, E8080_OPF_Z80 },
	{ 0x35, "DEC",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 3, 23, E8080_OPF_Z80 },
	{ 0x36, "LD",   NULL,   NULL,   ARG_IXD,  ARG_IMM8, 4, 19, E8080_OPF_Z80 },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x39, "ADD",  "IX",   "SP",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x3a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x40, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x41, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x42, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x43, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x44, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x45, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x46, "LD",   "B",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x47, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x48, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x49, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4e, "LD",   "C",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x4f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x50, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x51, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x52, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x53, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x54, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x55, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x56, "LD",   "D",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x57, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x58, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x59, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5e, "LD",   "E",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x5f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x60, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x61, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x62, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x63, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x64, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x65, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x66, "LD",   "H",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x67, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x68, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x69, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6e, "LD",   "L",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x6f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x70, "LD",   NULL,   "B",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x71, "LD",   NULL,   "C",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x72, "LD",   NULL,   "D",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x73, "LD",   NULL,   "E",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x74, "LD",   NULL,   "H",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x75, "LD",   NULL,   "L",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x76, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x77, "LD",   NULL,   "A",    ARG_IXD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x78, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x79, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7e, "LD",   "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x7f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x80, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x81, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x82, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x83, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x84, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x85, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x86, "ADD",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x87, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x88, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x89, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8e, "ADC",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x8f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x90, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x91, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x92, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x93, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x94, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x95, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x96, "SUB",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x97, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x98, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x99, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9e, "SBC",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0x9f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa6, "AND",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0xa7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xaa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xab, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xac, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xad, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xae, "XOR",  "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0xaf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb6, "OR",   "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0xb7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xba, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbe, "CP",   "A",    NULL,   ARG_STR,  ARG_IXD,  3, 19, E8080_OPF_Z80 },
	{ 0xbf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xca, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xce, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xda, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe1, "POP",  "IX",   NULL,   ARG_STR,  ARG_NONE, 2, 14, E8080_OPF_Z80 },
	{ 0xe2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe3, "EX",   "(SP)", "IX",   ARG_STR,  ARG_STR,  2, 23, E8080_OPF_Z80 },
	{ 0xe4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe5, "PUSH", "IX",   NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0xe6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe9, "JMP",  "(IX)", NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0xea, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xeb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xec, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xef, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf9, "LD",   "SP",   "IX",   ARG_STR,  ARG_STR,  2, 10, E8080_OPF_Z80 },
	{ 0xfa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xff, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND }
};

static e8080_dop_t e8080_op_ed[256] = {
	{ 0x00, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x01, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x02, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x03, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x04, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x05, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x06, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x07, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x08, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x09, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x10, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x11, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x12, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x13, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x14, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x15, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x16, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x17, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x18, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x19, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x20, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x21, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x22, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x23, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x24, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x25, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x26, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x27, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x28, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x29, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x35, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x36, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x39, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x40, "IN",   "B",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x41, "OUT",  "(C)",  "B",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x42, "SBC",  "HL",   "BC",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x43, "LD",   NULL,   "BC",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x44, "NEG",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0x44, "RETN", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 14, E8080_OPF_Z80 | E8080_OPF_RET },
	{ 0x46, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x47, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x48, "IN",   "C",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x49, "OUT",  "(C)",  "C",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x4a, "ADC",  "HL",   "BC",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x4b, "LD",   "BC",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x4c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4d, "RETI", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 14, E8080_OPF_Z80 | E8080_OPF_RET },
	{ 0x4e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x50, "IN",   "D",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x51, "OUT",  "(C)",  "D",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x52, "SBC",  "HL",   "DE",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x53, "LD",   NULL,   "DE",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x54, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x55, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x56, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x57, "LD",   "A",    "I",    ARG_STR,  ARG_STR,  2,  9, E8080_OPF_Z80 },
	{ 0x58, "IN",   "E",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x59, "OUT",  "(C)",  "E",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x5a, "ADC",  "HL",   "DE",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x5b, "LD",   "DE",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x5c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5f, "LD",   "A",    "R",    ARG_STR,  ARG_STR,  2,  9, E8080_OPF_Z80 },
	{ 0x60, "IN",   "H",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x61, "OUT",  "(C)",  "H",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x62, "SBC",  "HL",   "HL",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x63, "LD",   NULL,   "HL",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x64, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x65, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x66, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x67, "RRD",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 18, E8080_OPF_Z80 },
	{ 0x68, "IN",   "L",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x69, "OUT",  "(C)",  "L",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x6a, "ADC",  "HL",   "HL",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x6b, "LD",   "HL",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x6c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6f, "RLD",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 18, E8080_OPF_Z80 },
	{ 0x70, "IN",   "(C)",  NULL,   ARG_STR,  ARG_NONE, 2, 12, E8080_OPF_Z80 },
	{ 0x71, "OUT",  "(C)",  "0",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x72, "SBC",  "HL",   "SP",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x73, "LD",   NULL,   "SP",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x74, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x75, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x76, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x77, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x78, "IN",   "A",    "(C)",  ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x79, "OUT",  "(C)",  "A",    ARG_STR,  ARG_STR,  2, 12, E8080_OPF_Z80 },
	{ 0x6a, "ADC",  "HL",   "SP",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x7b, "LD",   "SP",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x7c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x80, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x81, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x82, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x83, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x84, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x85, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x86, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x87, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x88, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x89, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x90, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x91, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x92, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x93, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x94, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x95, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x96, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x97, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x98, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x99, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa0, "LDI",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xa1, "CPI",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xa2, "INI",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xa3, "OUTI", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xa4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa8, "LDD",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xa9, "CPD",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xaa, "IND",  NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xab, "OUTD", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 16, E8080_OPF_Z80 },
	{ 0xac, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xad, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xae, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xaf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb0, "LDIR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xb1, "CPIR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xb2, "INIR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xb3, "OTIR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xb4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb8, "LDDR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xb9, "CPDR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xba, "INDR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xbb, "OTDR", NULL,   NULL,   ARG_NONE, ARG_NONE, 2, 21, E8080_OPF_Z80 },
	{ 0xbc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbe, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xca, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xce, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xda, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xea, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xeb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xec, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xef, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xff, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND }
};

static e8080_dop_t e8080_op_fd[256] = {
	{ 0x00, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x01, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x02, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x03, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x04, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x05, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x06, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x07, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x08, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x09, "ADD",  "IY",   "BC",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x0a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x10, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x11, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x12, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x13, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x14, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x15, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x16, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x17, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x18, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x19, "ADD",  "IY",   "DE",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x1a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x20, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x21, "LD",   "IY",   NULL,   ARG_STR,  ARG_IM16, 4, 14, E8080_OPF_Z80 },
	{ 0x22, "LD",   NULL,   "IY",   ARG_AD16, ARG_STR,  4, 20, E8080_OPF_Z80 },
	{ 0x23, "INC",  "IY",   NULL,   ARG_STR,  ARG_NONE, 2, 10, E8080_OPF_Z80 },
	{ 0x24, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x25, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x26, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x27, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x28, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x29, "ADD",  "IY",   "IY",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x2a, "LD",   "IY",   NULL,   ARG_STR,  ARG_AD16, 4, 20, E8080_OPF_Z80 },
	{ 0x2b, "DEC",  "IY",   NULL,   ARG_STR,  ARG_NONE, 2, 10, E8080_OPF_Z80 },
	{ 0x2c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "INC",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 3, 23, E8080_OPF_Z80 },
	{ 0x35, "DEC",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 3, 23, E8080_OPF_Z80 },
	{ 0x36, "LD",   NULL,   NULL,   ARG_IYD,  ARG_IMM8, 4, 19, E8080_OPF_Z80 },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x39, "ADD",  "IY",   "SP",   ARG_STR,  ARG_STR,  2, 15, E8080_OPF_Z80 },
	{ 0x3a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3e, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x40, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x41, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x42, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x43, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x44, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x45, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x46, "LD",   "B",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x47, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x48, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x49, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4e, "LD",   "C",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x4f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x50, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x51, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x52, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x53, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x54, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x55, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x56, "LD",   "D",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x57, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x58, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x59, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5e, "LD",   "E",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x5f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x60, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x61, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x62, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x63, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x64, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x65, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x66, "LD",   "H",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x67, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x68, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x69, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6e, "LD",   "L",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x6f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x70, "LD",   NULL,   "B",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x71, "LD",   NULL,   "C",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x72, "LD",   NULL,   "D",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x73, "LD",   NULL,   "E",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x74, "LD",   NULL,   "H",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x75, "LD",   NULL,   "L",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x76, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x77, "LD",   NULL,   "A",    ARG_IYD,  ARG_STR,  3, 19, E8080_OPF_Z80 },
	{ 0x78, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x79, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7e, "LD",   "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x7f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x80, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x81, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x82, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x83, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x84, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x85, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x86, "ADD",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x87, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x88, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x89, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8e, "ADC",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x8f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x90, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x91, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x92, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x93, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x94, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x95, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x96, "SUB",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x97, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x98, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x99, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9e, "SBC",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0x9f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa6, "AND",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0xa7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xaa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xab, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xac, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xad, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xae, "XOR",  "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0xaf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb6, "OR",   "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0xb7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xba, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbe, "CP",   "A",    NULL,   ARG_STR,  ARG_IYD,  3, 19, E8080_OPF_Z80 },
	{ 0xbf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xca, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xce, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xda, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe1, "POP",  "IY",   NULL,   ARG_STR,  ARG_NONE, 2, 14, E8080_OPF_Z80 },
	{ 0xe2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe3, "EX",   "(SP)", "IY",   ARG_STR,  ARG_STR,  2, 23, E8080_OPF_Z80 },
	{ 0xe4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe5, "PUSH", "IY",   NULL,   ARG_STR,  ARG_NONE, 2, 15, E8080_OPF_Z80 },
	{ 0xe6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe9, "JMP",  "(IY)", NULL,   ARG_STR,  ARG_NONE, 2,  8, E8080_OPF_Z80 },
	{ 0xea, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xeb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xec, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xef, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf6, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf9, "LD",   "SP",   "IY",   ARG_STR,  ARG_STR,  2, 10, E8080_OPF_Z80 },
	{ 0xfa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xff, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND }
};

static e8080_dop_t e8080_op_dd_cb[256] = {
	{ 0x00, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x01, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x02, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x03, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x04, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x05, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x06, "RLC",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x07, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x08, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x09, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0e, "RRC",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x0f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x10, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x11, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x12, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x13, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x14, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x15, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x16, "RL",   NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x17, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x18, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x19, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1e, "RR",   NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x1f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x20, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x21, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x22, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x23, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x24, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x25, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x26, "SLA",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x27, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x28, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x29, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2e, "SRA",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x2f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x35, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x36, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x39, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3e, "SRL",  NULL,   NULL,   ARG_IXD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x3f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x40, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x41, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x42, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x43, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x44, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x45, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x46, "BIT",  "0",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x47, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x48, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x49, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4e, "BIT",  "1",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x4f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x50, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x51, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x52, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x53, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x54, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x55, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x56, "BIT",  "2",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x57, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x58, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x59, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5e, "BIT",  "3",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x5f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x60, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x61, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x62, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x63, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x64, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x65, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x66, "BIT",  "4",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x67, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x68, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x69, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6e, "BIT",  "5",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x6f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x70, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x71, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x72, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x73, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x74, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x75, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x76, "BIT",  "6",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x77, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x78, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x79, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7e, "BIT",  "7",    NULL,   ARG_STR,  ARG_IXD,  4, 20, E8080_OPF_Z80 },
	{ 0x7f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x80, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x81, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x82, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x83, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x84, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x85, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x86, "RES",  "0",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0x87, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x88, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x89, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8e, "RES",  "1",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0x8f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x90, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x91, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x92, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x93, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x94, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x95, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x96, "RES",  "2",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0x97, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x98, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x99, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9e, "RES",  "3",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0x9f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa6, "RES",  "4",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xa7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xaa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xab, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xac, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xad, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xae, "RES",  "5",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xaf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb6, "RES",  "6",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xb7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xba, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbe, "RES",  "7",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xbf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "SET",  "0",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xc7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xca, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "SET",  "1",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xcf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd6, "SET",  "2",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xd7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xda, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "SET",  "3",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xdf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe6, "SET",  "4",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xe7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xea, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xeb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xec, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "SET",  "5",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xef, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf6, "SET",  "6",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xf7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "SET",  "7",    NULL,   ARG_STR,  ARG_IXD,  4, 23, E8080_OPF_Z80 },
	{ 0xff, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND }
};

static e8080_dop_t e8080_op_fd_cb[256] = {
	{ 0x00, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x01, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x02, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x03, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x04, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x05, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x06, "RLC",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x07, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x08, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x09, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x0e, "RRC",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x0f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x10, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x11, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x12, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x13, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x14, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x15, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x16, "RL",   NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x17, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x18, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x19, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x1e, "RR",   NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x1f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x20, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x21, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x22, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x23, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x24, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x25, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x26, "SLA",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x27, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x28, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x29, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x2e, "SRA",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x2f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x30, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x31, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x32, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x33, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x34, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x35, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x36, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x37, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x38, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x39, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x3e, "SRL",  NULL,   NULL,   ARG_IYD,  ARG_NONE, 4, 23, E8080_OPF_Z80 },
	{ 0x3f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x40, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x41, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x42, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x43, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x44, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x45, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x46, "BIT",  "0",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x47, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x48, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x49, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x4e, "BIT",  "1",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x4f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x50, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x51, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x52, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x53, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x54, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x55, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x56, "BIT",  "2",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x57, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x58, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x59, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x5e, "BIT",  "3",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x5f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x60, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x61, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x62, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x63, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x64, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x65, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x66, "BIT",  "4",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x67, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x68, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x69, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x6e, "BIT",  "5",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x6f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x70, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x71, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x72, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x73, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x74, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x75, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x76, "BIT",  "6",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x77, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x78, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x79, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x7e, "BIT",  "7",    NULL,   ARG_STR,  ARG_IYD,  4, 20, E8080_OPF_Z80 },
	{ 0x7f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x80, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x81, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x82, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x83, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x84, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x85, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x86, "RES",  "0",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0x87, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x88, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x89, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x8e, "RES",  "1",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0x8f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x90, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x91, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x92, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x93, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x94, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x95, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x96, "RES",  "2",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0x97, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x98, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x99, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9a, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9b, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9c, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9d, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0x9e, "RES",  "3",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0x9f, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa6, "RES",  "4",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xa7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xa9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xaa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xab, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xac, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xad, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xae, "RES",  "5",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xaf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb6, "RES",  "6",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xb7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xb9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xba, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xbe, "RES",  "7",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xbf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc6, "SET",  "0",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xc7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xc9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xca, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xcd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xce, "SET",  "1",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xcf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd6, "SET",  "2",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xd7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xd9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xda, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xdd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xde, "SET",  "3",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xdf, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe6, "SET",  "4",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xe7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xe9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xea, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xeb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xec, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xed, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xee, "SET",  "5",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xef, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf0, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf1, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf2, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf3, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf4, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf5, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf6, "SET",  "6",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xf7, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf8, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xf9, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfa, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfb, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfc, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfd, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND },
	{ 0xfe, "SET",  "7",    NULL,   ARG_STR,  ARG_IYD,  4, 23, E8080_OPF_Z80 },
	{ 0xff, "DB",   NULL,   NULL,   ARG_OPC8, ARG_NONE, 1,  4, E8080_OPF_UND }
};


static
int z80_disasm_arg (char *dst, const unsigned char *src, unsigned *idx, const char *str, unsigned arg, unsigned pc)
{
	const unsigned char *opc;

	opc = src + *idx;

	switch (arg) {
	case ARG_STR:
		strcpy (dst, str);
		return (0);

	case ARG_OPC8:
		sprintf (dst, "%02X", src[0]);
		return (0);

	case ARG_IMM8:
		sprintf (dst, "%02X", opc[1]);
		return (0);

	case ARG_IM16:
		sprintf (dst, "%04X", e8080_uint16 (opc[1], opc[2]));
		return (0);

	case ARG_JMP8:
		sprintf (dst, "%04X", (pc + 2 + e8080_sext8 (opc[1])) & 0xffff);
		return (0);

	case ARG_JP16:
		sprintf (dst, "%04X", e8080_uint16 (opc[1], opc[2]));
		return (0);

	case ARG_AD16:
		sprintf (dst, "(%04X)", e8080_uint16 (opc[1], opc[2]));
		return (0);

	case ARG_IXD:
		if (opc[1] & 0x80) {
			sprintf (dst, "(IX-%02X)", (~opc[1] + 1) & 0xff);
		}
		else {
			sprintf (dst, "(IX+%02X)", opc[1]);
		}
		*idx += 1;
		return (0);

	case ARG_IYD:
		if (opc[1] & 0x80) {
			sprintf (dst, "(IY-%02X)", (~opc[1] + 1) & 0xff);
		}
		else {
			sprintf (dst, "(IY+%02X)", opc[1]);
		}
		*idx += 1;
		return (0);

	case ARG_BIT:
		sprintf (dst, "%u", (opc[0] >> 3) & 7);
		return (0);
	}

	return (1);
}

void z80_disasm (e8080_disasm_t *op, const unsigned char *src, unsigned short pc)
{
	unsigned    i, n, idx;
	e8080_dop_t *tab;

	idx = 0;

	if (src[0] == 0xcb) {
		idx = 1;
		tab = &e8080_op_cb[src[1] & 0xff];
	}
	else if (src[0] == 0xdd) {
		if (src[1] == 0xcb) {
			idx = 1;
			tab = &e8080_op_dd_cb[src[3] & 0xff];
		}
		else if (src[1] == 0xdd) {
			tab = &e8080_opcodes[src[0] & 0xff];
		}
		else if (src[1] == 0xfd) {
			tab = &e8080_opcodes[src[0] & 0xff];
		}
		else {
			idx = 1;
			tab = &e8080_op_dd[src[1] & 0xff];
		}
	}
	else if (src[0] == 0xed) {
		idx = 1;
		tab = &e8080_op_ed[src[1] & 0xff];
	}
	else if (src[0] == 0xfd) {
		if (src[1] == 0xcb) {
			idx = 1;
			tab = &e8080_op_fd_cb[src[3] & 0xff];
		}
		else if (src[1] == 0xdd) {
			tab = &e8080_opcodes[src[0] & 0xff];
		}
		else if (src[1] == 0xfd) {
			tab = &e8080_opcodes[src[0] & 0xff];
		}
		else {
			idx = 1;
			tab = &e8080_op_fd[src[1] & 0xff];
		}
	}
	else {
		tab = &e8080_opcodes[src[0] & 0xff];
	}

	op->pc = pc;
	op->flags = tab->flags;
	op->data_cnt = tab->size;

	for (i = 0; i < tab->size; i++) {
		op->data[i] = src[i];
	}

	strcpy (op->op, tab->mnemonic);

	n = 0;

	if (z80_disasm_arg (op->arg[n], src, &idx, tab->arg1s, tab->arg1, pc) == 0) {
		n += 1;
	}

	if (z80_disasm_arg (op->arg[n], src, &idx, tab->arg2s, tab->arg2, pc) == 0) {
		n += 1;
	}

	op->arg_cnt = n;
}

void z80_disasm_mem (e8080_t *c, e8080_disasm_t *op, unsigned short pc)
{
	unsigned      i;
	unsigned char src[4];

	for (i = 0; i < 4; i++) {
		src[i] = e8080_get_mem8 (c, (pc + i) & 0xffff);
	}

	z80_disasm (op, src, pc);
}

void z80_disasm_cur (e8080_t *c, e8080_disasm_t *op)
{
	z80_disasm_mem (c, op, e8080_get_pc (c));
}
