/*****************************************************************************
 * pce                                                                       *
 *****************************************************************************/

/*****************************************************************************
 * File name:   src/devices/video/wy700_font.c                               *
 * Created:     2008-10-29 by Hampa Hug <hampa@hampa.ch>                     *
 *****************************************************************************/


#include <devices/video/wy700_font.h>


/*
 * Wyse 700 thick font
 */
unsigned char wy700_font_thick[256 * 32] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x60, 0x06,
	0xc0, 0x03, 0xcc, 0x33, 0xc0, 0x03, 0xc0, 0x03,
	0xcf, 0xf3, 0xc3, 0xc3, 0xc0, 0x03, 0x60, 0x06,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x7f, 0xfe,
	0xff, 0xff, 0xf3, 0xcf, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0x0f, 0xfc, 0x3f, 0xff, 0xff, 0x7f, 0xfe,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78,
	0x3f, 0xfc, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe,
	0x3f, 0xfc, 0x1f, 0xf8, 0x07, 0xe0, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80,
	0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8,
	0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
	0x07, 0xe0, 0x3c, 0x3c, 0x7c, 0x3e, 0x7c, 0x3e,
	0x3c, 0x3c, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3f, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x0f, 0xf0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xf0, 0x0f,
	0xf0, 0x0f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c, 0x30, 0x0c,
	0x30, 0x0c, 0x3c, 0x3c, 0x0f, 0xf0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xf0, 0x0f, 0xc3, 0xc3, 0xcf, 0xf3,
	0xcf, 0xf3, 0xc3, 0xc3, 0xf0, 0x0f, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
	0x00, 0x1f, 0x00, 0x3f, 0x00, 0x7b, 0x07, 0xf0,
	0x1e, 0x78, 0x3c, 0x3c, 0x3c, 0x3c, 0x1e, 0x78,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x1e, 0x78,
	0x3c, 0x3c, 0x3c, 0x3c, 0x1e, 0x78, 0x07, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0x0f,
	0x0f, 0xff, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0x7f, 0x00,
	0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x1e, 0x1e,
	0x1f, 0xfe, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3e, 0x3e, 0x7e,
	0x7e, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0xf3, 0xcf, 0x0f, 0xf0, 0xfc, 0x3f,
	0x0f, 0xf0, 0xf3, 0xcf, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3c, 0x00,
	0x3f, 0x00, 0x3f, 0xc0, 0x3f, 0xf0, 0x3f, 0xfc,
	0x3f, 0xf0, 0x3f, 0xc0, 0x3f, 0x00, 0x3c, 0x00,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3c,
	0x00, 0xfc, 0x03, 0xfc, 0x0f, 0xfc, 0x3f, 0xfc,
	0x0f, 0xfc, 0x03, 0xfc, 0x00, 0xfc, 0x00, 0x3c,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x0f, 0xf0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x0f, 0x0f,
	0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf3, 0xcf,
	0xf3, 0xcf, 0xf3, 0xcf, 0xf3, 0xcf, 0x3f, 0xcf,
	0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf, 0x03, 0xcf,
	0x03, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x0f, 0x0f, 0x00,
	0x03, 0xf0, 0x0f, 0x3c, 0x3c, 0x0f, 0x3c, 0x0f,
	0x0f, 0x3c, 0x03, 0xf0, 0x00, 0x3c, 0x3c, 0x0f,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x0f, 0xf0,
	0x03, 0xc0, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3f, 0xfc, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc, 0x0f, 0xf0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf0, 0x00, 0x3c, 0x3f, 0xff,
	0x00, 0x3c, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0xc0, 0x0f, 0x00, 0x3f, 0xff,
	0x0f, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x30, 0x3c, 0x3c, 0xff, 0xff,
	0x3c, 0x3c, 0x0c, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
	0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0,
	0x07, 0xe0, 0x03, 0xc0, 0x01, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
	0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x1c, 0x38,
	0x0c, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38,
	0x1c, 0x38, 0x7f, 0xfe, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x7f, 0xfe, 0x1c, 0x38,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x07, 0xe0, 0x1e, 0x78,
	0x3c, 0x3c, 0x3c, 0x00, 0x1e, 0x00, 0x07, 0xe0,
	0x00, 0x78, 0x00, 0x3c, 0x3c, 0x3c, 0x1e, 0x78,
	0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x3c, 0x3c, 0x78, 0x00, 0xf0, 0x01, 0xe0,
	0x03, 0xc0, 0x07, 0x80, 0x0f, 0x00, 0x1e, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x1e, 0xf0,
	0x3c, 0x78, 0x1e, 0xf0, 0x07, 0xc0, 0x0f, 0x9e,
	0x3f, 0xfc, 0x78, 0xf8, 0x78, 0x78, 0x3c, 0xfc,
	0x0f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x03, 0xc0,
	0x07, 0x80, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0,
	0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x00, 0xf0,
	0x00, 0x78, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
	0x00, 0x3c, 0x00, 0x3c, 0x00, 0x78, 0x00, 0xf0,
	0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x3c, 0x0f, 0xf0, 0x7f, 0xfe,
	0x0f, 0xf0, 0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x7f, 0xfe,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
	0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x1e, 0x78,
	0x3c, 0x3c, 0x3c, 0x7c, 0x3c, 0xfc, 0x3d, 0xbc,
	0x3f, 0x3c, 0x3e, 0x3c, 0x3c, 0x3c, 0x1e, 0x78,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xc0,
	0x3f, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x3c, 0x78,
	0x00, 0x3c, 0x00, 0x3c, 0x00, 0x78, 0x00, 0xf0,
	0x03, 0xc0, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x3c,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c,
	0x00, 0x1e, 0x00, 0x1e, 0x00, 0x3c, 0x03, 0xf0,
	0x00, 0x3c, 0x00, 0x1e, 0x00, 0x1e, 0x3c, 0x3c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x03, 0xf0,
	0x07, 0xf0, 0x0f, 0xf0, 0x1e, 0xf0, 0x3c, 0xf0,
	0x3f, 0xfc, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x3c, 0x00,
	0x3c, 0x00, 0x3c, 0x00, 0x3f, 0xf0, 0x00, 0x3c,
	0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x3c, 0x3c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x00,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3f, 0xf0,
	0x3c, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3c, 0x3c,
	0x00, 0x3c, 0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c, 0x07, 0xf0,
	0x1e, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x1e, 0x07, 0xfe,
	0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x3c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x03, 0xc0,
	0x07, 0x80, 0x0f, 0x00, 0x1e, 0x00, 0x3c, 0x00,
	0x1e, 0x00, 0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0,
	0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x03, 0xc0,
	0x01, 0xe0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x3c,
	0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
	0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x1e, 0x78,
	0x3c, 0x3c, 0x00, 0x78, 0x00, 0xf0, 0x01, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x1e,
	0x78, 0x1e, 0x79, 0xfe, 0x7b, 0x8e, 0x7b, 0x8e,
	0x7b, 0x8e, 0x79, 0xfc, 0x78, 0x00, 0x3c, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
	0x0f, 0xf0, 0x1e, 0x78, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x1e, 0x3c,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c, 0x1f, 0xf0,
	0x1e, 0x3c, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c,
	0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x1e, 0x3c,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c,
	0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x1e, 0x0e,
	0x1e, 0x06, 0x1e, 0x00, 0x1e, 0x60, 0x1f, 0xe0,
	0x1e, 0x60, 0x1e, 0x00, 0x1e, 0x06, 0x1e, 0x0e,
	0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x1e, 0x0e,
	0x1e, 0x06, 0x1e, 0x00, 0x1e, 0x60, 0x1f, 0xe0,
	0x1e, 0x60, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00,
	0x7f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x7e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3e,
	0x07, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3f, 0xfe,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x00, 0x78,
	0x00, 0x78, 0x00, 0x78, 0x00, 0x78, 0x00, 0x78,
	0x00, 0x78, 0x00, 0x78, 0x3c, 0x78, 0x1f, 0xf0,
	0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x3c, 0x1e, 0x78,
	0x1e, 0xf0, 0x1f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0,
	0x1f, 0xe0, 0x1e, 0xf0, 0x1e, 0x78, 0x1e, 0x3c,
	0x7e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x1e, 0x00,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x06, 0x1e, 0x0e,
	0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x7c, 0x3e,
	0x7e, 0x7e, 0x7f, 0xfe, 0x7b, 0xde, 0x79, 0x9e,
	0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e,
	0x78, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3e, 0x1e, 0x3f, 0x1e, 0x3f, 0x9e, 0x3d, 0xde,
	0x3c, 0xfe, 0x3c, 0x7e, 0x3c, 0x3e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x1e, 0x3c,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c, 0x1f, 0xf0,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00,
	0x7f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3d, 0xde, 0x3c, 0xfe, 0x1e, 0x7c,
	0x07, 0xf8, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x1e, 0x3c,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c, 0x1f, 0xf0,
	0x1f, 0xe0, 0x1e, 0xf0, 0x1e, 0x78, 0x1e, 0x3c,
	0x7e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c,
	0x78, 0x1e, 0x3c, 0x00, 0x0f, 0x00, 0x03, 0xc0,
	0x00, 0xf0, 0x00, 0x3c, 0x78, 0x1e, 0x3c, 0x3c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x73, 0xce,
	0x63, 0xc6, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x78, 0x1e,
	0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e,
	0x79, 0x9e, 0x7b, 0xde, 0x7f, 0xfe, 0x3e, 0x7c,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
	0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x78, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x1e, 0x78, 0x0f, 0xf0,
	0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x38, 0x3c,
	0x30, 0x78, 0x00, 0xf0, 0x01, 0xe0, 0x03, 0xc0,
	0x07, 0x80, 0x0f, 0x00, 0x1e, 0x0c, 0x3c, 0x1c,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00,
	0x1e, 0x00, 0x0f, 0x00, 0x07, 0x80, 0x03, 0xc0,
	0x01, 0xe0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x78,
	0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x01, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x78,
	0x0f, 0xf8, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78,
	0x0f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0xf0, 0x0f, 0x3c,
	0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e,
	0x3c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x3c, 0x1e,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x1e,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x78,
	0x00, 0x78, 0x00, 0x78, 0x07, 0xf8, 0x1e, 0x78,
	0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78,
	0x0f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3f, 0xfe, 0x3c, 0x00, 0x3c, 0x1e,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0x3c,
	0x0f, 0x0c, 0x0f, 0x00, 0x0f, 0x00, 0x3f, 0xf0,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x3f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x9e, 0x3c, 0x78,
	0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x0f, 0xf8,
	0x00, 0x78, 0x3c, 0x78, 0x0f, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x78, 0x0f, 0x9e,
	0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e,
	0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0x00, 0x03, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x3c, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x3c,
	0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c,
	0x3c, 0x3c, 0x1e, 0x78, 0x07, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x1e, 0x0f, 0x3c,
	0x0f, 0x78, 0x0f, 0xf0, 0x0f, 0x78, 0x0f, 0x3c,
	0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x7c, 0x7f, 0xfe,
	0x7b, 0xde, 0x7b, 0xde, 0x7b, 0xde, 0x7b, 0xde,
	0x7b, 0xde, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0xf8, 0x0f, 0x3c,
	0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e,
	0x0f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0x0f, 0x3c,
	0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x3c, 0x0f, 0xf0,
	0x0f, 0x00, 0x0f, 0x00, 0x3f, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x9e, 0x1e, 0x78,
	0x3c, 0x78, 0x3c, 0x78, 0x1e, 0x78, 0x07, 0xf8,
	0x00, 0x78, 0x00, 0x78, 0x00, 0xfe, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0xf8, 0x0f, 0x9e,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00,
	0x3f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x3c, 0x1e,
	0x3c, 0x00, 0x0f, 0xf8, 0x00, 0x1e, 0x3c, 0x1e,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0x80,
	0x07, 0x80, 0x07, 0x80, 0x7f, 0xf8, 0x07, 0x80,
	0x07, 0x80, 0x07, 0x80, 0x07, 0x80, 0x07, 0x9e,
	0x01, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x78, 0x3c, 0x78,
	0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78,
	0x0f, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x78, 0x1e,
	0x78, 0x1e, 0x78, 0x1e, 0x1e, 0x78, 0x07, 0xe0,
	0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x78, 0x1e,
	0x78, 0x1e, 0x79, 0x9e, 0x7b, 0xde, 0x3f, 0xfc,
	0x1e, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x0e, 0x70,
	0x07, 0xe0, 0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70,
	0x3c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x1e, 0x07, 0xfe,
	0x00, 0x1e, 0x00, 0x3c, 0x0f, 0xf0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3c, 0x3c,
	0x00, 0xf0, 0x03, 0xc0, 0x0f, 0x00, 0x3c, 0x3c,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x01, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x3f, 0x80,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0xe0,
	0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x07, 0x80,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x01, 0xfc,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x07, 0x80,
	0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x9e, 0x3c, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc0, 0x03, 0xf0, 0x0f, 0x3c, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x1e, 0x1e,
	0x3c, 0x06, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x3c, 0x06, 0x1e, 0x1e, 0x07, 0xf8,
	0x00, 0x78, 0x00, 0x1e, 0x0f, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0xf0,
	0x03, 0xc0, 0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x00, 0x3c, 0x0f,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xf0,
	0x0f, 0x3c, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3c,
	0x0f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3c,
	0x0f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x03, 0xc0,
	0x00, 0xf0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3c,
	0x0f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0x3c,
	0x03, 0xf0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3c,
	0x0f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c, 0x3c, 0x00,
	0x3c, 0x00, 0x3c, 0x3c, 0x0f, 0xf0, 0x00, 0xf0,
	0x00, 0x3c, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x03, 0xf0,
	0x0f, 0x3c, 0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x00, 0x3c, 0x0f,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x00, 0x3c, 0x0f,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x03, 0xc0,
	0x00, 0xf0, 0x00, 0x00, 0x0f, 0xfc, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x00, 0x3c, 0x0f,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c,
	0x3c, 0x3c, 0x00, 0x00, 0x0f, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3c, 0x3c, 0x00, 0x00, 0x0f, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x0f, 0x00,
	0x03, 0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x0f, 0x3c, 0x0f, 0x00, 0xc0,
	0x03, 0xf0, 0x0f, 0x3c, 0x3c, 0x0f, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x0f, 0x3c, 0x0f,
	0x3c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xf0, 0x0f, 0x3c, 0x03, 0xf0, 0x00, 0x00,
	0x03, 0xf0, 0x0f, 0x3c, 0x3c, 0x0f, 0x3c, 0x0f,
	0x3c, 0x0f, 0x3f, 0xff, 0x3c, 0x0f, 0x3c, 0x0f,
	0x3c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0x03, 0xc0, 0x0f, 0x00, 0x00, 0x00,
	0x3f, 0xff, 0x0f, 0x0f, 0x0f, 0x00, 0x0f, 0x00,
	0x0f, 0xfc, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x0f,
	0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x03, 0xcf,
	0x03, 0xcf, 0x7f, 0xfe, 0xf3, 0xc0, 0xf3, 0xc0,
	0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x0f, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3f, 0xff,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x07, 0xe0,
	0x1e, 0x78, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e,
	0x3c, 0x1e, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x03, 0xc0,
	0x00, 0xf0, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x3c, 0x3c, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x03, 0xc0,
	0x00, 0xf0, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x1e,
	0x3c, 0x1e, 0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x1e, 0x07, 0xfe,
	0x00, 0x1e, 0x00, 0x3c, 0x0f, 0xf0, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e, 0x00, 0x00,
	0x07, 0xf0, 0x1e, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x1e, 0x3c, 0x1e, 0x00, 0x00,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x1f, 0xf8, 0x78, 0x1e, 0x78, 0x00, 0x78, 0x00,
	0x78, 0x00, 0x78, 0x1e, 0x1f, 0xf8, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0x3c,
	0x0f, 0x0c, 0x0f, 0x00, 0x3f, 0xc0, 0x0f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x3f, 0x0f,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x1e, 0x78,
	0x07, 0xe0, 0x03, 0xc0, 0x03, 0xc0, 0x7f, 0xfe,
	0x03, 0xc0, 0x7f, 0xfe, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3f, 0xf0, 0x3c, 0x0c, 0x3c, 0x3c,
	0x3c, 0xff, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0xcf,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x3f, 0xfc,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xf3, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xc0,
	0x0f, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x3c,
	0x0f, 0xfc, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xc0,
	0x0f, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xc0,
	0x0f, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0xc0,
	0x0f, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x0f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x9e,
	0x79, 0xf8, 0x00, 0x00, 0x79, 0xf8, 0x1e, 0x3c,
	0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x9e, 0x79, 0xf8, 0x00, 0x00,
	0x78, 0x1e, 0x78, 0x1e, 0x7e, 0x1e, 0x7f, 0x9e,
	0x7f, 0xfe, 0x79, 0xfe, 0x78, 0x7e, 0x78, 0x1e,
	0x78, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x3c, 0xf0,
	0x3c, 0xf0, 0x0f, 0xfc, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x3c, 0xf0,
	0x3c, 0xf0, 0x0f, 0xc0, 0x00, 0x00, 0x3f, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x07, 0x80, 0x1e, 0x00, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff,
	0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0xfc, 0x00,
	0x3c, 0x0f, 0x3c, 0x3c, 0x3c, 0xf0, 0x03, 0xc0,
	0x0f, 0x00, 0x3c, 0xfc, 0xf0, 0x0f, 0x00, 0x3c,
	0x00, 0xf0, 0x03, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0xfc, 0x00,
	0x3c, 0x0f, 0x3c, 0x3c, 0x3c, 0xf0, 0x03, 0xc0,
	0x0f, 0x0f, 0x3c, 0x3f, 0xf0, 0xe7, 0x03, 0xff,
	0x00, 0x0f, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0, 0x07, 0xe0,
	0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0xcf, 0x0f, 0x3c, 0x3c, 0xf0,
	0x0f, 0x3c, 0x03, 0xcf, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0xf0, 0x0f, 0x3c, 0x03, 0xcf,
	0x0f, 0x3c, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xff, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0x03, 0xc0,
	0xff, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0xff, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xfc, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x03, 0xc0,
	0xff, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3c, 0x00, 0x3c,
	0xff, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x3c,
	0xff, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3c, 0x00, 0x3c,
	0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0xff, 0xc0, 0x03, 0xc0,
	0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xc0,
	0x03, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3f, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3f, 0x0f, 0x00,
	0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0x00,
	0x0f, 0x3f, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3f, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0x3f, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3f, 0x0f, 0x00,
	0x0f, 0x3f, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0xff, 0x3f, 0x00, 0x00,
	0xff, 0x3f, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xff, 0x03, 0xc0,
	0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x03, 0xc0,
	0x03, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0xff, 0xff, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c, 0x0f, 0x3c,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0xff, 0xff, 0x03, 0xc0,
	0xff, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xff, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x9e, 0x1f, 0xfc,
	0x3c, 0xf8, 0x3c, 0xf0, 0x3c, 0xf8, 0x1f, 0xfc,
	0x07, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xf8, 0x3c, 0x1e, 0x3c, 0x1e, 0x3f, 0xf8,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3f, 0xf8, 0x3c, 0x00,
	0x3c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xfe, 0x1e, 0x78, 0x1e, 0x78,
	0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78,
	0x1e, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x3c, 0x1e,
	0x3c, 0x00, 0x0f, 0x00, 0x03, 0xc0, 0x00, 0xf0,
	0x03, 0xc0, 0x0f, 0x00, 0x3c, 0x00, 0x3c, 0x1e,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x1e, 0x78,
	0x3c, 0x78, 0x3c, 0x78, 0x3c, 0x78, 0x1e, 0xf0,
	0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0x1e,
	0x0f, 0x1e, 0x0f, 0x1e, 0x0f, 0xf8, 0x0f, 0x00,
	0x0f, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xcf, 0x3c, 0xfc, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x03, 0xc0,
	0x0f, 0xf0, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	0x3c, 0x3c, 0x3c, 0x3c, 0x0f, 0xf0, 0x03, 0xc0,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1e, 0x3c,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3f, 0xfe,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c,
	0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78, 0x1e,
	0x3c, 0x3c, 0x1e, 0x78, 0x1e, 0x78, 0x1e, 0x78,
	0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xfc, 0x0f, 0x00,
	0x0f, 0x00, 0x03, 0xc0, 0x00, 0xf0, 0x07, 0xfc,
	0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x1e, 0x78,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0xf3, 0xcf,
	0xf3, 0xcf, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x00, 0x38, 0x0f, 0xf0, 0x3c, 0xfc, 0x79, 0xde,
	0x7b, 0x9e, 0x3f, 0x3c, 0x0f, 0xf0, 0x1c, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0f, 0x00,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3f, 0xf0,
	0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x0f, 0x00,
	0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0,
	0x1e, 0x3c, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e, 0x3c, 0x1e,
	0x3c, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x7f, 0xfe, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x00, 0x00, 0x7f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00,
	0x03, 0xc0, 0x00, 0xf0, 0x00, 0x3c, 0x00, 0xf0,
	0x03, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
	0x03, 0xc0, 0x0f, 0x00, 0x3c, 0x00, 0x0f, 0x00,
	0x03, 0xc0, 0x00, 0xf0, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0xcf,
	0x03, 0xcf, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0xf3, 0xc0, 0xf3, 0xc0,
	0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xcf, 0x3c, 0xfc, 0x00, 0x00,
	0x0f, 0xcf, 0x3c, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xc0, 0x3c, 0xf0, 0x3c, 0xf0,
	0x0f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x00, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0,
	0xfc, 0xf0, 0x3c, 0xf0, 0x0f, 0xf0, 0x03, 0xf0,
	0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf3, 0xc0, 0x3c, 0xf0, 0x3c, 0xf0,
	0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0x00, 0xf3, 0xc0, 0x03, 0xc0,
	0x0f, 0x00, 0x3c, 0x00, 0xf0, 0xc0, 0xff, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f, 0xfc,
	0x0f, 0xfc, 0x0f, 0xfc, 0x0f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/*
 * Wyse 700 thin font
 */
unsigned char wy700_font_thin[256 * 32] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x60, 0x06,
	0xc0, 0x03, 0xcc, 0x33, 0xc0, 0x03, 0xc0, 0x03,
	0xcf, 0xf3, 0xc3, 0xc3, 0xc0, 0x03, 0x60, 0x06,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x7f, 0xfe,
	0xff, 0xff, 0xf3, 0xcf, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0x0f, 0xfc, 0x3f, 0xff, 0xff, 0x7f, 0xfe,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78,
	0x3f, 0xfc, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe,
	0x3f, 0xfc, 0x1f, 0xf8, 0x07, 0xe0, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80,
	0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f, 0xf8,
	0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0xe0,
	0x03, 0xe0, 0x1d, 0xdc, 0x3f, 0xfe, 0x3f, 0xfe,
	0x1d, 0xdc, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0xf0,
	0x1f, 0xfc, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0xff,
	0x1d, 0xdc, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0f, 0xf0,
	0x0f, 0xf0, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xf0, 0x0f,
	0xf0, 0x0f, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xf0, 0x3c, 0x3c, 0x30, 0x0c,
	0x30, 0x0c, 0x3c, 0x3c, 0x0f, 0xf0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xf0, 0x0f, 0xc3, 0xc3, 0xcf, 0xf3,
	0xcf, 0xf3, 0xc3, 0xc3, 0xf0, 0x0f, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f,
	0x00, 0x1f, 0x00, 0x3b, 0x00, 0x70, 0x07, 0xe0,
	0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0x1c, 0x38,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x0e, 0x38,
	0x1c, 0x1c, 0x1c, 0x1c, 0x0e, 0x38, 0x03, 0xe0,
	0x01, 0xc0, 0x01, 0xc0, 0x1f, 0xfc, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0e, 0x07,
	0x0f, 0xff, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x3e, 0x00, 0x7e, 0x00,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x1c, 0x0e,
	0x1f, 0xfe, 0x1c, 0x0e, 0x1c, 0x0e, 0x1c, 0x0e,
	0x1c, 0x0e, 0x1c, 0x0e, 0x1c, 0x1e, 0x3c, 0x3e,
	0x7c, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,
	0x39, 0xce, 0x1d, 0xdc, 0x0f, 0xf8, 0x7e, 0x3f,
	0x0f, 0xf8, 0x1d, 0xdc, 0x39, 0xce, 0x01, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3c, 0x00,
	0x3f, 0x00, 0x3f, 0xc0, 0x3f, 0xf0, 0x3f, 0xfc,
	0x3f, 0xf0, 0x3f, 0xc0, 0x3f, 0x00, 0x3c, 0x00,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3c,
	0x00, 0xfc, 0x03, 0xfc, 0x0f, 0xfc, 0x3f, 0xfc,
	0x0f, 0xfc, 0x03, 0xfc, 0x00, 0xfc, 0x00, 0x3c,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0xf0,
	0x1d, 0xdc, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x1d, 0xdc, 0x07, 0xf0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x38, 0x0e, 0x38,
	0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38,
	0x0e, 0x38, 0x0e, 0x38, 0x00, 0x00, 0x0e, 0x38,
	0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x71, 0xce,
	0x71, 0xce, 0x71, 0xce, 0x71, 0xce, 0x1f, 0xce,
	0x01, 0xce, 0x01, 0xce, 0x01, 0xce, 0x01, 0xce,
	0x01, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e, 0x0e, 0x00,
	0x03, 0xe0, 0x0e, 0x38, 0x38, 0x0e, 0x38, 0x0e,
	0x0e, 0x38, 0x03, 0xe0, 0x00, 0x38, 0x38, 0x0e,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x3f, 0xff,
	0x3f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0xf0,
	0x1d, 0xdc, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x1d, 0xdc, 0x07, 0xf0,
	0x01, 0xc0, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0xf0,
	0x1d, 0xdc, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x1d, 0xdc, 0x07, 0xf0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x70, 0x00, 0x1c, 0x3f, 0xff,
	0x00, 0x1c, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x0e, 0x00, 0x3f, 0xff,
	0x0e, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x38, 0x38, 0x1c, 0x7f, 0xfe,
	0x38, 0x1c, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0,
	0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xfe, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfe, 0x3f, 0xfc, 0x1f, 0xf8, 0x0f, 0xf0,
	0x07, 0xe0, 0x03, 0xc0, 0x01, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38,
	0x1c, 0x38, 0x7f, 0xfe, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x7f, 0xfe, 0x1c, 0x38,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x80, 0x0f, 0xf0, 0x39, 0x9c,
	0x71, 0x8e, 0x71, 0x80, 0x39, 0x80, 0x0f, 0xf0,
	0x01, 0x9c, 0x01, 0x8e, 0x71, 0x8e, 0x39, 0x9c,
	0x0f, 0xf0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x1c, 0x1e, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x3c,
	0x1c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x1c, 0x70,
	0x38, 0x38, 0x1c, 0x70, 0x07, 0xc0, 0x0f, 0xce,
	0x38, 0xfc, 0x70, 0x78, 0x70, 0x78, 0x38, 0xfc,
	0x0f, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x38, 0x03, 0xe0, 0x3f, 0xfe,
	0x03, 0xe0, 0x0e, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x3f, 0xfe,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x1c, 0x38,
	0x38, 0x3c, 0x38, 0x7c, 0x38, 0xdc, 0x39, 0x9c,
	0x3b, 0x1c, 0x3e, 0x1c, 0x3c, 0x1c, 0x1c, 0x38,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x03, 0xc0,
	0x0f, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x1c,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x70,
	0x01, 0xc0, 0x07, 0x00, 0x1c, 0x00, 0x38, 0x00,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x1c,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x1c, 0x01, 0xf0,
	0x00, 0x1c, 0x00, 0x0e, 0x00, 0x0e, 0x38, 0x1c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x03, 0xf0,
	0x07, 0x70, 0x0e, 0x70, 0x1c, 0x70, 0x38, 0x70,
	0x3f, 0xfc, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x3f, 0xf0, 0x00, 0x1c,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x38, 0x1c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x3f, 0xf0,
	0x38, 0x1c, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c, 0x07, 0xf0,
	0x1c, 0x1c, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x0e, 0x07, 0xfe,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x1c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x38,
	0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x1c, 0x38,
	0x38, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x1c,
	0x70, 0x0e, 0x71, 0xfe, 0x73, 0x8e, 0x73, 0x8e,
	0x73, 0x8e, 0x71, 0xfc, 0x70, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0,
	0x0e, 0x70, 0x1c, 0x38, 0x38, 0x1c, 0x38, 0x1c,
	0x3f, 0xfc, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c, 0x3f, 0xf0,
	0x38, 0x1c, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c,
	0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c,
	0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x3f, 0xe0,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x3f, 0xe0,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x3e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x3f, 0xfe,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x0e, 0x38,
	0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x1c, 0x70,
	0x1c, 0xe0, 0x1d, 0xc0, 0x1f, 0x80, 0x1f, 0x80,
	0x1d, 0xc0, 0x1c, 0xe0, 0x1c, 0x70, 0x1c, 0x38,
	0x1c, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x1e, 0x7c, 0x3e,
	0x7e, 0x7e, 0x77, 0xee, 0x73, 0xce, 0x71, 0x8e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x3c, 0x0e,
	0x3e, 0x0e, 0x3f, 0x0e, 0x3b, 0x8e, 0x39, 0xce,
	0x38, 0xee, 0x38, 0x7e, 0x38, 0x3e, 0x38, 0x1e,
	0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c, 0x3f, 0xf0,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0xee, 0x1c, 0x7c,
	0x07, 0xf8, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c, 0x3f, 0xf0,
	0x38, 0xe0, 0x38, 0x70, 0x38, 0x38, 0x38, 0x1c,
	0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x1c,
	0x70, 0x0e, 0x70, 0x00, 0x38, 0x00, 0x0f, 0xf0,
	0x00, 0x1c, 0x00, 0x0e, 0x70, 0x0e, 0x38, 0x1c,
	0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x1c, 0x38, 0x0e, 0x70, 0x07, 0xe0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x71, 0x8e, 0x73, 0xce, 0x77, 0xee, 0x3e, 0x7c,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x1c, 0x38, 0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0,
	0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x1c, 0x1c,
	0x0e, 0x38, 0x07, 0x70, 0x03, 0xe0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x0e,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e,
	0x00, 0x0e, 0x00, 0x0e, 0x07, 0xfe, 0x1c, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x3f, 0xfe, 0x38, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x0f, 0xf0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x0f, 0xfe,
	0x00, 0x0e, 0x00, 0x0e, 0x1f, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x3b, 0xf8, 0x3c, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0xe0, 0x0f, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x38, 0x0e, 0x70,
	0x0e, 0xe0, 0x0f, 0xc0, 0x0e, 0xe0, 0x0e, 0x70,
	0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x78, 0x39, 0xce,
	0x39, 0xce, 0x39, 0xce, 0x39, 0xce, 0x39, 0xce,
	0x39, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x38, 0x38,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x1c, 0x3f, 0xf0,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x1c, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x0e, 0x07, 0xfe,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x38, 0x1c,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xfc, 0x38, 0x00,
	0x38, 0x00, 0x0f, 0xf8, 0x00, 0x0e, 0x00, 0x0e,
	0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x1f, 0xfc, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x38, 0x1c,
	0x1c, 0x38, 0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0,
	0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x39, 0xce, 0x3b, 0xee, 0x1f, 0x7c,
	0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x38, 0x0e, 0x70,
	0x07, 0xe0, 0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70,
	0x1c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x1c, 0x1c,
	0x0e, 0x38, 0x07, 0x70, 0x03, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x1c,
	0x00, 0x70, 0x01, 0xc0, 0x07, 0x00, 0x1c, 0x00,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x1e, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0x78,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x9e, 0x3c, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x07, 0x70, 0x1c, 0x1c, 0x70, 0x07,
	0x70, 0x07, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x1c, 0x0e,
	0x38, 0x06, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x06, 0x1c, 0x0e, 0x07, 0xf8,
	0x00, 0x38, 0x00, 0x1c, 0x0f, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x38,
	0x1c, 0x38, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0xe0,
	0x03, 0x80, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x3f, 0xfe, 0x38, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0x70,
	0x1c, 0x1c, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c,
	0x1c, 0x1c, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x01, 0xc0,
	0x00, 0x70, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x0e, 0x38,
	0x03, 0xe0, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x1c,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x1c, 0x0f, 0xf0,
	0x00, 0x70, 0x00, 0x38, 0x0f, 0xf0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0x70,
	0x1c, 0x1c, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x3f, 0xfe, 0x38, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c,
	0x1c, 0x1c, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x3f, 0xfe, 0x38, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x01, 0xc0,
	0x00, 0x70, 0x00, 0x00, 0x0f, 0xf8, 0x38, 0x0e,
	0x38, 0x0e, 0x3f, 0xfe, 0x38, 0x00, 0x38, 0x00,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c,
	0x1c, 0x1c, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0x70,
	0x1c, 0x1c, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x03, 0x80,
	0x00, 0xe0, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x38, 0x1c, 0x38, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38,
	0x38, 0x1c, 0x3f, 0xfc, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x0e, 0x70, 0x03, 0xc0, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x1c, 0x38,
	0x38, 0x1c, 0x3f, 0xfc, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x70, 0x01, 0xc0, 0x07, 0x00, 0x00, 0x00,
	0x3f, 0xfc, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x3f, 0xe0, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x7e, 0x03, 0xc7,
	0x03, 0xc7, 0x7f, 0xfe, 0xe3, 0xc0, 0xe3, 0xc0,
	0x7f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x0e, 0xe0,
	0x1c, 0xe0, 0x38, 0xe0, 0x70, 0xe0, 0x7f, 0xfe,
	0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0,
	0x70, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x07, 0x70,
	0x1c, 0x1c, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c,
	0x1c, 0x1c, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x01, 0xc0,
	0x00, 0x70, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x0e, 0x70,
	0x38, 0x1c, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x03, 0x80,
	0x00, 0xe0, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c,
	0x1c, 0x1c, 0x00, 0x00, 0x38, 0x0e, 0x1c, 0x1c,
	0x0e, 0x38, 0x07, 0x70, 0x03, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00,
	0x07, 0xf0, 0x1c, 0x1c, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0x1c, 0x1c, 0x1c, 0x00, 0x00,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x0f, 0xf8, 0x38, 0x0e, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x1e, 0x0f, 0xf8, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x07, 0x1c,
	0x07, 0x00, 0x07, 0x00, 0x1f, 0xc0, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x3f, 0x0e,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0e, 0x1c, 0x1c,
	0x0e, 0x38, 0x07, 0x70, 0x03, 0xe0, 0x3f, 0xfe,
	0x01, 0xc0, 0x3f, 0xfe, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 0x70, 0xe0,
	0x70, 0x70, 0x70, 0xe0, 0x7f, 0x9c, 0x70, 0x1c,
	0x70, 0x7f, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0xce,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x1f, 0xfc,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x39, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x0e,
	0x0f, 0xfe, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x0f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x00, 0x00, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x0f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x9c,
	0x3c, 0xf0, 0x00, 0x00, 0x3f, 0xe0, 0x38, 0x38,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x38, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x07, 0x9e, 0x3c, 0xf0, 0x00, 0x00,
	0x3c, 0x0e, 0x3e, 0x0e, 0x3f, 0x0e, 0x3b, 0x8e,
	0x39, 0xce, 0x38, 0xee, 0x38, 0x7e, 0x38, 0x3e,
	0x38, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x38, 0x70,
	0x38, 0x70, 0x0f, 0xfc, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x38, 0x70,
	0x38, 0x70, 0x0f, 0xc0, 0x00, 0x00, 0x3f, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x07, 0x00, 0x1c, 0x00, 0x38, 0x1c, 0x1c, 0x38,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff,
	0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x78, 0x00,
	0x38, 0x00, 0x38, 0x1c, 0x38, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x1c, 0x7c, 0x70, 0x0e, 0x00, 0x1c,
	0x00, 0x70, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x78, 0x00,
	0x38, 0x00, 0x38, 0x1c, 0x38, 0x70, 0x01, 0xc0,
	0x07, 0x00, 0x1c, 0x1c, 0x70, 0x7c, 0x01, 0xdc,
	0x01, 0xfe, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x8e, 0x0e, 0x38, 0x38, 0xe0,
	0x0e, 0x38, 0x03, 0x8e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0xe0, 0x0e, 0x38, 0x03, 0x8e,
	0x0e, 0x38, 0x38, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x03, 0x03, 0x30, 0x30, 0x03, 0x03, 0x30, 0x30,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0x33, 0x33, 0xcc, 0xcc, 0x33, 0x33, 0xcc, 0xcc,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0xf3, 0xf3, 0x3f, 0x3f, 0xf3, 0xf3, 0x3f, 0x3f,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0xff, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0xff, 0xc0, 0x01, 0xc0,
	0xff, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0xff, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xf8, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x01, 0xc0,
	0xff, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0xff, 0x38, 0x00, 0x38,
	0xff, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x38,
	0xff, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0xff, 0x38, 0x00, 0x38,
	0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0xff, 0xc0, 0x01, 0xc0,
	0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0xff, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xff, 0x01, 0xc0,
	0x01, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x3f, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x3f, 0x07, 0x00,
	0x07, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x07, 0x00,
	0x07, 0x3f, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0xff, 0x3f, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0x3f, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x3f, 0x07, 0x00,
	0x07, 0x3f, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0xff, 0x3f, 0x00, 0x00,
	0xff, 0x3f, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0xff, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xff, 0x01, 0xc0,
	0x01, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0x01, 0xc0,
	0x01, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0xff, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0xff, 0xff, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x07, 0x38, 0x07, 0x38, 0x07, 0x38, 0x07, 0x38,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0xff, 0xff, 0x01, 0xc0,
	0xff, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xff, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x39, 0xdc,
	0x70, 0xf8, 0x70, 0xf0, 0x70, 0xf8, 0x39, 0xdc,
	0x0f, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xf8, 0x38, 0x0e, 0x38, 0x0e, 0x3f, 0xf8,
	0x38, 0x0e, 0x38, 0x0e, 0x3f, 0xf8, 0x38, 0x00,
	0x38, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x0e, 0x38,
	0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38,
	0x0e, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x38, 0x0e,
	0x38, 0x00, 0x0e, 0x00, 0x03, 0x80, 0x00, 0xe0,
	0x03, 0x80, 0x0e, 0x00, 0x38, 0x00, 0x38, 0x0e,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x1c, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0x70,
	0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e,
	0x0e, 0x0e, 0x0e, 0x1c, 0x0f, 0xf0, 0x0e, 0x00,
	0x0e, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0x9e, 0x3c, 0xf8, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xfc, 0x01, 0xc0,
	0x07, 0xf0, 0x0e, 0x38, 0x1c, 0x1c, 0x1c, 0x1c,
	0x1c, 0x1c, 0x0e, 0x38, 0x07, 0xf0, 0x01, 0xc0,
	0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x3f, 0xfe,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x1c, 0x1c,
	0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x1c, 0x1c,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x1c, 0x1c, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38,
	0x3e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0e, 0x38,
	0x0e, 0x00, 0x03, 0x80, 0x00, 0xe0, 0x07, 0xf8,
	0x1c, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x1c, 0x38,
	0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x7c, 0x73, 0xce,
	0x73, 0xce, 0x73, 0xce, 0x3e, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x00, 0x38, 0x0f, 0xf0, 0x38, 0xfc, 0x71, 0xce,
	0x73, 0x8e, 0x3f, 0x1c, 0x0f, 0xf0, 0x1c, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x0e, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x3f, 0xf0,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x0e, 0x00,
	0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0,
	0x1c, 0x1c, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e, 0x38, 0x0e,
	0x38, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x3f, 0xfe, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x3f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00,
	0x03, 0x80, 0x00, 0xe0, 0x00, 0x38, 0x00, 0xe0,
	0x03, 0x80, 0x0e, 0x00, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
	0x01, 0xc0, 0x07, 0x00, 0x1c, 0x00, 0x07, 0x00,
	0x01, 0xc0, 0x00, 0x70, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x01, 0xc7,
	0x01, 0xc7, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0,
	0x01, 0xc0, 0x01, 0xc0, 0x71, 0xc0, 0x71, 0xc0,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x01, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x07, 0x9e, 0x3c, 0xf0, 0x00, 0x00,
	0x07, 0x9e, 0x3c, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xc0, 0x38, 0x70, 0x38, 0x70,
	0x0f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0,
	0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0xf8, 0x70, 0x1c, 0x70, 0x07, 0x70, 0x01, 0xf0,
	0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0x80, 0x70, 0xe0, 0x70, 0xe0,
	0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0x00, 0xe1, 0xc0, 0x01, 0xc0,
	0x07, 0x00, 0x1c, 0x00, 0x70, 0x00, 0xff, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
