#!/bin/sh

#
# The PowerPanel for Linux Software Installation
#

# MATCH_OS = 0, denote not detect or cannot find linux distribution
# MATCH_OS = 1, maybe is suse, red hat, ubuntu or debian linux distribution
# MATCH_OS = 2, denote arch linux distribution

MATCH_OS=0
DAEMON="pwrstatd"
VAR=`echo $PATH | grep /usr/sbin`
MATCH_RC_PATH=0
RC_DIR=""
START_LN=""
STOP_LN=""
STRATUP_DIR="/etc/init.d"

if [ ${#VAR} = 0 ]; then
	export PATH=$PATH:/usr/sbin
fi

# Remove pwrstatd startup registry
if [ -e $STRATUP_DIR/$DAEMON ]; then

        if [ -e /sbin/chkconfig ]; then
               /sbin/chkconfig --level 2345 $DAEMON off
               /sbin/chkconfig --del $DAEMON
        else 
        	  # for ubuntu/debian linux
	        if [ -e /usr/sbin/sysvconfig ]; then
	        		/usr/sbin/sysvconfig --disable $DAEMON	        
	        fi          
        fi
        
        # stop pwrstatd process
        $STRATUP_DIR/$DAEMON stop
fi

# Terminate pwrstatd process forcedly!
CMD=`ps -A | grep $DAEMON`
if [ ${#CMD} != 0 ]; then		#string length

	if [ -e /sbin/killproc ]; then
		/sbin/killproc -TERM /usr/sbin/$DAEMON
	else
		set -- $CMD    # set result as varable $1 ~ $9(max)		
		kill -TERM $1	# $1 denote process ID(PID)
	fi

	sleep 1 # wait for process terminated

fi


#
# copy files
#

# PowerPanel for Linux client program
/bin/cp bin/pwrstat /usr/sbin

# PowerPanel for Linux daemon program 
/bin/cp bin/pwrstatd /usr/sbin

# Script command for event of power failure 
if [ ! -e /etc/pwrstatd-powerfail.sh ]; then    
	/bin/cp script/pwrstatd-powerfail.sh /etc
fi

# Script command for event of battery low 
if [ ! -e /etc/pwrstatd-lowbatt.sh ]; then    
	/bin/cp script/pwrstatd-lowbatt.sh /etc
fi

# Script command for e-mail notification
if [ ! -e /etc/pwrstatd-email.sh ]; then    
	/bin/cp script/pwrstatd-email.sh /etc
fi

# Script command for execution shutdown when power event occur
if [ ! -e /etc/shutdown.sh ]; then    
	/bin/cp script/shutdown.sh /etc
fi

# Script command for execution hibernate when power event occur
if [ ! -e /etc/hibernate.sh ]; then    
	/bin/cp script/hibernate.sh /etc
fi

# Script command for Daemon startup control

OS=`cat /proc/version | grep -i 'suse'` # ignore uppwr and lower acse
if [ ${#OS} != 0 ]; then		#string length
	/bin/cp script/suse_pwrstatd $STRATUP_DIR/$DAEMON
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'red hat'`
if [ ${#OS} != 0 ]; then		#string length
	/bin/cp script/redhat_pwrstatd $STRATUP_DIR/$DAEMON
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'ubuntu'`
if [ ${#OS} != 0 ]; then		#string length
	/bin/cp script/debian_pwrstatd $STRATUP_DIR/$DAEMON
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'debian'`
if [ ${#OS} != 0 ]; then		#string length
	/bin/cp script/debian_pwrstatd $STRATUP_DIR/$DAEMON
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'arch'`
if [ ${#OS} != 0 ]; then		#string length
	STRATUP_DIR="/etc/rc.d"
	/bin/cp script/arch_pwrstatd $STRATUP_DIR/$DAEMON
	MATCH_OS=2
fi

# have not match any linux OS
if [ $MATCH_OS = 0 ]; then
	/bin/cp script/default_pwrstatd $STRATUP_DIR/$DAEMON
fi

# PowerPanel for Linux daemon configuration
if [ ! -e /etc/pwrstatd.conf ]; then   
	/bin/cp conf/pwrstatd.conf /etc
fi

# PowerPanel for Linux client man-page
if [ ! -e /usr/share/man/man8/pwrstat.8.gz ]; then   
	/bin/cp doc/pwrstat.8 /usr/share/man/man8
fi

# PowerPanel for Linux daemon man-page
if [ ! -e /usr/share/man/man8/pwrstatd.8.gz ]; then   
	/bin/cp doc/pwrstatd.8 /usr/share/man/man8
fi

#
# compress the man page file
#

if [ -e /usr/share/man/man8/pwrstat.8 ]; then
	if [ -e /usr/bin/gzip ]; then
		/usr/bin/gzip -9 /usr/share/man/man8/pwrstat.8
	else
		/bin/gzip -9 /usr/share/man/man8/pwrstat.8
	fi
fi

if [ -e /usr/share/man/man8/pwrstatd.8 ]; then
	if [ -e /usr/bin/gzip ]; then
		/usr/bin/gzip -9 /usr/share/man/man8/pwrstatd.8
	else
		/bin/gzip -9 /usr/share/man/man8/pwrstatd.8
	fi
fi

#
# Change the files owner
#

/bin/chown root:root /usr/sbin/pwrstat
/bin/chown root:root /usr/sbin/pwrstatd
/bin/chown root:root /etc/pwrstatd-powerfail.sh
/bin/chown root:root /etc/pwrstatd-lowbatt.sh
/bin/chown root:root /etc/pwrstatd-email.sh
/bin/chown root:root /etc/shutdown.sh
/bin/chown root:root /etc/hibernate.sh
/bin/chown root:root $STRATUP_DIR/$DAEMON
/bin/chown root:root /etc/pwrstatd.conf
/bin/chown root:root /usr/share/man/man8/pwrstat.8.gz
/bin/chown root:root /usr/share/man/man8/pwrstatd.8.gz

#
# Change the files mode
#

/bin/chmod 700 /usr/sbin/pwrstat
/bin/chmod 700 /usr/sbin/pwrstatd   
/bin/chmod 700 /etc/pwrstatd-powerfail.sh
/bin/chmod 700 /etc/pwrstatd-lowbatt.sh
/bin/chmod 700 /etc/pwrstatd-email.sh
/bin/chmod 700 /etc/shutdown.sh
/bin/chmod 700 /etc/hibernate.sh
/bin/chmod 700 $STRATUP_DIR/$DAEMON    
/bin/chmod 600 /etc/pwrstatd.conf
/bin/chmod 644 /usr/share/man/man8/pwrstat.8.gz
/bin/chmod 644 /usr/share/man/man8/pwrstatd.8.gz

# register to system for startup at system booting
if [ $MATCH_OS = 1 ] && [ -e /sbin/chkconfig ] || [ -e /usr/sbin/sysvconfig ]; then
	if [ -e /sbin/chkconfig ]; then
		/sbin/chkconfig --add $DAEMON
		/sbin/chkconfig --level 2345 $DAEMON on
	else
		# for ubuntu/debian linux
	   if [ -e /usr/sbin/sysvconfig ]; then
	    	/usr/sbin/sysvconfig --enable $DAEMON	        
	   fi      
	fi

elif [ $MATCH_OS = 2 ] && [ -e /etc/rc.conf ]; then

	str=`cat /etc/rc.conf | grep -i "\bDAEMONS *=.*pwrstatd"` # ignore uppwr and lower acse
	if [ ${#str} = 0 ]; then
		/bin/cp /etc/rc.conf /etc/temp.conf
		/bin/sed -e 's/\bDAEMONS *= *(/&pwrstatd /g' /etc/temp.conf > /etc/rc.conf # add pwrstatd daemon
		/bin/rm /etc/temp.conf
	fi

else
	# using update-rc.d create symbolink for debian, ubuntu systems
	# auto add daemon list as "/etc/init.d/.depend.start" after execution update-rc.d
	if [ -e /usr/sbin/update-rc.d ]; then
		update-rc.d $DAEMON defaults 99 99
		# verify
		if [ ! -e /etc/rc2.d/S99$DAEMON ]; then
			for i in 2 3 4 5; do
				/bin/mv "/etc/rc$i.d/S01$DAEMON" "/etc/rc$i.d/S99$DAEMON"
			done
			for i in 0 1 6; do
				/bin/mv "/etc/rc$i.d/K01$DAEMON" "/etc/rc$i.d/K99$DAEMON"
			done
		fi
	else
	# other linux distribution
		for j in 0 1; do
			for i in 2 3 4 5; do	

				if [ $j = 0 ]; then
					RC_DIR="/etc/rc.d/rc$i.d"
				else
					RC_DIR="/etc/rc$i.d"
				fi
				
				START_LN="$RC_DIR/K99$DAEMON"
				STOP_LN="$RC_DIR/S99$DAEMON"
				
				if [ -e $RC_DIR ]; then
					if [ ! -e $START_LN ]; then
						/bin/ln -s $STRATUP_DIR/$DAEMON $START_LN			
					fi
					if [ ! -e $STOP_LN ]; then
						/bin/ln -s $STRATUP_DIR/$DAEMON $STOP_LN			
					fi
				fi
			done
		done
	fi
	if [ ! -e /etc/rc5.d ] && [ ! -e /etc/rc.d/rc5.d ]; then
      		MATCH_RC_PATH=-1
   	fi
fi

# startup daemon immediately
if [ -e $STRATUP_DIR/$DAEMON ]; then
	$STRATUP_DIR/$DAEMON start
fi

# Notice a message 
if [ $MATCH_RC_PATH = 0 ]; then
	/bin/echo "Installation accomplished!"
else
	/bin/echo "Fail to setup daemon startup script when system booting!"
fi

echo

