#!/bin/sh

#
# The PowerPanel for Linux Software Uninstallation
#

# MATCH_OS = 0, denote not detect or cannot find linux distribution
# MATCH_OS = 1, maybe is suse, red hat, ubuntu or debian linux distribution
# MATCH_OS = 2, denote arch linux distribution

MATCH_OS=0
DAEMON="pwrstatd" 
RC_DIR=""
START_LN=""
STOP_LN=""
STRATUP_DIR="/etc/init.d"

# uppercase to lowercase and search keyword string
OS=`cat /proc/version | grep -i 'suse'`
if [ ${#OS} != 0 ]; then
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'red hat'`
if [ ${#OS} != 0 ]; then
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'ubuntu'`
if [ ${#OS} != 0 ]; then
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'debian'`
if [ ${#OS} != 0 ]; then
	MATCH_OS=1
fi

OS=`cat /proc/version | grep -i 'arch'`
if [ ${#OS} != 0 ]; then
	STRATUP_DIR="/etc/rc.d"
	MATCH_OS=2
fi

# have not match any linux OS

# Remove pwrstatd startup registry

if [ $MATCH_OS = 1 ]; then
	if [ -e /sbin/chkconfig ]; then
	    /sbin/chkconfig --level 2345 $DAEMON off
	    /sbin/chkconfig --del $DAEMON
	else 
		  # for ubuntu/debian linux
	    if [ -e /usr/sbin/sysvconfig ]; then
	    		/usr/sbin/sysvconfig --disable $DAEMON	        
	    fi          
	fi
elif [ $MATCH_OS = 2 ] && [ -e /etc/rc.conf ]; then
	/bin/cp /etc/rc.conf /etc/temp.conf
	/bin/sed -e 's/\bpwrstatd *//g' /etc/temp.conf > /etc/rc.conf # remove pwrstatd daemon
	/bin/rm /etc/temp.conf
fi

# Stop the pwrstatd process
if [ -e $STRATUP_DIR/$DAEMON ]; then 
	$STRATUP_DIR/$DAEMON stop
fi


# Terminate pwrstatd process forcedly!
CMD=`ps -A | grep pwrstatd`
if [ ${#CMD} != 0 ]; then
	if [ -e /sbin/killproc ]; then
		/sbin/killproc -TERM /usr/sbin/$DAEMON
	else
		set -- $CMD    # set result as varable $1 ~ $9(max)		
		kill -TERM $1	# $1 denote process ID(PID)
	fi		
fi


#
# remove files
#

# link daemon startup script file in runlevel 
for j in 0 1; do
	for i in 2 3 4 5; do	
		if [ $j = 0 ]; then
			RC_DIR="/etc/rc.d/rc$i.d"
		else
			RC_DIR="/etc/rc$i.d"
		fi
		
		START_LN="$RC_DIR/K99$DAEMON"
		STOP_LN="$RC_DIR/S99$DAEMON"
			
		if [ -e $START_LN ]; then
			/bin/rm $START_LN
		fi
		if [ -e $STOP_LN ]; then
			/bin/rm $STOP_LN
		fi			
	done
done

if [ -e /usr/sbin/update-rc.d ]; then
	/usr/sbin/update-rc.d -f $DAEMON remove
fi

# startup control script
if [ -e $STRATUP_DIR/$DAEMON ]; then
	/bin/rm $STRATUP_DIR/$DAEMON
fi

# The PowerPanel for Linux client program
if [ -e /usr/sbin/pwrstat ]; then
	/bin/rm /usr/sbin/pwrstat
fi

# The PowerPanel for Linux daemon program 
if [ -e /usr/sbin/$DAEMON ]; then
	/bin/rm /usr/sbin/$DAEMON
fi

# power fail action
if [ -e /etc/pwrstatd-powerfail.sh ]; then
	/bin/rm /etc/pwrstatd-powerfail.sh
fi

# battery low action
if [ -e /etc/pwrstatd-lowbatt.sh ]; then
	/bin/rm /etc/pwrstatd-lowbatt.sh
fi

# e-mail action
if [ -e /etc/pwrstatd-email.sh ]; then
	/bin/rm /etc/pwrstatd-email.sh
fi

# shutdown action
if [ -e /etc/shutdown.sh ]; then
	/bin/rm /etc/shutdown.sh
fi

# hibernate action
if [ -e /etc/hibernate.sh ]; then
	/bin/rm /etc/hibernate.sh
fi

# daemon configuration file
if [ -e /etc/pwrstatd.conf ]; then
	/bin/rm /etc/pwrstatd.conf
fi

# daemon log file
if [ -e /var/log/pwrstatd.log ]; then
 	/bin/rm /var/log/pwrstatd.log
fi

# daemon device path file
if [ -e /var/pwrstatd.dev ]; then
 	/bin/rm /var/pwrstatd.dev
fi

# daemon ipc file
if [ -e /var/pwrstatd.ipc ]; then
 	/bin/rm /var/pwrstatd.ipc
fi

# The PowerPanel for Linux client man-page
if [ -e /usr/share/man/man8/pwrstat.8.gz ]; then   
	/bin/rm /usr/share/man/man8/pwrstat.8.gz
fi

# The PowerPanel for Linux daemon man-page
if [ -e /usr/share/man/man8/pwrstatd.8.gz ]; then   
	/bin/rm /usr/share/man/man8/pwrstatd.8.gz
fi

# Notice a message
/bin/echo "Un-installation accomplished!"
