#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

########################################################################
# checks file permissions and ownership in the package doc dir. files
# should all be mode 644, directories should be 755. everything should
# be owned by root:root. also checks for empty files or (possibly)
# install instructions.

# ideally, we'd require all files under the doc dir to be mode 0644.
# however, too many existing packages (including core Slackware
# ones) break that rule. so check for the minimum set of desired
# permissions: a doc file should be readable by all users (at least
# 444), and check that any +x file looks like some kind of script
# (perl/shell/python/etc).

DOCDIR=usr/doc/$PRGNAM-$VERSION

# existence of the doc dir was already checked by a previous test,
# so just don't do anything if it's missing.

if [ -d "$DOCDIR" ]; then
	badpermfiles="$( find $DOCDIR -mindepth 1 -type f -a \! -perm -444 )"
	 badpermdirs="$( find $DOCDIR -mindepth 1 -type d -a \! -perm 0755 )"
	   badowners="$( find $DOCDIR -mindepth 1 -user root -a -group root -o -print )"
	       empty="$( find $DOCDIR -mindepth 1 -empty )"
	       bogus="$( find $DOCDIR -mindepth 1 -maxdepth 1 -type f -a \( -name INSTALL -o -name INSTALL.\* \) )"

	files="$( find $DOCDIR -type f -perm /111 )"
	for f in $files; do
		head -1 $f | grep -q '^#!' && continue;   # script file
		badpermfiles+=" $f"
	done

	[ -n "$badpermfiles" ] && warn "bad file perms (should be 644, or at least 444) in doc dir:" && ls -l $badpermfiles
	[ -n "$badpermdirs"  ] && warn "bad directory perms (should be 755) in doc dir:" && ls -ld $badpermdirs
	[ -n "$badowners"  ]   && warn "bad ownership (should be root:root) in doc dir:" && ls -ld $badowners
	[ -n "$empty"      ]   && warn "empty files/dirs in doc dir: $empty"
	[ -n "$bogus"      ]   && [ -z "$INSTALL_DOCS_OK" ] && warn "useless-looking install instructions in doc dir: $bogus"
fi

# allow /usr/doc/HTML to exist, though we don't check its contents here.
# this is the standard location for KDE5 help files.
baddocs="$( find usr/doc -mindepth 1 -maxdepth 1 \! -name $PRGNAM-$VERSION \! -name HTML )"
[ -n "$baddocs" ]  && warn "docs outside of $DOCDIR:" && ls -ld $baddocs
