#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

########################################################################
# makes sure "noarch" packages really are noarch.
# for packages that aren't noarch, recommend noarch if it looks like one.
# the recommendation is not an error!

elfbins="$( find * -type f -print0 | xargs -0 file -m /etc/file/magic/elf | grep ELF | cut -d: -f1 )"

if [ "$ARCH" = "noarch" ]; then
	[ -n "$elfbins" ] && \
		warn "package claims to be noarch, but contains ELF binaries:" && \
		ls -l $elfbins
elif [ -z "$elfbins" ] && [ ! -e usr/lib ] &&  [ ! -e usr/lib64 ]; then
	x="$( find usr/share/pkgconfig -type f -exec grep 'usr/lib' {} \+ 2>/dev/null )"
	[ -z "$x" ] && note "package might be a good candidate for noarch"
fi
