#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

########################################################################
# check for .la files, according to the Slackware 15.0 guidelines.
# they're not allowed directly in /lib /lib64 /usr/lib /usr/lib64, but
# they're OK in subdirectories (e.g. /usr/lib64/appname/plugins/foo.la).

for i in lib lib64 usr/lib usr/lib64; do
	[ -d "$i" ] || continue
	found="$( find $i -maxdepth 1 -name '*.la' )"
	[ -n "$found" ] && LAFILES+="$found "
done

if [ -n "$LAFILES" ]; then
	warn "package contains .la files:"
	ls -l $LAFILES
fi
