#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

#######################################################################
# if the package contains the usr/man dir, make sure that:
# all the dirs match usr/man/man[1-9n] or usr/man/<locale>/man[1-9n].
# all the files under /usr/man are gzipped and end in <section>.gz.
# all the files under /usr/man have mode 0644. executable man pages
# don't make sense, and man pages that aren't world-readable are
# annoying and wrong.
# all the filenames match the sections (e.g. usr/man/man1/foo.1.gz
# matches, usr/man/man1/bar.2.gz doesn't).
# all the gzipped files look like they contain *roff.

BADPERMS=""
BADDIRPERMS=""
BADDIRS=""
BADNAMES=""
NOTGZIPPED=""
NONTROFF=""
WRONGSECT=""

check_gzipped_page() {
	local f="$1"
	local d="$( dirname $f )"
	local s="$( stat -c '%a %U %G' "$f" )"

	if [ "$s" = "444 root root" ]; then
		: # we could warn here someday
	elif [ "$s" != "644 root root" ]; then
		BADPERMS+="$f "
	fi

	if [ "$( file -L -b --mime-type "$f" )" != "application/gzip" ]; then
		NOTGZIPPED+="$f "
	fi

	# I have ~42,000 man pages on my dev box, file(1) fails to identify
	# 12 of them as troff, but adding the check for .T catches them all.
	if [ "$( file -z -m /etc/file/magic/troff -L -b --mime-type "$f" )" != "text/troff" ]; then
		if ! zgrep -q '^\.T' "$f"; then
			NONTROFF+="$f "
		fi
	fi

	# checking the section is tricky because e.g. /usr/man/man1 may contain
	# files with with names like .1.gz, .1x.gz, .1.pm.gz.

	# if the section in the directory name is bad, don't complain here, it
	# was already reported.
	dir_s="$( echo "$d" | sed -n 's,.*man\([0-9n]\)$,\1,p' )"
	if [ "$dir_s" = "" ]; then
		return
	fi

	s="$( basename "$f" | sed -n 's,.*\.\([0-9n]\)[^.]*\.gz,\1,p' )"
	if [ "$s" = "" ]; then
		BADNAMES+="$f "
	elif [ "$s" != "$dir_s" ]; then
		WRONGSECT+="$f "
	fi
}

# called for paths like /usr/man/de. right now, it accepts names like
# xx_XX or xx.UTF-8, or actually anything whose first 2 characters match
# one of the dirs in /usr/share/locale. could use some refining. I don't
# even know if the *.UTF-8 or *.ISO8859-1 dirs get searched by man-db.
# Note that slackware's own libcdio-paranoia install man pages in
# /usr/man/jp, which is invalid.
check_locale_dir() {
	l="$( echo "$1" | sed 's,^.*/\(..\).*$,\1,' )"
	[ -e /usr/share/locale/"$l" ] || warn "bad locale dir in /usr/man: $l"
}

if [ -d usr/man ]; then
	find usr/man -type f > .manpages.$$
	find usr/man -mindepth 1 -type d > .mandirs.$$

	while read d; do
		case "$d" in
			usr/man/man[1-9n]|usr/man/*/man[1-9n])
				[ "$( stat -c '%a %U %G' "$d" )" != "755 root root" ] && BADDIRPERMS+="$d "
				;;
			usr/man/??*) check_locale_dir "$d" ;;
			*) BADDIRS+="$d " ;;
		esac
	done < .mandirs.$$

	while read f; do
		case "$f" in
			*.gz) check_gzipped_page "$f" ;;
			*) BADNAMES+="$f " ;;
		esac
	done < .manpages.$$

	rm -f .manpages.$$ .mandirs.$$

	[ -n "$BADPERMS" ] && warn "bad man page owner/permissions (should be 0644, root:root)" && ls -ld $BADPERMS
	[ -n "$BADDIRPERMS" ] && warn "bad man directory owner/permissions (should be 0755, root:root)" && ls -ld $BADDIRPERMS
	[ -n "$BADDIRS" ] && warn "bad directory names in /usr/man:" && ls -ld $BADDIRS
	[ -n "$BADNAMES" ] && warn "bad man page names (not *.gz):" && ls -ld $BADNAMES
	[ -n "$NOTGZIPPED" ] && warn "non-gzip (but named *.gz) man pages:" && ls -ld $NOTGZIPPED
	[ -n "$NONTROFF" ] && warn "invalid man pages (not troff):" && ls -ld $NONTROFF
	[ -n "$WRONGSECT" ] && warn "man pages in wrong section:" && ls -ld $WRONGSECT
fi

