#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

#######################################################################
# if the package contains any files in /usr/share/applications/, they
# must be named *.desktop, must pass desktop-file-validate, and must
# be mode 644, owner root:root.

BADPERMS=""
BADDESKTOP=""
NONDESKTOP=""

check_desktop_dir() {
	local dir="$1"
	[ -d "$dir" ] || return

	for f in $dir/*; do
		[ -e "$f" ] || continue

		[ "$f" = "usr/share/applications/mimeinfo.cache" ] && continue
		[ "$f" = "usr/share/applications/screensavers" ] && continue

		[ "$( stat -Lc '%a %U %G' "$f" )" = "644 root root" ] || BADPERMS+="$f "
		case "$f" in
			*.desktop) desktop-file-validate "$f" || BADDESKTOP+="$f " ;;
			*) NONDESKTOP+="$f " ;;
		esac
	done
}

for dir in usr/share/applications usr/share/applications/screensavers; do
	check_desktop_dir "$dir"
done


[ -n "$BADPERMS" ] && warn "bad permissions/owner on .desktop files (should be 0644 root:root):" && ls -ld $BADPERMS
[ -n "$BADDESKTOP" ] && warn ".desktop files fail to validate:" && ls -ld $BADDESKTOP
[ -n "$NONDESKTOP" ] && warn "unknown file (not .desktop) in desktop dir:" && ls -ld $NONDESKTOP
