#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree.

#######################################################################
# check for .new config files. there shouldn't be any, because when
# sbopkglint installed the package, it ran the doinst.sh, which
# should have renamed them.

NEWFILES=""
for f in "$( find -type f -name \*.new )"; do
	[ -z "$f" ] && continue
	case "$f" in
		./usr/doc/*) continue ;;
	esac
	NEWFILES+="$f "
done

[ -n "$NEWFILES" ] && warn "doinst.sh doesn't handle .new config files:" && ls -l $NEWFILES
