#!/bin/sh

# sbopkglint test, must be sourced by sbopkglint (not run standalone).

# PKG, PRGNAM, VERSION, ARCH are set by sbopkglint. also the current
# directory is the root of the installed package tree. This test
# also uses the filename variable.

#######################################################################
# check the doinst.sh. its job is to generate various files by running
# e.g. update-desktop-database, which creates a cache file. if the
# cache file exists, and doinst.sh either doesn't exist, or doesn't
# contain an update-desktop-database, that's very bad: it means
# the cache file is actually included in the package. which means,
# installing such a package would overwrite the user's local cache,
# breaking his desktop, until he fixes it (either manually or giving
# up and logging out or rebooting).

doinst=var/lib/pkgtools/scripts/"$( echo $filename | sed 's,\.[^.]*$,,' )"

have_doinst() {
	[ -e "$doinst" ]
	return $?
}

grep_doinst() {
	have_doinst && grep -q "$@" $doinst
	return $?
}

doinst_warn() {
	local msg="doinst.sh is missing, package needs one, with"
	have_doinst && msg="doinst.sh exists, but is missing"
	warn "$msg $@"
}

doinst_chk_command() {
	local cmd="$1"

	# special case here: allow gtk4-update-icon-cache in place of
	# gtk-update-icon-cache. they work identically, so it doesn't matter.
	[ "$cmd"  = "gtk-update-icon-cache" ] && grep_doinst gtk4-update-icon-cache && return

	grep_doinst "$cmd" || doinst_warn "$cmd"
}

[ "$( find -L usr/share/icons/hicolor -type f 2>/dev/null )" != "" ] && \
	doinst_chk_command "gtk-update-icon-cache"

[ "$( find -L usr/share/applications -type f 2>/dev/null )" != "" ] && \
	doinst_chk_command "update-desktop-database"

[ "$( find -L usr/share/glib-2.0/schemas -type f 2>/dev/null )" != "" ] && \
	doinst_chk_command "glib-compile-schemas"

[ "$( find -L usr/share/fonts -type f 2>/dev/null )" != "" ] && \
	doinst_chk_command "fc-cache"

