#    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

. configure -background #f5f5f5

#fill the  top menu
frame .f_menubar
menubutton .f_menubar.file -text "$i18n_file_menu" -underline 0 -menu .f_menubar.file.menu
menubutton .f_menubar.cd -text CD -underline 0 -menu .f_menubar.cd.menu
menubutton .f_menubar.dvd -text DVD -underline 0 -menu .f_menubar.dvd.menu
menu .f_menubar.file.menu -tearoff 0
menu .f_menubar.cd.menu -tearoff 0
menu .f_menubar.dvd.menu -tearoff 0
.f_menubar.file.menu add command -label "$i18n_load_file_list" -command {load_file_list }
.f_menubar.file.menu add command -label "$i18n_save_file_list" -command {save_file_list }
.f_menubar.file.menu add command -label "$i18n_quit" -command {save_options ; exit }
.f_menubar.cd.menu add command -label "$i18n_cd_copy" -command { disc_copy "cd" }
.f_menubar.cd.menu add command -label "$i18n_create_iso_from_cd" -command { disc_to_iso "cd" }
.f_menubar.cd.menu add command -label "$i18n_erase_cdrw" -command { cd_choose_format }
.f_menubar.dvd.menu add command -label "$i18n_dvd_copy" -command { disc_copy "dvd" }
.f_menubar.dvd.menu add command -label "$i18n_create_iso_from_dvd" -command { disc_to_iso "dvd" }
.f_menubar.dvd.menu add command -label "$i18n_erase_dvdrw" -command { dvd_choose_format }
pack .f_menubar.file .f_menubar.cd .f_menubar.dvd -side left
pack .f_menubar -fill x

frame .f_label_first_step -background #c7d1d1
label .f_label_first_step.l_first_step -bg #c7d1d1 -text "$i18n_step1"

frame .f_first_step -background #f5f5f5
radiobutton .f_first_step.burn_dvd -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_burn_files_and_folders_on_a_dvd" -command refresh_cmd_line -variable burn_type -value burn_dvd
.f_first_step.burn_dvd select

frame .f_first_step_b -background #f5f5f5
button .f_first_step_b.add -highlightbackground blue -text "$i18n_add_files" -width 12 -command { add_file [option add *__tk_filedialog*takeFocus 0; tk_getOpenFile -multiple 1] }
button .f_first_step_b.add_d -highlightbackground blue -text "$i18n_add_directory" -width 12 -command add_d
button .f_first_step_b.delete -highlightbackground blue -text "$i18n_delete_file_dir" -width 12 -command delete_files
button .f_first_step_b.clear -highlightbackground blue -text "$i18n_clear_list" -width 12 -command { set file_list ""; refresh_total_file_size; refresh_cmd_line }
button .f_first_step_b.excluded_files -highlightbackground blue -width 12 -text "$i18n_excluded_files_dir" -command { excluded_file_window }

frame .f_upper_file_list -background #f5f5f5
label .f_upper_file_list.l_file_size -bg #f5f5f5 -text "$i18n_used_space"
entry .f_upper_file_list.show_file_size -relief flat -highlightbackground #f5f5f5 -highlightcolor #f5f5f5 -readonlybackground #f5f5f5 -state readonly -textvariable total_file_size_f -width 10
label .f_upper_file_list.l_space_left -bg #f5f5f5 -text "$i18n_free_space"
entry .f_upper_file_list.show_space_left -relief flat -highlightbackground #f5f5f5 -highlightcolor #f5f5f5 -readonlybackground #f5f5f5 -state readonly -textvariable space_left_f -width 10
button .f_upper_file_list.b_update -highlightbackground blue -text "$i18n_update" -command { refresh_total_file_size }

frame .file_list -bg #f5f5f5
#seems to be necessary to fix an height (for Puppy a least)
listbox .file_list.file_list -bg white -height 8 -listvariable file_list -yscrollcommand { .file_list.scroll_bar set }
scrollbar .file_list.scroll_bar -command { .file_list.file_list yview }

frame .f_only_create_iso -bg #f5f5f5
checkbutton .f_only_create_iso.only_create_iso -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_only_create_iso9660_image" -command refresh_cmd_line -variable v_create_iso -onvalue "yes" -offvalue "no"

frame .f_first_step_iso -background #f5f5f5
radiobutton .f_first_step_iso.b_burn_iso -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_burn_iso9660_image" -command refresh_cmd_line -variable burn_type -value burn_iso
button  .f_first_step_iso.b_open_iso -highlightbackground blue -text "$i18n_open" -state disabled -command choose_iso_file -width 7
entry .f_first_step_iso.iso_file -relief flat -highlightbackground blue -highlightcolor blue -readonlybackground #f5f5f5 -state readonly -textvariable iso_file -width 57

frame .f_label_second_step -background #c7d1d1
label .f_label_second_step.l_second_step -bg #c7d1d1 -text "$i18n_step2"

frame .f_burn_dev -background #f5f5f5
label .f_burn_dev.l_burn_device -bg #f5f5f5 -width 20 -anchor w -text "$i18n_burning_device"
entry .f_burn_dev.burn_device -relief flat -bg white -highlightbackground blue -highlightcolor blue -disabledbackground #f5f5f5 -state normal -textvariable burning_device
.f_burn_dev.burn_device configure -validate focus -validatecommand refresh_cmd_line

frame .f_vol_name -background #f5f5f5
label .f_vol_name.label_vname -bg #f5f5f5 -width 20 -anchor w -text "$i18n_volume_name"
entry .f_vol_name.volume_name -relief flat -bg white -highlightbackground blue -highlightcolor blue  -disabledbackground #f5f5f5 -state normal -textvariable volume_id_o
button .f_vol_name.b_advanced_options -highlightbackground blue -width 15 -text "$i18n_advanced_options_b" -command { advanced_options_window }

frame .f_cmd_line -background #f5f5f5
label .f_cmd_line.label_vid -bg #f5f5f5 -width 20 -anchor w -text "$i18n_command"
entry .f_cmd_line.cmd_line -relief flat -highlightbackground blue -highlightcolor blue -readonlybackground #f5f5f5 -state readonly -textvariable command_line -width 150

frame .f_burn -background #c7d1d1
button .f_burn.go_button -text "$i18n_burn" -highlightbackground red -command { refresh_total_file_size; refresh_cmd_line; launch "burn" "" } -width 7


pack .f_label_first_step.l_first_step -side left
pack .f_label_first_step -fill x

pack .f_first_step.burn_dvd -side left
pack .f_first_step -fill x

pack .f_first_step_b.add -side left -padx {0 10}
pack .f_first_step_b.add_d .f_first_step_b.delete .f_first_step_b.clear .f_first_step_b.excluded_files -side left -padx {10 10} -expand 0
pack .f_first_step_b.excluded_files -side right -padx {10 0}
pack .f_first_step_b -fill x -padx {50 15} -pady {7 3}

pack .f_upper_file_list.l_file_size .f_upper_file_list.show_file_size .f_upper_file_list.l_space_left .f_upper_file_list.show_space_left -side left
if { $option_auto_refresh_space == "0" } { pack .f_upper_file_list.b_update -side left }
pack .f_upper_file_list -fill x -padx {50 0}

pack .file_list.scroll_bar -fill y -side right
pack .file_list.file_list -fill both -expand 1
pack .file_list -fill both -padx {50 15} -expand 1

pack .f_only_create_iso.only_create_iso -side left
pack .f_only_create_iso -fill x -padx {50 0} -pady {0 4}

pack .f_first_step_iso.b_burn_iso -side left
pack .f_first_step_iso.iso_file -side right -padx {12 0}
pack .f_first_step_iso.b_open_iso -side right
pack .f_first_step_iso -fill x -padx {0 15}

pack .f_label_second_step.l_second_step -side left
pack .f_label_second_step -fill x  -pady {12 12}

pack .f_burn_dev.l_burn_device -side left
pack .f_burn_dev.burn_device -side left -padx {0 0}
pack .f_burn_dev -fill x -padx {20 15} -pady {0 10}

pack .f_vol_name.label_vname -side left
pack .f_vol_name.volume_name -side left -padx {0 0}
pack .f_vol_name.b_advanced_options -side right -padx {0 0}
pack .f_vol_name -fill x -padx {20 15} -pady {0 10}

pack .f_cmd_line.label_vid -side left
pack .f_cmd_line.cmd_line -side left -padx {0 0}
pack .f_cmd_line -fill x  -pady {0 10} -padx {20 15}

pack .f_burn.go_button -pady {2 2}
pack .f_burn -fill x
