#!/bin/bash

# uses otf2bdf and bdf2psf to turn a ttf/otf font into a console font.
# all args are passed through to otf2bdf, please don't pass -o file.bdf.

# right now, output is to test.psfu. This will change in the future.

otf2bdf "$@" -c C -o tmp.bdf

# lie to bdf2psf, dirty hack alert! bdf2psf needs the AVERAGE_WIDTH
# to be a multiple of 10. And it messes up the kerning if we don't
# add a fudge factor (the 30, below).
AV=$( sed -n 's,AVERAGE_WIDTH ,,p' tmp.bdf )
AV=$(( ( AV + 30 ) / 10 * 10 ))
sed -i "/AVERAGE_WIDTH/s, .*, $AV," tmp.bdf

SETDIR=/usr/share/bdf2psf

# bdf2psf wants all this crap passed as a single argument with no
# spaces. I need to be able to read and maybe modify the list, so:
SETS="\
$SETDIR/ascii.set+\
$SETDIR/linux.set+\
$SETDIR/fontsets/Lat2.256+\
$SETDIR/fontsets/Uni1.512+\
$SETDIR/useful.set\
"

bdf2psf --fb tmp.bdf $SETDIR/standard.equivalents $SETS 512 test.psfu
